/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons;

import ac.essex.ooechs.imaging.commons.util.Gaussian;
import ac.essex.ooechs.imaging.commons.util.Pythag;

public class ConvolutionMatrix {
    public static final int LAPLACIAN = 1;
    public static final int MEAN = 2;
    public static final int GAUSSIAN = 3;
    public static final int M10 = 4;
    public static final int M11 = 5;
    public static final int M01 = 6;
    public static final int M02 = 7;
    public static final int HORIZONTAL_SOBEL = 8;
    public static final int VERTICAL_SOBEL = 9;
    public static final int HORIZONTAL_SOBEL5 = 10;
    public static final int VERTICAL_SOBEL5 = 11;
    protected double[][] weights;
    protected int width;
    protected int height;
    protected double total;

    public ConvolutionMatrix(int n) {
        switch (n) {
            case 8: {
                this.width = 3;
                this.height = 3;
                this.weights = new double[this.width][this.height];
                this.weights[0][0] = -1.0;
                this.weights[1][0] = -2.0;
                this.weights[2][0] = -1.0;
                this.weights[0][1] = 0.0;
                this.weights[1][1] = 0.0;
                this.weights[2][1] = 0.0;
                this.weights[0][2] = 1.0;
                this.weights[1][2] = 2.0;
                this.weights[2][2] = 1.0;
                this.total = 1.0;
                break;
            }
            case 9: {
                this.width = 3;
                this.height = 3;
                this.weights = new double[this.width][this.height];
                this.weights[0][0] = 1.0;
                this.weights[1][0] = 0.0;
                this.weights[2][0] = -1.0;
                this.weights[0][1] = 2.0;
                this.weights[1][1] = 0.0;
                this.weights[2][1] = -2.0;
                this.weights[0][2] = 1.0;
                this.weights[1][2] = 0.0;
                this.weights[2][2] = -1.0;
                this.total = 1.0;
                break;
            }
            case 11: {
                this.width = 5;
                this.height = 5;
                this.weights = new double[][]{{-1.0, -4.0, -6.0, -4.0, -1.0}, {-2.0, -8.0, -12.0, -8.0, -2.0}, {0.0, 0.0, 0.0, 0.0, 0.0}, {2.0, 8.0, 12.0, 8.0, 2.0}, {1.0, 4.0, 6.0, 4.0, 1.0}};
                this.total = 1.0;
                break;
            }
            case 10: {
                this.width = 5;
                this.height = 5;
                this.weights = new double[][]{{1.0, 2.0, 0.0, -2.0, -1.0}, {4.0, 8.0, 0.0, -8.0, -4.0}, {6.0, 12.0, 0.0, -12.0, -6.0}, {4.0, 8.0, 0.0, -8.0, -4.0}, {1.0, 2.0, 0.0, -2.0, -1.0}};
                this.total = 1.0;
                break;
            }
            case 1: {
                this.width = 3;
                this.height = 3;
                this.weights = new double[this.width][this.height];
                this.weights[0][0] = -1.0;
                this.weights[1][0] = -1.0;
                this.weights[2][0] = -1.0;
                this.weights[0][1] = -1.0;
                this.weights[1][1] = 8.0;
                this.weights[2][1] = -1.0;
                this.weights[0][2] = -1.0;
                this.weights[1][2] = -1.0;
                this.weights[2][2] = -1.0;
                this.total = 1.0;
                break;
            }
            case 2: {
                double d;
                this.width = 3;
                this.height = 3;
                this.weights = new double[this.width][this.height];
                this.weights[0][0] = d = 0.1111111111111111;
                this.weights[1][0] = d;
                this.weights[2][0] = d;
                this.weights[0][1] = d;
                this.weights[1][1] = d;
                this.weights[2][1] = d;
                this.weights[0][2] = d;
                this.weights[1][2] = d;
                this.weights[2][2] = d;
                this.total = 1.0;
                break;
            }
            case 3: {
                this.width = 9;
                this.height = 9;
                this.weights = new double[this.width][this.height];
                Gaussian gaussian = new Gaussian(1.4, 0.0);
                for (int i = -1; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        double d = Pythag.distance(j, i);
                        double d2 = gaussian.getY(d) * 15.0;
                        this.total += d2;
                        this.weights[j + 2][i + 2] = d2;
                    }
                }
            }
            case 4: {
                this.width = 3;
                this.height = 3;
                this.weights = new double[this.width][this.height];
                this.weights[0][0] = -1.0;
                this.weights[1][0] = -1.0;
                this.weights[2][0] = -1.0;
                this.weights[0][1] = 0.0;
                this.weights[1][1] = 0.0;
                this.weights[2][1] = 0.0;
                this.weights[0][2] = 1.0;
                this.weights[1][2] = 1.0;
                this.weights[2][2] = 1.0;
                this.total = 1.0;
                break;
            }
            case 5: {
                this.width = 3;
                this.height = 3;
                this.weights = new double[this.width][this.height];
                this.weights[0][0] = 1.0;
                this.weights[1][0] = 0.0;
                this.weights[2][0] = -1.0;
                this.weights[0][1] = 0.0;
                this.weights[1][1] = 0.0;
                this.weights[2][1] = 0.0;
                this.weights[0][2] = -1.0;
                this.weights[1][2] = 0.0;
                this.weights[2][2] = 1.0;
                this.total = 1.0;
                break;
            }
            case 6: {
                this.width = 3;
                this.height = 3;
                this.weights = new double[this.width][this.height];
                this.weights[0][0] = -1.0;
                this.weights[1][0] = 0.0;
                this.weights[2][0] = 1.0;
                this.weights[0][1] = -1.0;
                this.weights[1][1] = 0.0;
                this.weights[2][1] = 1.0;
                this.weights[0][2] = -1.0;
                this.weights[1][2] = 0.0;
                this.weights[2][2] = 1.0;
                this.total = 1.0;
                break;
            }
            case 7: {
                this.width = 3;
                this.height = 3;
                this.weights = new double[this.width][this.height];
                this.weights[0][0] = 1.0;
                this.weights[1][0] = 0.0;
                this.weights[2][0] = 1.0;
                this.weights[0][1] = 1.0;
                this.weights[1][1] = 0.0;
                this.weights[2][1] = 1.0;
                this.weights[0][2] = 1.0;
                this.weights[1][2] = 0.0;
                this.weights[2][2] = 1.0;
                this.total = 1.0;
            }
        }
    }

    public double getTotal() {
        return this.total;
    }

    public void setValue(int n, int n2, double d) {
        this.weights[n][n2] = d;
    }

    public double getWeight(int n, int n2) {
        return this.weights[n][n2];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

