/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.SimpleImage;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import java.io.File;

public class HaarRegions
implements SimpleImage {
    protected PixelLoader image;
    protected int imageWidth;
    protected int imageHeight;
    public static final int HORIZONTALLY_ADJACENT = 1;
    public static final int VERTICALLY_ADJACENT = 2;
    public static final int FIRST_SHAPE = 1;
    public static final int SECOND_SHAPE = 2;
    public static final int DEFAULT_WINDOW_WIDTH = 32;
    public static final int DEFAULT_WINDOW_HEIGHT = 40;
    public static final int DEFAULT_BLOCKS_X = 16;
    public static final int DEFAULT_BLOCKS_Y = 20;
    protected int windowBlocksX = 16;
    protected int windowBlocksY = 20;
    protected int windowWidth = 32;
    protected int windowHeight = 40;
    protected int windowX = 0;
    protected int windowY = 0;
    private int blockWidth;
    private int blockHeight;
    protected int[][] integralImage;

    public static void main(String[] stringArray) throws Exception {
        File file = new File("/home/ooechs/Data/faces");
        PixelLoader pixelLoader = new PixelLoader(new File(file, "blended.bmp"));
        HaarRegions haarRegions = new HaarRegions(pixelLoader);
        haarRegions.makeWindowFillImage(19, 19);
        System.out.println(haarRegions.getOneRectangleFeature(16, 0, 1, 2));
    }

    public PixelLoader getPixelLoader() {
        return this.image;
    }

    public void makeWindowFillImage(int n, int n2) {
        this.setWindowPosition(0, 0, this.image.getWidth(), this.image.getHeight(), n, n2);
    }

    public void setWindowPosition(int n, int n2) {
        if (n > this.image.getWidth() - this.windowWidth) {
            throw new RuntimeException("WindowX is too large - the window is outside the image boundary. (windowX=" + n + ", imageWidth=" + this.image.getWidth() + ", windowWidth=" + this.windowWidth + ")");
        }
        if (n2 > this.image.getHeight() - this.windowHeight) {
            throw new RuntimeException("WindowY is too large - the window is outside the image boundary. (windowY=" + n2 + ", imageHeight=" + this.image.getHeight() + ", windowHeight=" + this.windowHeight + ")");
        }
        this.windowX = n;
        this.windowY = n2;
    }

    public void setWindowPosition(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 % n5 != 0) {
            throw new RuntimeException(this.image.getFile().getName() + ": The window's width (" + n3 + ") does not divide evenly into " + n5 + " vertical segments.");
        }
        if (n4 % n6 != 0) {
            throw new RuntimeException(this.image.getFile().getName() + ": The window's height (" + n4 + ") does not divide evenly into " + n6 + " horizontal segments.");
        }
        if (n3 > this.image.getWidth()) {
            throw new RuntimeException(this.image.getFile().getName() + ": Window is wider (" + n3 + ") than the image (" + this.getWidth() + ")");
        }
        if (n4 > this.image.getHeight()) {
            throw new RuntimeException(this.image.getFile().getName() + ": Window is taller (" + n4 + ") than the image (" + this.getHeight() + ")");
        }
        this.windowWidth = n3;
        this.windowHeight = n4;
        this.setWindowPosition(n, n2);
        this.windowBlocksX = n5;
        this.windowBlocksY = n6;
        this.blockWidth = n3 / n5;
        this.blockHeight = n4 / n6;
    }

    public int getActualPositionX(int n) {
        return this.windowX + n * this.blockWidth;
    }

    public int getActualPositionY(int n) {
        return this.windowY + n * this.blockHeight;
    }

    public HaarRegions(PixelLoader pixelLoader) {
        this.integralImage = this.getIntegralImage(pixelLoader, 1, 1);
        this.image = pixelLoader;
        this.imageWidth = pixelLoader.getWidth();
        this.imageHeight = pixelLoader.getHeight();
    }

    private int[][] getIntegralImage(PixelLoader pixelLoader, int n, int n2) {
        int[][] nArray = new int[pixelLoader.getWidth() / n + 1][pixelLoader.getHeight() / n2 + 1];
        int n3 = 1;
        for (int i = 0; i < pixelLoader.getWidth(); i += n) {
            int n4 = 0;
            int n5 = 1;
            for (int j = 0; j < pixelLoader.getHeight(); j += n2) {
                for (int k = 0; k < n; ++k) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        n4 += pixelLoader.getGreyValue(i + k, j + i2);
                    }
                }
                nArray[n3][n5] = (n3 == 0 ? 0 : nArray[n3 - 1][n5]) + n4;
                ++n5;
            }
            ++n3;
        }
        return nArray;
    }

    public int getRegionSum(int n, int n2, int n3, int n4) {
        int n5 = this.integralImage[n][n2];
        int n6 = this.integralImage[n + n3][n2];
        int n7 = this.integralImage[n][n2 + n4];
        int n8 = this.integralImage[n][n2];
        return n8 - n6 - n7 + n5;
    }

    public float getOneRectangleFeature(int n, int n2, int n3, int n4) {
        try {
            if (n + n3 > this.windowBlocksX) {
                if (n3 > this.windowBlocksX) {
                    return -1.0f;
                }
                n = this.windowBlocksX - n3;
            }
            if (n2 + n4 > this.windowBlocksY) {
                if (n4 > this.windowBlocksY) {
                    return -1.0f;
                }
                n2 = this.windowBlocksY - n4;
            }
            float f = n3 * this.blockWidth * (n4 * this.blockHeight);
            int n5 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2)];
            int n6 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2)];
            int n7 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2 + n4)];
            int n8 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2 + n4)];
            int n9 = n8 - n6 - n7 + n5;
            return (float)n9 / f;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Array Index Out of Bounds\n----------");
            System.out.println("Image width: " + this.getWidth());
            System.out.println("Image height: " + this.getHeight());
            System.out.println("X: " + n);
            System.out.println("Y: " + n2);
            System.out.println("Width: " + n3);
            System.out.println("Height: " + n4);
            throw arrayIndexOutOfBoundsException;
        }
    }

    public double getOneRectangleMin(int n, int n2, int n3, int n4) {
        if (n + n3 > this.windowBlocksX) {
            if (n3 > this.windowBlocksX) {
                System.err.println("Width is too much!" + n3 + " > " + this.windowBlocksX);
                return -1.0;
            }
            n = this.windowBlocksX - n3;
        }
        if (n2 + n4 > this.windowBlocksY) {
            if (n4 > this.windowBlocksY) {
                System.err.println("Height is too much!" + n4 + " > " + this.windowBlocksY);
                return -1.0;
            }
            n2 = this.windowBlocksY - n4;
        }
        n = this.getActualPositionX(n);
        n2 = this.getActualPositionY(n2);
        int n5 = 256;
        for (int i = n2; i < n2 + n4 * this.blockHeight; ++i) {
            for (int j = n; j < n + n3 * this.blockWidth; ++j) {
                if (this.image.getGreyValue(j, i) >= n5) continue;
                n5 = this.image.getGreyValue(j, i);
            }
        }
        return n5;
    }

    public double getOneRectangleMax(int n, int n2, int n3, int n4) {
        if (n + n3 > this.windowBlocksX) {
            if (n3 > this.windowBlocksX) {
                return -1.0;
            }
            n = this.windowBlocksX - n3;
        }
        if (n2 + n4 > this.windowBlocksY) {
            if (n4 > this.windowBlocksY) {
                return -1.0;
            }
            n2 = this.windowBlocksY - n4;
        }
        n = this.getActualPositionX(n);
        n2 = this.getActualPositionY(n2);
        int n5 = 0;
        for (int i = n2; i < n2 + n4 * this.blockHeight; ++i) {
            for (int j = n; j < n + n3 * this.blockWidth; ++j) {
                if (this.image.getGreyValue(j, i) <= n5) continue;
                n5 = this.image.getGreyValue(j, i);
            }
        }
        return n5;
    }

    public double getOneRectangleStdDev(int n, int n2, int n3, int n4) {
        if (n + n3 > this.windowBlocksX) {
            if (n3 > this.windowBlocksX) {
                return -1.0;
            }
            n = this.windowBlocksX - n3;
        }
        if (n2 + n4 > this.windowBlocksY) {
            if (n4 > this.windowBlocksY) {
                return -1.0;
            }
            n2 = this.windowBlocksY - n4;
        }
        n = this.getActualPositionX(n);
        n2 = this.getActualPositionY(n2);
        FastStatistics fastStatistics = new FastStatistics();
        for (int i = n2; i < n2 + n4 * this.blockHeight; ++i) {
            for (int j = n; j < n + n3 * this.blockWidth; ++j) {
                fastStatistics.addData(this.image.getGreyValue(j, i));
            }
        }
        return fastStatistics.getStandardDeviation();
    }

    public float getTwoRectangleFeature(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == 1) {
            if (n + n3 + n3 > this.windowBlocksX) {
                if (n3 + n3 > this.windowBlocksX) {
                    return -1.0f;
                }
                n = this.windowBlocksX - 2 * n3;
            }
            if (n2 + n4 > this.windowBlocksY) {
                if (n4 > this.windowBlocksY) {
                    return -1.0f;
                }
                n2 = this.windowBlocksY - n4;
            }
            int n7 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2)];
            int n8 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2)];
            int n9 = this.integralImage[this.getActualPositionX(n + n3 + n3)][this.getActualPositionY(n2)];
            int n10 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2 + n4)];
            int n11 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2 + n4)];
            int n12 = this.integralImage[this.getActualPositionX(n + n3 + n3)][this.getActualPositionY(n2 + n4)];
            int n13 = n11 - n8 - n10 + n7;
            int n14 = n12 - n9 - n11 + n8;
            float f = n3 * this.blockWidth * (n4 * this.blockHeight);
            return (float)(n6 == 1 ? n13 - n14 : n14 - n13) / (1.0f * f);
        }
        if (n + n3 > this.windowBlocksX) {
            if (n3 > this.windowBlocksX) {
                return -1.0f;
            }
            n = this.windowBlocksX - n3;
        }
        if (n2 + n4 + n4 > this.windowBlocksY) {
            if (n4 + n4 > this.windowBlocksY) {
                return -1.0f;
            }
            n2 = this.windowBlocksY - 2 * n4;
        }
        int n15 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2)];
        int n16 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2)];
        int n17 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2 + n4)];
        int n18 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2 + n4)];
        int n19 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2 + n4 + n4)];
        int n20 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2 + n4 + n4)];
        int n21 = n18 - n16 - n17 + n15;
        int n22 = n20 - n18 - n19 + n17;
        float f = n3 * this.blockWidth * (n4 * this.blockHeight);
        return (float)(n6 == 1 ? n21 - n22 : n22 - n21) / (1.0f * f);
    }

    public float getThreeRectangleFeature(int n, int n2, int n3, int n4, int n5) {
        if (n5 == 1) {
            if (n3 * 3 > this.getWindowBlocksX()) {
                n3 = this.getWindowBlocksX() / 3;
            }
            if (n + 3 * n3 > this.windowBlocksX) {
                n = this.windowBlocksX - 3 * n3;
            }
            if (n2 + n4 + 1 > this.windowBlocksY) {
                n2 = this.windowBlocksY - n4;
            }
            int n6 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2)];
            int n7 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2)];
            int n8 = this.integralImage[this.getActualPositionX(n + n3 + n3)][this.getActualPositionY(n2)];
            int n9 = this.integralImage[this.getActualPositionX(n + n3 + n3 + n3)][this.getActualPositionY(n2)];
            int n10 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2 + n4)];
            int n11 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2 + n4)];
            int n12 = this.integralImage[this.getActualPositionX(n + n3 + n3)][this.getActualPositionY(n2 + n4)];
            int n13 = this.integralImage[this.getActualPositionX(n + n3 + n3 + n3)][this.getActualPositionY(n2 + n4)];
            int n14 = n11 - n7 - n10 + n6;
            int n15 = n12 - n8 - n11 + n7;
            int n16 = n13 - n9 - n12 + n8;
            float f = n3 * this.blockWidth * (n4 * this.blockHeight);
            return (float)(n14 + n16 - n15) / f;
        }
        if (n4 * 3 > this.windowBlocksY) {
            n4 = this.getWindowBlocksY() / 3;
        }
        if (n + n3 + 1 > this.windowBlocksX) {
            n = this.windowBlocksX - n3;
        }
        if (n2 + 3 * n4 + 1 > this.windowBlocksY) {
            n2 = this.windowBlocksY - 3 * n4;
        }
        int n17 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2)];
        int n18 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2)];
        int n19 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2 + n4)];
        int n20 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2 + n4)];
        int n21 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2 + n4 + n4)];
        int n22 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2 + n4 + n4)];
        int n23 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2 + n4 + n4 + n4)];
        int n24 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2 + n4 + n4 + n4)];
        int n25 = n20 - n18 - n19 + n17;
        int n26 = n22 - n20 - n21 + n19;
        int n27 = n24 - n22 - n23 + n21;
        float f = n3 * this.blockWidth * (n4 * this.blockHeight);
        return (float)(n25 + n27 - n26) / (2.0f * f);
    }

    public float getFourRectangleFeature(int n, int n2, int n3, int n4, int n5) {
        try {
            if (n + 2 * n3 + 1 > this.windowBlocksX) {
                if (n3 * 2 > this.windowBlocksX) {
                    n3 = this.windowBlocksX / 2;
                }
                n = this.windowBlocksX - 2 * n3;
            }
            if (n2 + 2 * n4 + 1 > this.windowBlocksY) {
                if (n4 * 2 > this.windowBlocksY) {
                    n4 = this.windowBlocksY / 2;
                }
                n2 = this.windowBlocksY - 2 * n4;
            }
            int n6 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2)];
            int n7 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2)];
            int n8 = this.integralImage[this.getActualPositionX(n + n3 + n3)][this.getActualPositionY(n2)];
            int n9 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2 + n4)];
            int n10 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2 + n4)];
            int n11 = this.integralImage[this.getActualPositionX(n + n3 + n3)][this.getActualPositionY(n2 + n4)];
            int n12 = this.integralImage[this.getActualPositionX(n)][this.getActualPositionY(n2 + n4 + n4)];
            int n13 = this.integralImage[this.getActualPositionX(n + n3)][this.getActualPositionY(n2 + n4 + n4)];
            int n14 = this.integralImage[this.getActualPositionX(n + n3 + n3)][this.getActualPositionY(n2 + n4 + n4)];
            int n15 = n14 - n8 - n12 + n6;
            float f = n3 * this.blockWidth * (n4 * this.blockHeight);
            if (n5 == 1) {
                int n16 = n10 - n7 - n9 + n6;
                int n17 = n14 - n11 - n13 + n10;
                return (float)(n15 - 2 * (n16 + n17)) / (2.0f * f);
            }
            int n18 = n11 - n8 - n10 + n7;
            int n19 = n13 - n10 - n12 + n9;
            return (float)(n15 - 2 * (n18 + n19)) / (2.0f * f);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("Array index out of bounds");
            System.out.println("x: " + n);
            System.out.println("y: " + n2);
            System.out.println("width: " + n3);
            System.out.println("height: " + n4);
            if (n + 2 * n3 + 1 > this.windowBlocksX) {
                n = this.windowBlocksX - 2 * n3;
            }
            if (n2 + 2 * n4 + 1 > this.windowBlocksY) {
                n2 = this.windowBlocksY - 2 * n4;
            }
            System.out.println("x: " + n);
            System.out.println("y: " + n2);
            throw arrayIndexOutOfBoundsException;
        }
    }

    public int getWindowBlocksX() {
        return this.windowBlocksX;
    }

    public int getWindowBlocksY() {
        return this.windowBlocksY;
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public int getWindowX() {
        return this.windowX;
    }

    public int getWindowY() {
        return this.windowY;
    }

    @Override
    public int getWidth() {
        return this.imageWidth;
    }

    @Override
    public int getHeight() {
        return this.imageHeight;
    }

    public File getFile() {
        return this.image.getFile();
    }

    @Override
    public String getFilename() {
        return this.getFile().getName();
    }
}

