/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.StatisticsSolver;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JFrame;

public class ImageBlender {
    StatisticsSolver solver;

    public static void main(String[] stringArray) throws Exception {
        File file = new File("/home/ooechs/Data/faces/train/face");
        new ImageBlender(19, 19, file);
    }

    public ImageBlender(int n, int n2, File file) throws Exception {
        int n3;
        if (!file.exists()) {
            throw new RuntimeException("Directory does not exist.");
        }
        FastStatistics[][] fastStatisticsArray = new FastStatistics[n][n2];
        File[] fileArray = file.listFiles();
        int n4 = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!ImageFilenameFilter.isImage(file2)) continue;
            PixelLoader pixelLoader = new PixelLoader(file2);
            for (n3 = 0; n3 < n2; ++n3) {
                for (int j = 0; j < n; ++j) {
                    if (fastStatisticsArray[j][n3] == null) {
                        fastStatisticsArray[j][n3] = new FastStatistics();
                    }
                    fastStatisticsArray[j][n3].addData(pixelLoader.getGreyValue(j, n3));
                }
            }
            System.out.print(".");
            if (++n4 <= 50) continue;
            System.out.println();
            n4 = 0;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                n3 = (int)fastStatisticsArray[j][i].getMean();
                bufferedImage.setRGB(j, i, new Color(n3, n3, n3).getRGB());
            }
        }
        new DisplayFrame(bufferedImage);
    }

    class DisplayFrame
    extends JFrame {
        public DisplayFrame(BufferedImage bufferedImage) {
            super("Blended Image");
            Container container = this.getContentPane();
            ImagePanel imagePanel = new ImagePanel();
            imagePanel.setImage(bufferedImage);
            container.add(imagePanel);
            this.setSize(640, 480);
            this.setVisible(true);
        }
    }
}

