/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons;

import ac.essex.ooechs.imaging.commons.ColourConvertor;
import ac.essex.ooechs.imaging.commons.ConvolutionMatrix;
import ac.essex.ooechs.imaging.commons.ImageWindow;
import ac.essex.ooechs.imaging.commons.SimpleImage;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.fast.IntegralImage;
import ac.essex.ooechs.imaging.commons.texture.Line;
import ac.essex.ooechs.imaging.commons.texture.Perimeter;
import ac.essex.ooechs.imaging.commons.util.Median;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;

public class PixelLoader
implements Cloneable,
SimpleImage {
    protected BufferedImage img;
    protected File file = null;
    protected int width;
    protected int height;
    public boolean loadedOK = true;
    protected IntegralImage integralImage;
    protected Perimeter perimeter1;
    protected Perimeter perimeter2;
    public static int feature1Size = 2;
    public static int feature2Size = 5;
    protected Line hLine1;
    protected Line hLine2;
    protected Line vLine1;
    protected Line vLine2;
    private int lightnessMean = -1;
    private double lightnessStdDeviation = -1.0;
    private int hueMean = -1;
    private double hueStdDeviation = -1.0;
    private int satMean = -1;
    private double satStdDeviation = -1.0;
    private double greyStdDeviation = -1.0;
    private int rMax;
    private int rMin;
    private int gMax;
    private int gMin;
    private int bMax;
    private int bMin;
    private int[] greyColourCache;
    private int[] redColourCache;
    private int[] greenColourCache;
    private int[] blueColourCache;
    private int[] hueCache;
    private int[] satCache;
    private int[] lightnessCache;
    private ConvolutionMatrix verticalSobel;
    private ConvolutionMatrix horizontalSobel;
    private ConvolutionMatrix laplacian;
    private int[][] vsobelCache;
    private int[][] hsobelCache;
    private int[][] laplacianCache;
    public float[][] varianceCache;
    public static int size = 1;
    private int[] rangeCache;
    private float[] meanCache;
    public static final int HARALICK_CONTRAST = 1;
    public static final int HARALICK_DISSIMILARITY = 2;
    public static final int HARALICK_UNIFORMITY = 3;
    public static final int HARALICK_MAXIMUM_PROBABILITY = 4;
    public static final int HARALICK_ENTROPY = 5;
    public static final int VARIANCE = 6;
    public static final int HARALICK_SIZE = 8;
    final int GLCM_SIZE = 16;
    final int GLCM_QUANTISATION = 16;

    private PixelLoader() {
        this.loadedOK = true;
    }

    public PixelLoader(int n, int n2) {
        this.file = null;
        this.img = new BufferedImage(n, n2, 1);
        this.width = n;
        this.height = n2;
        this.loadedOK = true;
    }

    public PixelLoader(String string) throws Exception {
        this(new File(string));
    }

    public PixelLoader(InputStream inputStream) {
        try {
            this.file = null;
            this.img = ImageIO.read(inputStream);
            this.width = this.img.getWidth();
            this.height = this.img.getHeight();
        }
        catch (IIOException iIOException) {
            iIOException.printStackTrace();
            this.loadedOK = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.loadedOK = false;
        }
        if (this.img == null) {
            throw new RuntimeException("No Buffered Image in Pixel Loader. Image may not have loaded OK. Try a different file type?");
        }
    }

    public PixelLoader(File file) throws Exception {
        if (!file.exists()) {
            throw new Exception("File does not exist: " + file.getAbsolutePath());
        }
        try {
            this.file = file;
            this.img = ImageIO.read(file);
            this.width = this.img.getWidth();
            this.height = this.img.getHeight();
        }
        catch (IIOException iIOException) {
            iIOException.printStackTrace();
            this.loadedOK = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.loadedOK = false;
        }
        if (this.img == null) {
            throw new RuntimeException("No Buffered Image in Pixel Loader. Image may not have loaded OK. Try a different file type?");
        }
    }

    public PixelLoader(BufferedImage bufferedImage) {
        this.img = bufferedImage;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        this.loadedOK = true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public IntegralImage getIntegralImage() {
        if (this.integralImage == null) {
            this.integralImage = new IntegralImage(this);
        }
        return this.integralImage;
    }

    public Perimeter getPerimeter1() {
        if (this.perimeter1 == null) {
            this.perimeter1 = new Perimeter(feature1Size);
        }
        return this.perimeter1;
    }

    public Perimeter getPerimeter2() {
        if (this.perimeter2 == null) {
            this.perimeter2 = new Perimeter(feature2Size);
        }
        return this.perimeter2;
    }

    public Line getHLine1() {
        if (this.hLine1 == null) {
            this.hLine1 = new Line(feature1Size, 1);
        }
        return this.hLine1;
    }

    public Line getHLine2() {
        if (this.hLine2 == null) {
            this.hLine2 = new Line(feature2Size, 1);
        }
        return this.hLine2;
    }

    public Line getVLine1() {
        if (this.vLine1 == null) {
            this.vLine1 = new Line(feature1Size, 2);
        }
        return this.vLine1;
    }

    public Line getVLine2() {
        if (this.vLine2 == null) {
            this.vLine2 = new Line(feature2Size, 2);
        }
        return this.vLine2;
    }

    public int getLightnessMean() {
        if (this.lightnessMean == -1) {
            this.calculateImageStatistics();
        }
        return this.lightnessMean;
    }

    public double getLightnessStdDeviation() {
        if (this.lightnessStdDeviation == -1.0) {
            this.calculateImageStatistics();
        }
        return this.lightnessStdDeviation;
    }

    public int getHueMean() {
        if (this.hueMean == -1) {
            this.calculateImageStatistics();
        }
        return this.hueMean;
    }

    public double getHueStdDeviation() {
        if (this.hueStdDeviation == -1.0) {
            this.calculateImageStatistics();
        }
        return this.hueStdDeviation;
    }

    public int getSatMean() {
        if (this.satMean == -1) {
            this.calculateImageStatistics();
        }
        return this.satMean;
    }

    public double getSatStdDeviation() {
        if (this.satStdDeviation == -1.0) {
            this.calculateImageStatistics();
        }
        return this.satStdDeviation;
    }

    public double getStdDeviation() {
        if (this.greyStdDeviation == -1.0) {
            FastStatistics fastStatistics = new FastStatistics();
            for (int i = 0; i < this.getHeight(); ++i) {
                for (int j = 0; j < this.getWidth(); ++j) {
                    fastStatistics.addData(this.getGreyValue(j, i));
                }
            }
            this.greyStdDeviation = fastStatistics.getStandardDeviation();
        }
        return this.greyStdDeviation;
    }

    private void calculateImageStatistics() {
        FastStatistics fastStatistics = new FastStatistics();
        FastStatistics fastStatistics2 = new FastStatistics();
        FastStatistics fastStatistics3 = new FastStatistics();
        if (this.hueCache == null) {
            this.createHSLCache();
        }
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                fastStatistics.addData(this.hueCache[n]);
                fastStatistics2.addData(this.satCache[n]);
                fastStatistics3.addData(this.lightnessCache[n]);
                ++n;
            }
        }
        this.lightnessMean = (int)fastStatistics3.getMean();
        this.lightnessStdDeviation = (int)fastStatistics3.getStandardDeviation();
        this.hueMean = (int)fastStatistics.getMean();
        this.hueStdDeviation = (int)fastStatistics.getStandardDeviation();
        this.satMean = (int)fastStatistics2.getMean();
        this.satStdDeviation = (int)fastStatistics2.getStandardDeviation();
    }

    public PixelLoader getSubImage(ImageWindow imageWindow) {
        PixelLoader pixelLoader = new PixelLoader();
        pixelLoader.file = this.file;
        pixelLoader.img = this.img.getSubimage(imageWindow.left, imageWindow.top, imageWindow.width, imageWindow.height);
        pixelLoader.width = imageWindow.width;
        pixelLoader.height = imageWindow.height;
        return pixelLoader;
    }

    public BufferedImage getBufferedImage() {
        return this.img;
    }

    public FastStatistics getStatistics(int n) {
        FastStatistics fastStatistics = new FastStatistics();
        if (this.greyColourCache == null) {
            this.createRGBCache();
        }
        int n2 = this.width * this.height;
        switch (n) {
            case 0: {
                for (int i = 0; i < n2; ++i) {
                    fastStatistics.addData(this.greyColourCache[i]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n2; ++i) {
                    fastStatistics.addData(this.redColourCache[i]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    fastStatistics.addData(this.greenColourCache[i]);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n2; ++i) {
                    fastStatistics.addData(this.blueColourCache[i]);
                }
                break;
            }
        }
        return fastStatistics;
    }

    public Color getColor(int n, int n2) {
        return new Color(this.img.getRGB(n, n2));
    }

    public int getRGB(int n, int n2) {
        return this.img.getRGB(n, n2);
    }

    public void setRGB(int n, int n2, int n3) {
        this.img.setRGB(n, n2, n3);
        this.hueCache = null;
        this.greyColourCache = null;
    }

    public int getGreyValue(int n, int n2) throws RuntimeException {
        if (this.greyColourCache == null) {
            this.createRGBCache();
        }
        int n3 = n2 * this.width + n;
        return this.greyColourCache[n3];
    }

    public int getRed(int n, int n2) throws RuntimeException {
        if (this.redColourCache == null) {
            this.createRGBCache();
        }
        int n3 = n2 * this.width + n;
        return this.redColourCache[n3];
    }

    public int getGreen(int n, int n2) throws RuntimeException {
        if (this.greenColourCache == null) {
            this.createRGBCache();
        }
        int n3 = n2 * this.width + n;
        return this.greenColourCache[n3];
    }

    public int getBlue(int n, int n2) throws RuntimeException {
        if (this.blueColourCache == null) {
            this.createRGBCache();
        }
        int n3 = n2 * this.width + n;
        return this.blueColourCache[n3];
    }

    public void normalise() {
        this.createRGBCache();
        double d = this.rMax - this.rMin;
        double d2 = this.gMax - this.gMin;
        double d3 = this.bMax - this.bMin;
        for (int i = 0; i < this.img.getHeight(); ++i) {
            for (int j = 0; j < this.img.getWidth(); ++j) {
                double d4 = (double)(this.getRed(j, i) - this.rMin) / d * 255.0;
                double d5 = (double)(this.getGreen(j, i) - this.gMin) / d2 * 255.0;
                double d6 = (double)(this.getBlue(j, i) - this.bMin) / d3 * 255.0;
                this.img.setRGB(j, i, new Color((int)d4, (int)d5, (int)d6).getRGB());
            }
        }
        this.createRGBCache();
    }

    public int getAdaptiveBinaryThreshold(int n, int n2) {
        int n3 = 51;
        FastStatistics fastStatistics = this.get3x3Stats(n, n2, 0, 2);
        int n4 = (int)fastStatistics.getMin();
        int n5 = (int)fastStatistics.getMax();
        int n6 = n5 - n4;
        int n7 = 0;
        n7 = n6 > n3 ? (n4 + n5) / 2 : n5 - n3 / 2;
        if (this.getGreyValue(n, n2) > n7) {
            return 255;
        }
        return 0;
    }

    private void createRGBCache() {
        this.rMax = 0;
        this.gMax = 0;
        this.bMax = 0;
        this.rMin = 255;
        this.gMin = 255;
        this.bMin = 255;
        int n = this.height * this.width;
        this.greyColourCache = new int[n];
        this.redColourCache = new int[n];
        this.greenColourCache = new int[n];
        this.blueColourCache = new int[n];
        int n2 = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n3 = this.img.getRGB(j, i);
                int n4 = n3 >> 16 & 0xFF;
                int n5 = n3 >> 8 & 0xFF;
                int n6 = n3 & 0xFF;
                if (n4 > this.rMax) {
                    this.rMax = n4;
                }
                if (n4 < this.rMin) {
                    this.rMin = n4;
                }
                if (n5 > this.gMax) {
                    this.gMax = n5;
                }
                if (n5 < this.gMin) {
                    this.gMin = n5;
                }
                if (n6 > this.bMax) {
                    this.bMax = n6;
                }
                if (n6 < this.bMin) {
                    this.bMin = n6;
                }
                this.greyColourCache[n2] = (int)((double)n4 * 0.3 + (double)n5 * 0.59 + (double)n6 * 0.11);
                this.redColourCache[n2] = n4;
                this.greenColourCache[n2] = n5;
                this.blueColourCache[n2] = n6;
                ++n2;
            }
        }
    }

    public int getHue(int n, int n2) {
        if (this.hueCache == null) {
            this.createHSLCache();
        }
        int n3 = n2 * this.width + n;
        return this.hueCache[n3];
    }

    public int getSaturation(int n, int n2) {
        if (this.satCache == null) {
            this.createHSLCache();
        }
        int n3 = n2 * this.width + n;
        return this.satCache[n3];
    }

    public int getLightness(int n, int n2) {
        if (this.lightnessCache == null) {
            this.createHSLCache();
        }
        int n3 = n2 * this.width + n;
        return this.lightnessCache[n3];
    }

    private void createHSLCache() {
        int n = this.img.getHeight() * this.width;
        this.hueCache = new int[n];
        this.satCache = new int[n];
        this.lightnessCache = new int[n];
        int n2 = 0;
        for (int i = 0; i < this.img.getHeight(); ++i) {
            for (int j = 0; j < this.img.getWidth(); ++j) {
                int[] nArray = ColourConvertor.RGB2HSL(this.img.getRGB(j, i));
                this.hueCache[n2] = nArray[0];
                this.satCache[n2] = nArray[1];
                this.lightnessCache[n2] = nArray[2];
                ++n2;
            }
        }
    }

    public int getVerticalSobel(int n, int n2) {
        if (this.vsobelCache == null) {
            this.vsobelCache = new int[this.getWidth()][this.getHeight()];
            for (int i = 0; i < this.getHeight(); ++i) {
                for (int j = 0; j < this.getWidth(); ++j) {
                    this.vsobelCache[j][i] = -1;
                }
            }
            this.verticalSobel = new ConvolutionMatrix(9);
        }
        if (this.vsobelCache[n][n2] == -1) {
            this.vsobelCache[n][n2] = this.getConvolved(n, n2, this.verticalSobel);
        }
        return this.vsobelCache[n][n2];
    }

    public int getHorizontalSobel(int n, int n2) {
        if (this.hsobelCache == null) {
            this.hsobelCache = new int[this.getWidth()][this.getHeight()];
            for (int i = 0; i < this.getHeight(); ++i) {
                for (int j = 0; j < this.getWidth(); ++j) {
                    this.hsobelCache[j][i] = -1;
                }
            }
            this.horizontalSobel = new ConvolutionMatrix(8);
        }
        if (this.hsobelCache[n][n2] == -1) {
            this.hsobelCache[n][n2] = this.getConvolved(n, n2, this.horizontalSobel);
        }
        return this.hsobelCache[n][n2];
    }

    public int getLaplacian(int n, int n2) {
        if (this.laplacianCache == null) {
            this.laplacianCache = new int[this.getWidth()][this.getHeight()];
            for (int i = 0; i < this.getHeight(); ++i) {
                for (int j = 0; j < this.getWidth(); ++j) {
                    this.laplacianCache[j][i] = -1;
                }
            }
            this.laplacian = new ConvolutionMatrix(1);
        }
        if (this.laplacianCache[n][n2] == -1) {
            this.laplacianCache[n][n2] = this.getConvolved(n, n2, this.laplacian);
        }
        return this.laplacianCache[n][n2];
    }

    public static void main(String[] stringArray) throws Exception {
        PixelLoader pixelLoader = new PixelLoader("/home/ooechs/Desktop/Lenna.png");
        FastStatistics fastStatistics = new FastStatistics();
        for (int i = 0; i <= 20; ++i) {
            long l = System.currentTimeMillis();
            pixelLoader.get3x3Mean(10, 10);
            pixelLoader.meanCache = null;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (i > 0) {
                fastStatistics.addData(l3);
            }
            System.out.println(l3);
        }
        System.out.println(fastStatistics.getMean() + " | " + fastStatistics.getStandardDeviation());
    }

    public float get3x3Variance(int n, int n2) {
        if (this.varianceCache == null) {
            FastStatistics fastStatistics = new FastStatistics();
            this.varianceCache = new float[this.getHeight()][this.getWidth()];
            for (int i = size; i < this.getHeight() - size; ++i) {
                for (int j = size; j < this.getWidth() - size; ++j) {
                    fastStatistics.reset();
                    for (int k = -size; k <= size; ++k) {
                        int n3 = i + k;
                        for (int i2 = -size; i2 <= size; ++i2) {
                            fastStatistics.addData(this.getGreyValue(j + i2, n3));
                        }
                    }
                    this.varianceCache[i][j] = fastStatistics.getVariance();
                }
            }
        }
        return this.varianceCache[n2][n];
    }

    public int get3x3Range(int n, int n2) {
        int n3;
        if (this.rangeCache == null) {
            n3 = this.width * this.height;
            this.rangeCache = new int[n3];
            if (this.greyColourCache == null) {
                this.createRGBCache();
            }
            int n4 = size * 2 + 1;
            for (int i = size; i < this.getHeight() - size; ++i) {
                for (int j = size; j < this.getWidth() - size; ++j) {
                    int n5;
                    int n6 = 0;
                    int n7 = 256;
                    int n8 = (i - size) * this.width + (j - size);
                    for (n5 = 0; n5 < n4; ++n5) {
                        int n9 = n8;
                        for (int k = 0; k < n4; ++k) {
                            int n10 = this.greyColourCache[n9];
                            if (n10 > n6) {
                                n6 = n10;
                            }
                            if (n10 < n7) {
                                n7 = n10;
                            }
                            ++n9;
                        }
                        n8 += this.width;
                    }
                    n5 = i * this.width + j;
                    this.rangeCache[n5] = n6 - n7;
                }
            }
        }
        n3 = n2 * this.width + n;
        return this.rangeCache[n3];
    }

    public float get3x3TruncatedMedian(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = 255;
        int n8 = 0;
        int n9 = size * 2 + 1;
        n9 *= n9;
        int[] nArray = new int[n9];
        double d = 0.0;
        int n10 = 0;
        for (n6 = -size; n6 <= size; ++n6) {
            for (n5 = -size; n5 <= size; ++n5) {
                if (n5 == 0 && n6 == 0) continue;
                nArray[n10] = n4 = this.getGreyValue(n + n5, n2 + n6);
                d += (double)n4;
                if (n4 > n8) {
                    n8 = n4;
                }
                if (n4 < n7) {
                    n7 = n4;
                }
                ++n10;
            }
        }
        n6 = Median.find(nArray, 0, n10 - 1);
        d /= (double)n10;
        n8 = 223;
        n7 = 32;
        for (n5 = 0; n5 < n3; ++n5) {
            n4 = (n8 - n7) / 4;
            if (d < (double)n6) {
                n7 = n6 - n4;
            } else {
                n8 = n6 + n4;
            }
            n7 = n6 - n4;
            n8 = n6 + n4;
            d = 0.0;
            n10 = 0;
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    int n11;
                    if (j == 0 && i == 0 || (n11 = this.getGreyValue(n + j, n2 + i)) < n7 || n11 > n8) continue;
                    nArray[n10] = n11;
                    d += (double)n11;
                    ++n10;
                }
            }
            n6 = Median.find(nArray, 0, n10 - 1);
            d /= (double)n10;
        }
        return n6;
    }

    public float get3x3Gaussian(int n, int n2) {
        int n3 = 0;
        n3 += this.getGreyValue(n - 1, n2 - 1);
        n3 += this.getGreyValue(n, n2 - 1) * 2;
        n3 += this.getGreyValue(n + 1, n2 - 1);
        n3 += this.getGreyValue(n - 1, n2) * 2;
        n3 += this.getGreyValue(n, n2) * 4;
        n3 += this.getGreyValue(n + 1, n2) * 2;
        n3 += this.getGreyValue(n - 1, n2 + 1);
        n3 += this.getGreyValue(n, n2 + 1) * 2;
        return (n3 += this.getGreyValue(n + 1, n2 + 1)) / 16;
    }

    public int get3x3Median(int n, int n2) {
        int n3 = size * 2 + 1;
        n3 *= n3;
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                int n5;
                if (j == 0 && i == 0) continue;
                nArray[n4] = n5 = this.getGreyValue(n + j, n2 + i);
                ++n4;
            }
        }
        return Median.find(nArray, 0, nArray.length - 1);
    }

    public float get3x3Mean(int n, int n2) {
        int n3;
        if (this.meanCache == null) {
            if (this.greyColourCache == null) {
                this.createRGBCache();
            }
            n3 = size * 2 + 1;
            int n4 = n3 * n3;
            int n5 = this.width * this.height;
            this.meanCache = new float[n5];
            for (int i = size; i < this.getHeight() - size; ++i) {
                for (int j = size; j < this.getWidth() - size; ++j) {
                    int n6;
                    float f = 0.0f;
                    int n7 = (i - size) * this.width + (j - size);
                    for (n6 = 0; n6 < n3; ++n6) {
                        int n8 = n7;
                        for (int k = 0; k < n3; ++k) {
                            f += (float)this.greyColourCache[n8];
                            ++n8;
                        }
                        n7 += this.width;
                    }
                    n6 = i * this.width + j;
                    this.meanCache[n6] = f / (float)n4;
                }
            }
        }
        n3 = n2 * this.width + n;
        return this.meanCache[n3];
    }

    public BufferedImage getProcessedImage(int n) {
        int n2;
        BufferedImage bufferedImage = new BufferedImage(this.img.getWidth(), this.img.getHeight(), 1);
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        double[][] dArray = new double[this.img.getWidth()][this.img.getHeight()];
        for (int i = n2 = 9; i < this.img.getHeight() - n2; ++i) {
            for (int j = n2; j < this.img.getWidth() - n2; ++j) {
                double d3 = 0.0;
                switch (n) {
                    case 1: {
                        d3 = this.getContrast(j, i);
                        break;
                    }
                    case 2: {
                        d3 = this.getDissimilarity(j, i);
                        break;
                    }
                    case 3: {
                        d3 = this.getUniformity(j, i);
                        break;
                    }
                    case 5: {
                        d3 = this.getEntropy(j, i);
                        break;
                    }
                    case 4: {
                        d3 = this.getMaximumProbability(j, i);
                        break;
                    }
                    case 6: {
                        d3 = this.get3x3Variance(j, i);
                    }
                }
                if (d3 < d) {
                    d = d3;
                } else if (d3 > d2) {
                    d2 = d3;
                }
                dArray[j][i] = d3;
            }
        }
        double d4 = d2 - d;
        for (int i = n2; i < this.img.getHeight() - n2; ++i) {
            for (int j = n2; j < this.img.getWidth() - n2; ++j) {
                int n3 = (int)((dArray[j][i] - d) / d4 * 255.0);
                bufferedImage.setRGB(j, i, new Color(n3, n3, n3).getRGB());
            }
        }
        return bufferedImage;
    }

    public double getContrast(int n, int n2) {
        double[][] dArray = this.getHorizontalGLCM(n, n2, 8);
        double d = 0.0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                d += dArray[j][i] * (double)(j - i ^ 2);
            }
        }
        return d;
    }

    public double getDissimilarity(int n, int n2) {
        double[][] dArray = this.getHorizontalGLCM(n, n2, 8);
        double d = 0.0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                d += dArray[j][i] * (double)Math.abs(j - i);
            }
        }
        return d;
    }

    public double getUniformity(int n, int n2) {
        double[][] dArray = this.getHorizontalGLCM(n, n2, 8);
        double d = 0.0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                d += dArray[j][i] * dArray[j][i];
            }
        }
        return d;
    }

    public double getEntropy(int n, int n2) {
        double[][] dArray = this.getHorizontalGLCM(n, n2, 8);
        double d = 0.0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                d += dArray[j][i] * -Math.log1p(dArray[j][i]);
            }
        }
        return d;
    }

    public double getMaximumProbability(int n, int n2) {
        double[][] dArray = this.getHorizontalGLCM(n, n2, 8);
        double d = 0.0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (!(dArray[j][i] > d)) continue;
                d = dArray[j][i];
            }
        }
        return d;
    }

    public int quantize(int n) {
        if (n > 240) {
            n = 240;
        }
        if ((n -= 210) < 0) {
            n = 0;
        }
        return n / 16;
    }

    public double[][] getHorizontalGLCM(int n, int n2, int n3) {
        double[][] dArray = new double[16][16];
        for (int i = -n3; i <= n3; ++i) {
            for (int j = -n3; j <= n3; ++j) {
                int n4 = n + j;
                int n5 = n2 + i;
                int n6 = this.quantize(this.getGreyValue(n4, n5));
                int n7 = this.quantize(this.getGreyValue(n4 + 1, n5));
                double[] dArray2 = dArray[n6];
                int n8 = n7;
                dArray2[n8] = dArray2[n8] + 1.0;
                double[] dArray3 = dArray[n7];
                int n9 = n6;
                dArray3[n9] = dArray3[n9] + 1.0;
            }
        }
        return dArray;
    }

    public FastStatistics get3x3Stats(int n, int n2, int n3) {
        return this.get3x3Stats(n, n2, n3, 1);
    }

    public FastStatistics get3x3Stats(int n, int n2, int n3, int n4) {
        FastStatistics fastStatistics = new FastStatistics();
        if (n2 - n4 < 0) {
            return fastStatistics;
        }
        if (n2 + n4 > this.getHeight() - 1) {
            return fastStatistics;
        }
        if (n - n4 < 0) {
            return fastStatistics;
        }
        if (n + n4 > this.getWidth() - 1) {
            return fastStatistics;
        }
        switch (n3) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (this.redColourCache != null) break;
                this.createRGBCache();
                break;
            }
            default: {
                if (this.hueCache != null) break;
                this.createHSLCache();
            }
        }
        int n5 = (n2 - n4) * this.width + (n - n4);
        int n6 = n4 * 2 + 1;
        for (int i = 0; i < n6; ++i) {
            int n7 = n5;
            for (int j = 0; j < n6; ++j) {
                switch (n3) {
                    case 1: {
                        fastStatistics.addData(this.redColourCache[n7]);
                        break;
                    }
                    case 2: {
                        fastStatistics.addData(this.greenColourCache[n7]);
                        break;
                    }
                    case 3: {
                        fastStatistics.addData(this.blueColourCache[n7]);
                        break;
                    }
                    case 4: {
                        fastStatistics.addData(this.hueCache[n7]);
                        break;
                    }
                    case 5: {
                        fastStatistics.addData(this.satCache[n7]);
                        break;
                    }
                    case 6: {
                        fastStatistics.addData(this.lightnessCache[n7]);
                        break;
                    }
                    case 0: {
                        fastStatistics.addData(this.greyColourCache[n7]);
                    }
                }
                ++n7;
            }
            n5 += this.width;
        }
        return fastStatistics;
    }

    public int getConvolved(int n, int n2, ConvolutionMatrix convolutionMatrix) {
        double d = 0.0;
        int n3 = convolutionMatrix.getWidth() / 2;
        if (n2 - n3 < 0) {
            return 0;
        }
        if (n2 + n3 > this.getHeight() - 1) {
            return 0;
        }
        if (n - n3 < 0) {
            return 0;
        }
        if (n + n3 > this.getWidth() - 1) {
            return 0;
        }
        for (int i = -n3; i <= n3; ++i) {
            int n4 = n2 + i;
            for (int j = -n3; j <= n3; ++j) {
                int n5 = n + j;
                d += (double)this.getGreyValue(n5, n4) * convolutionMatrix.getWeight(j + n3, i + n3);
            }
        }
        return (int)(d / convolutionMatrix.getTotal());
    }

    public int[] getPrecomputedColours() {
        int[] nArray = new int[256];
        for (int i = 0; i <= 255; ++i) {
            nArray[i] = new Color(i, i, i).getRGB();
        }
        return nArray;
    }

    public BufferedImage getConvolved(ConvolutionMatrix convolutionMatrix) {
        BufferedImage bufferedImage = new BufferedImage(this.img.getWidth(), this.img.getHeight(), 1);
        int[] nArray = this.getPrecomputedColours();
        for (int i = 0; i < this.img.getHeight(); ++i) {
            for (int j = 0; j < this.img.getWidth(); ++j) {
                int n = this.getConvolved(j, i, convolutionMatrix);
                if (n > 255) {
                    n = 255;
                }
                if (n < 0) {
                    n = 0;
                }
                if (n == 0) continue;
                bufferedImage.setRGB(j, i, nArray[n]);
            }
        }
        return bufferedImage;
    }

    public void saveAs(String string) throws Exception {
        this.saveAs(new File(string));
    }

    public void saveAs(File file) throws Exception {
        try {
            String string = "bmp";
            if (file.getName().endsWith(".png")) {
                string = "png";
            }
            if (file.getName().endsWith(".jpg")) {
                string = "jpg";
            }
            ImageIO.write((RenderedImage)this.img, string, file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public int getWidth() {
        return this.img.getWidth();
    }

    @Override
    public int getHeight() {
        return this.img.getHeight();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getFilename() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "no-name";
    }
}

