/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codecimpl.JPEGImageEncoder;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.RenderedOp;

public class Resizer {
    public static void resize(File file, int n) throws Exception {
        Resizer.resize(file.getAbsolutePath(), n, -1);
    }

    public static void resize(File file, File file2, int n) throws Exception {
        Resizer.produceThumbnail(file.getAbsolutePath(), file2.getAbsolutePath(), n, -1);
    }

    public static void resize(String string, int n, int n2) throws Exception {
        Resizer.produceThumbnail(string, string, n, n2);
    }

    public static void produceThumbnail(String string, String string2, int n, int n2) throws Exception {
        float f;
        RenderedOp renderedOp = JAI.create((String)"fileload", (Object)string);
        float f2 = f = (float)n / (float)renderedOp.getWidth();
        int n3 = 1;
        if ((double)f > 0.4 && (double)f < 0.6) {
            n3 = 2;
        }
        if ((double)f > 0.2 && (double)f <= 0.4) {
            n3 = 3;
        }
        if ((double)f <= 0.2) {
            n3 = 5;
        }
        float[] fArray = new float[n3 * n3];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = 1.0f / (float)fArray.length;
        }
        KernelJAI kernelJAI = new KernelJAI(n3, n3, fArray);
        renderedOp = JAI.create((String)"convolve", (RenderedImage)renderedOp, (Object)kernelJAI);
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedOp);
        parameterBlock.add(f);
        parameterBlock.add(f2);
        parameterBlock.add(0.0f);
        parameterBlock.add(0.0f);
        parameterBlock.add(Interpolation.getInstance((int)2));
        renderedOp = JAI.create((String)"scale", (ParameterBlock)parameterBlock);
        JPEGEncodeParam jPEGEncodeParam = new JPEGEncodeParam();
        jPEGEncodeParam.setHorizontalSubsampling(0, 1);
        jPEGEncodeParam.setHorizontalSubsampling(1, 2);
        jPEGEncodeParam.setHorizontalSubsampling(2, 2);
        jPEGEncodeParam.setVerticalSubsampling(0, 1);
        jPEGEncodeParam.setVerticalSubsampling(1, 1);
        jPEGEncodeParam.setVerticalSubsampling(2, 1);
        jPEGEncodeParam.setRestartInterval(64);
        jPEGEncodeParam.setQuality(0.75f);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        JPEGImageEncoder jPEGImageEncoder = new JPEGImageEncoder((OutputStream)bufferedOutputStream, (ImageEncodeParam)jPEGEncodeParam);
        jPEGImageEncoder.setParam((ImageEncodeParam)jPEGEncodeParam);
        jPEGImageEncoder.encode((RenderedImage)renderedOp);
    }

    public static void copy(File file, File file2) throws Exception {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        fileChannel.close();
        fileChannel2.close();
    }

    public static void copy(String string, String string2) throws Exception {
        Resizer.copy(new File(string), new File(string2));
    }

    public static void copyDirectoryTo(String string, String string2) throws Exception {
        File file = new File(string2);
        File file2 = new File(string);
        Resizer.copyDirectoryTo(file2, file);
    }

    public static void copyDirectoryTo(File file, File file2) throws Exception {
        if (!file.exists()) {
            throw new Exception("Cannot copy - the source directory does not exist");
        }
        if (!file.isDirectory()) {
            throw new Exception("Cannot copy - the source is not a directory");
        }
        if (!file2.exists()) {
            System.out.println("Creating directory: " + file2.getName());
            file2.mkdir();
        }
        if (!file2.isDirectory()) {
            throw new Exception("Cannot copy - the destination is not a directory");
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            if (file3.isDirectory()) {
                File file4 = new File(file2, file3.getName());
                file4.mkdir();
                System.out.println("Creating directory: " + file3.getName());
                Resizer.copyDirectoryTo(file3, file4);
                continue;
            }
            System.out.println("Copying file: " + file3.getName() + " to: " + file2.getName());
            Resizer.copy(file3, new File(file2, file3.getName()));
        }
    }
}

