/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons;

import java.util.Arrays;
import java.util.Hashtable;
import org.jfree.data.xy.XYSeries;

public class StatisticsSolver {
    private float[] v;
    private int cursor;
    public float total = -1.0f;
    protected int numElements;
    protected float highest = Float.MIN_VALUE;
    protected float lowest = Float.MAX_VALUE;
    public float mean = -1.0f;
    public float variance = -1.0f;
    public static final int TOTAL = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    public static final int RANGE = 4;
    public static final int MEAN = 5;
    public static final int MODE = 6;
    public static final int VARIANCE = 7;
    public static final int STANDARD_DEVIATION = 8;

    public float getStatistic(int n) {
        switch (n) {
            case 1: {
                return this.getTotal();
            }
            case 2: {
                return this.getMin();
            }
            case 3: {
                return this.getMax();
            }
            case 4: {
                return this.getRange();
            }
            case 5: {
                return this.getMean();
            }
            case 6: {
                return this.getMode();
            }
            case 7: {
                return this.getVariance();
            }
            case 8: {
                return this.getStandardDeviation();
            }
        }
        throw new RuntimeException("Invalid statistic type: " + n);
    }

    public static String getStatisticName(int n) {
        switch (n) {
            case 1: {
                return "StatisticsSolver.TOTAL";
            }
            case 2: {
                return "StatisticsSolver.MIN";
            }
            case 3: {
                return "StatisticsSolver.MAX";
            }
            case 4: {
                return "StatisticsSolver.RANGE";
            }
            case 5: {
                return "StatisticsSolver.MEAN";
            }
            case 6: {
                return "StatisticsSolver.MODE";
            }
            case 7: {
                return "StatisticsSolver.VARIANCE";
            }
            case 8: {
                return "StatisticsSolver.STANDARD_DEVIATION";
            }
        }
        throw new RuntimeException("Unknown statistic type: " + n);
    }

    public static void main(String[] stringArray) {
        StatisticsSolver statisticsSolver = new StatisticsSolver();
        for (int i = 0; i < 10; ++i) {
            statisticsSolver.addData(4.0f);
            statisticsSolver.addData(2.0f);
            statisticsSolver.addData(1.0f);
            statisticsSolver.addData(3.0f);
            statisticsSolver.addData(5.0f);
            System.out.println(statisticsSolver.getRange());
            System.out.println(statisticsSolver.getMean());
            System.out.println(statisticsSolver.getMedian());
            statisticsSolver.clear();
            statisticsSolver.addData(5.0f);
            statisticsSolver.addData(5.0f);
            statisticsSolver.addData(5.0f);
            statisticsSolver.addData(5.0f);
            statisticsSolver.addData(5.0f);
            System.out.println(statisticsSolver.getRange());
            System.out.println(statisticsSolver.getMean());
            System.out.println(statisticsSolver.getMedian());
            statisticsSolver.clear();
        }
    }

    public StatisticsSolver() {
        this(20);
    }

    public int size() {
        return this.numElements;
    }

    public StatisticsSolver(int n) {
        this.v = new float[n + 1];
        this.cursor = 0;
    }

    public XYSeries getXYSeries(String string) {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)string));
        for (int i = 0; i < this.v.length; ++i) {
            float f = this.v[i];
            xYSeries.add((double)i, (double)f);
        }
        return xYSeries;
    }

    public float getDistributionOverlapWith(StatisticsSolver statisticsSolver) {
        if (statisticsSolver.numElements != this.numElements) {
            throw new RuntimeException("Distribution Overlap failed: Both statistics objects need the same number of entries.");
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.numElements; ++i) {
            float f3 = this.v[i];
            if (!(f3 > 0.0f)) continue;
            f += f3;
            if (!(statisticsSolver.v[i] > 0.0f)) continue;
            f2 += Math.min(f3, statisticsSolver.v[i]);
        }
        return f / f2;
    }

    public StatisticsSolver getDistribution(float f, float f2, int n) {
        float f3 = (f2 - f) / (float)n;
        StatisticsSolver statisticsSolver = new StatisticsSolver(n);
        for (float f4 = f; f4 <= f2; f4 += f3) {
            statisticsSolver.addData(this.countDataInRange(f4, f4 + f3));
        }
        return statisticsSolver;
    }

    public int countDataInRange(float f, float f2) {
        int n = 0;
        for (int i = 0; i < this.v.length; ++i) {
            float f3 = this.v[i];
            if (!(f3 <= f2) || !(f3 >= f)) continue;
            ++n;
        }
        return n;
    }

    public void addData(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            this.addData(fArray[i]);
        }
    }

    public void addData(double d) {
        this.addData((float)d);
    }

    public void addData(float f) {
        this.v[this.cursor] = f;
        ++this.cursor;
        if (this.cursor == this.v.length) {
            float[] fArray = new float[this.v.length * 2];
            System.arraycopy(this.v, 0, fArray, 0, this.v.length);
            this.v = fArray;
        }
        if (f > this.highest) {
            this.highest = f;
        }
        if (f < this.lowest) {
            this.lowest = f;
        }
        ++this.numElements;
        this.variance = -1.0f;
        this.mean = -1.0f;
        this.total = -1.0f;
    }

    public double getCorrelationWith(StatisticsSolver statisticsSolver) {
        if (statisticsSolver.numElements != this.numElements) {
            throw new RuntimeException("Correlation failed: Both statistics objects need the same number of entries.");
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = this.numElements;
        for (int i = 0; i < this.numElements; ++i) {
            f += this.v[i] * statisticsSolver.v[i];
            f2 += this.v[i];
            f3 += statisticsSolver.v[i];
            f4 += this.v[i] * this.v[i];
            f5 += statisticsSolver.v[i] * statisticsSolver.v[i];
        }
        float f7 = f - f2 * f3 / f6;
        double d = Math.sqrt((f4 - f2 * f2 / f6) * (f5 - f3 * f3 / f6));
        return (double)f7 / d;
    }

    public float getTotal() {
        if (this.total == -1.0f) {
            this.total = 0.0f;
            for (int i = 0; i < this.numElements; ++i) {
                this.total += this.v[i];
            }
        }
        return this.total;
    }

    public float getMax() {
        return this.highest;
    }

    public float getMin() {
        return this.lowest;
    }

    public float getRange() {
        if (this.numElements == 0) {
            return 0.0f;
        }
        return this.highest - this.lowest;
    }

    public float getMean() {
        if (this.mean == -1.0f) {
            this.mean = this.numElements == 0 ? 0.0f : this.getTotal() / (float)this.numElements;
        }
        return this.mean;
    }

    public float getMedian() {
        if (this.numElements == 0) {
            return 0.0f;
        }
        float[] fArray = new float[this.numElements];
        System.arraycopy(this.v, 0, fArray, 0, this.numElements);
        Arrays.sort(fArray);
        if (this.numElements % 2 == 0) {
            int n = this.numElements / 2;
            return (fArray[n] + fArray[n - 1]) / 2.0f;
        }
        return fArray[this.numElements / 2];
    }

    public float getVariance() {
        if (this.variance == -1.0f) {
            float f = this.getMean();
            float f2 = 0.0f;
            for (int i = 0; i < this.numElements; ++i) {
                float f3 = this.v[i] - f;
                f2 += f3 * f3;
            }
            this.variance = f2 / (float)(this.numElements - 1);
        }
        return this.variance;
    }

    public float getStandardDeviation() {
        return (float)Math.sqrt(this.getVariance());
    }

    public float getMode() {
        Hashtable<Float, Integer> hashtable = new Hashtable<Float, Integer>(255);
        float f = -1.0f;
        int n = 0;
        for (int i = 0; i < this.numElements; ++i) {
            Integer n2 = (Integer)hashtable.get(Float.valueOf(this.v[i]));
            if (n2 != null) {
                hashtable.put(Float.valueOf(this.v[i]), n2 + 1);
                if (n2 + 1 <= n) continue;
                f = this.v[i];
                n = n2 + 1;
                continue;
            }
            hashtable.put(Float.valueOf(this.v[i]), 1);
        }
        return f;
    }

    public int countUnique() {
        Hashtable<Float, Integer> hashtable = new Hashtable<Float, Integer>(255);
        for (int i = 0; i < this.numElements; ++i) {
            Integer n = (Integer)hashtable.get(Float.valueOf(this.v[i]));
            if (n != null) continue;
            hashtable.put(Float.valueOf(this.v[i]), 1);
        }
        return hashtable.size();
    }

    public void clear() {
        this.highest = Float.MIN_VALUE;
        this.lowest = Float.MAX_VALUE;
        this.variance = -1.0f;
        this.mean = -1.0f;
        this.total = -1.0f;
        this.numElements = 0;
        this.cursor = 0;
    }
}

