/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MIASDBViewer
extends JFrame {
    public static final String APP_NAME = "MIAS Viewer";
    final File directory = new File("/home/ooechs/Desktop/mias/");
    private ImagePanel imagePanel;
    private JLabel abnormality;
    private JLabel backgroundTissueType;
    private JLabel severity;
    Vector<MIASImage> images;
    int cursor = 0;

    public static void main(String[] stringArray) {
        new MIASDBViewer();
    }

    public MIASDBViewer() {
        super(APP_NAME);
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIASDBViewer.this.read(new File(MIASDBViewer.this.directory, "Info.txt"));
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Exit");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton("Next");
        JButton jButton2 = new JButton("Prev");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIASDBViewer.this.next();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIASDBViewer.this.prev();
            }
        });
        jPanel.add(jButton2);
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3));
        this.abnormality = new JLabel("");
        this.severity = new JLabel("");
        this.backgroundTissueType = new JLabel("");
        jPanel2.add(this.backgroundTissueType);
        jPanel2.add(this.abnormality);
        jPanel2.add(this.severity);
        Container container = this.getContentPane();
        this.imagePanel = new ImagePanel();
        container.add((Component)jPanel, "North");
        container.add((Component)this.imagePanel, "Center");
        container.add((Component)jPanel2, "South");
        this.setSize(1024, 1024);
        this.setVisible(true);
    }

    public void next() {
        if (this.images == null) {
            this.alert("Load images first");
            return;
        }
        if (this.cursor < this.images.size()) {
            MIASImage mIASImage = this.images.elementAt(this.cursor);
            ++this.cursor;
            this.displayImage(mIASImage);
        } else {
            this.alert("No more images");
        }
    }

    public void prev() {
        if (this.images == null) {
            this.alert("Load images first");
            return;
        }
        if (this.cursor > 0) {
            MIASImage mIASImage = this.images.elementAt(this.cursor - 1);
            --this.cursor;
            this.displayImage(mIASImage);
        } else {
            this.alert("Can't go back");
        }
    }

    public void displayImage(MIASImage mIASImage) {
        try {
            PixelLoader pixelLoader = new PixelLoader(new File(this.directory, mIASImage.getFilename() + ".pgm.bmp"));
            BufferedImage bufferedImage = pixelLoader.getBufferedImage();
            if (mIASImage.getX() != -1) {
                Graphics graphics = bufferedImage.getGraphics();
                if (mIASImage.getSeverity() == 1) {
                    graphics.setColor(Color.WHITE);
                } else {
                    graphics.setColor(Color.RED);
                }
                int n = mIASImage.getRadius() / 2;
                int n2 = mIASImage.getX() - n;
                int n3 = bufferedImage.getHeight() - mIASImage.getY() - n;
                graphics.drawOval(n2, n3, mIASImage.getRadius(), mIASImage.getRadius());
            }
            this.imagePanel.setImage(bufferedImage);
            this.abnormality.setText("Abnormality: " + mIASImage.abnormalityToString());
            this.severity.setText("Severity: " + mIASImage.severityToString());
            this.backgroundTissueType.setText("Background: " + mIASImage.backgroundTypeToString());
            this.setTitle("MIAS Viewer - " + mIASImage.getFilename());
        }
        catch (Exception exception) {
            this.alert("Can't load next image: " + exception);
        }
    }

    public void read(File file) {
        this.cursor = 0;
        this.images = new Vector(100);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            if (!bufferedReader.ready()) {
                throw new IOException();
            }
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("mdb")) continue;
                int n = -1;
                int n2 = -1;
                int n3 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = "";
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                    try {
                        if (stringTokenizer.hasMoreTokens()) {
                            n = Integer.parseInt(stringTokenizer.nextToken());
                            n2 = Integer.parseInt(stringTokenizer.nextToken());
                            n3 = Integer.parseInt(stringTokenizer.nextToken());
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.images.add(new MIASImage(string2, string3, string4, string5, n, n2, n3));
            }
            System.out.println("Loaded: " + this.images.size() + " images.");
            this.next();
        }
        catch (IOException iOException) {
            this.alert("Error Reading file: " + iOException);
        }
    }

    public void alert(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    class MIASImage {
        public static final int FATTY = 0;
        public static final int FATTY_GLANDULAR = 1;
        public static final int DENSE_GLANDULAR = 2;
        public static final int CALCIFICATION = 0;
        public static final int WELL_DEFINED_OR_CIRCUMSCRIBED_MASSES = 1;
        public static final int SPICULATED_MASSES = 2;
        public static final int OTHER_ILL_DEFINED_MASSES = 3;
        public static final int ARCHITECTURAL_DISTORTION = 4;
        public static final int ASYMMETRY = 5;
        public static final int NORMAL = 6;
        public static final int NOT_APPLICABLE = 0;
        public static final int BENIGN = 1;
        public static final int MALIGNANT = 2;
        protected String filename;
        protected int backgroundTissueType;
        protected int abnormality;
        protected int severity;
        protected int x;
        protected int y;
        protected int radius;

        public MIASImage(String string, String string2, String string3, String string4, int n, int n2, int n3) {
            this.filename = string;
            if (string2.equals("F")) {
                this.backgroundTissueType = 0;
            }
            if (string2.equals("G")) {
                this.backgroundTissueType = 1;
            }
            if (string2.equals("D")) {
                this.backgroundTissueType = 2;
            }
            if (string3.equals("CALC")) {
                this.abnormality = 0;
            }
            if (string3.equals("CIRC")) {
                this.abnormality = 1;
            }
            if (string3.equals("MISC")) {
                this.abnormality = 3;
            }
            if (string3.equals("ARCH")) {
                this.abnormality = 4;
            }
            if (string3.equals("ASYN")) {
                this.abnormality = 5;
            }
            if (string3.equals("NORM")) {
                this.abnormality = 6;
            }
            this.severity = 0;
            if (string4.equals("B")) {
                this.severity = 1;
            }
            if (string4.equals("M")) {
                this.severity = 2;
            }
            this.x = n;
            this.y = n2;
            this.radius = n3;
        }

        public String getFilename() {
            return this.filename;
        }

        public int getBackgroundTissueType() {
            return this.backgroundTissueType;
        }

        public int getAbnormality() {
            return this.abnormality;
        }

        public int getSeverity() {
            return this.severity;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getRadius() {
            return this.radius;
        }

        public String backgroundTypeToString() {
            String[] stringArray = new String[]{"Fatty", "Fatty Glandular", "Dense Glandular"};
            return stringArray[this.backgroundTissueType];
        }

        public String abnormalityToString() {
            String[] stringArray = new String[]{"Calcification", "Well defined / Circumscribed masses", "Spiculated Masses", "Other ill defined masses", "Architectural distortion", "Asymmetry", "Normal"};
            return stringArray[this.abnormality];
        }

        public String severityToString() {
            String[] stringArray = new String[]{"Not Applicable", "Benign", "Malignant"};
            return stringArray[this.severity];
        }
    }
}

