/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.anpr;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.apps.anpr.HorizontalSobel;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.File;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ANPRTest
extends JFrame {
    public static final String IMAGE_DIRECTORY = "/home/ooechs/ecj-work/vehicle-recognition/";
    JList fileList;
    ImagePanel panel;
    ImagePanel panel2;
    JTextArea svgField;

    public static void main(String[] stringArray) {
        new ANPRTest();
    }

    public ANPRTest() {
        super("Vehicle Recognition 1.0");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.populateJListFiles();
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ANPRTest.this.churn();
                }
            }
        });
        this.panel = new ImagePanel();
        this.panel2 = new ImagePanel();
        JScrollPane jScrollPane = new JScrollPane(this.fileList);
        jScrollPane.setPreferredSize(new Dimension(180, -1));
        container.add((Component)jScrollPane, "West");
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(this.panel2);
        jPanel.add(this.panel);
        container.add((Component)jPanel, "Center");
        this.setSize(930, 700);
        this.setVisible(true);
    }

    public void churn() {
        if (this.fileList.getSelectedValue() == null) {
            this.svgField.setText("Please select an image");
            return;
        }
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            File file = new File(IMAGE_DIRECTORY, (String)this.fileList.getSelectedValue());
            PixelLoader pixelLoader = new PixelLoader(file);
            this.panel2.setImage(new PixelLoader(file));
            long l = System.currentTimeMillis();
            double[][] dArray = HorizontalSobel.Sobel(pixelLoader);
            boolean[][] blArray = new boolean[pixelLoader.getWidth() / 10 + 1][pixelLoader.getHeight()];
            for (n6 = 0; n6 < pixelLoader.getHeight(); ++n6) {
                n5 = 0;
                for (n4 = 0; n4 < pixelLoader.getWidth() - 10; n4 += 10) {
                    n3 = 0;
                    for (n2 = 0; n2 < 10; ++n2) {
                        n = (int)dArray[n4 + n2][n6];
                        if (n <= n3) continue;
                        n3 = n;
                    }
                    blArray[n5][n6] = n3 > 220;
                    ++n5;
                }
            }
            n6 = Color.BLACK.getRGB();
            n5 = Color.WHITE.getRGB();
            for (n4 = 0; n4 < pixelLoader.getHeight(); ++n4) {
                for (n3 = 1; n3 < pixelLoader.getWidth() / 10 - 1; ++n3) {
                    int n7 = n2 = blArray[n3][n4] ? n5 : n6;
                    if (!blArray[n3 - 1][n4] && !blArray[n3 + 1][n4]) {
                        n2 = n6;
                    }
                    n = n3 * 10;
                    for (int i = 0; i < 10; ++i) {
                        pixelLoader.setRGB(n + i, n4, n2);
                    }
                }
            }
            long l2 = System.currentTimeMillis();
            System.out.println(l2 - l + " ms.");
            this.panel.setImage(pixelLoader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void populateJListFiles() {
        File file = new File(IMAGE_DIRECTORY);
        File[] fileArray = file.listFiles();
        Vector<String> vector = new Vector<String>(10);
        for (File file2 : fileArray) {
            if (file2.getName().toLowerCase().endsWith(".jpg")) {
                vector.add(file2.getName());
                continue;
            }
            System.out.println("Did not include: " + file2.getName());
        }
        this.fileList = new JList(vector);
    }
}

