/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.display;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.grids.FaceGrid;
import ac.essex.ooechs.imaging.commons.util.panels.ScalingGridPanel;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class DisplayGrid
extends JFrame {
    ScalingGridPanel panel;
    File[] images;
    int cursor = 0;

    public static void main(String[] stringArray) throws Exception {
        File file = new File("/home/ooechs/ecj-training/faces/essex/mit/test/unscaled");
        new DisplayGrid(file.listFiles());
    }

    public DisplayGrid(File[] fileArray) {
        this.images = fileArray;
        this.panel = new ScalingGridPanel(new FaceGrid());
        this.panel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getUnitsToScroll() > 0) {
                    DisplayGrid.this.next();
                } else {
                    DisplayGrid.this.prev();
                }
            }
        });
        this.getContentPane().add(this.panel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.next();
        this.setSize(320, 400);
        this.setVisible(true);
    }

    public void next() {
        try {
            this.panel.setImage(new PixelLoader(this.images[this.cursor]));
            this.setTitle(this.images[this.cursor].getName());
            ++this.cursor;
            if (this.cursor >= this.images.length) {
                this.cursor = 0;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.panel, exception.toString());
        }
    }

    public void prev() {
        try {
            this.panel.setImage(new PixelLoader(this.images[this.cursor]));
            this.setTitle(this.images[this.cursor].getName());
            --this.cursor;
            if (this.cursor < 0) {
                this.cursor = this.images.length - 1;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.panel, exception.toString());
        }
    }
}

