/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.display;

import ac.essex.ooechs.imaging.commons.apps.display.ZoomPanel;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class DisplayImage
extends JFrame
implements ActionListener {
    public static final String APP_NAME = "Image Viewer";
    JMenuItem file_open;
    JMenuItem file_exit;
    JMenuItem view_magnifier;
    JLabel mousePosition;
    MouseImagePanel imagePanel;
    ZoomPanel zoomPanel;
    Magnifier magnifier;
    final JFileChooser fc = new JFileChooser(new File("/home/ooechs/Desktop/sv"));

    public DisplayImage() {
        super(APP_NAME);
        this.imagePanel = new MouseImagePanel();
        this.imagePanel.setDisplayCentered(true);
        this.zoomPanel = new ZoomPanel(40, 40);
        this.magnifier = new Magnifier(this.zoomPanel);
        Container container = this.getContentPane();
        container.add((Component)this.imagePanel, "Center");
        this.mousePosition = new JLabel("");
        container.add((Component)this.mousePosition, "South");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        this.file_open = new JMenuItem("Open");
        this.file_exit = new JMenuItem("Exit");
        this.file_open.addActionListener(this);
        this.file_exit.addActionListener(this);
        jMenu.add(this.file_open);
        jMenu.add(this.file_exit);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("View");
        this.view_magnifier = new JMenuItem("Magnifier");
        this.view_magnifier.addActionListener(this);
        jMenu2.add(this.view_magnifier);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.setSize(640, 480);
        this.setLocation(50, 50);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.view_magnifier) {
            this.magnifier.setVisible(!this.magnifier.isVisible());
        }
        if (actionEvent.getSource() == this.file_open) {
            this.fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String string = file.getName().substring(file.getName().lastIndexOf(46) + 1).toLowerCase();
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (string.equals("jpg")) {
                        return true;
                    }
                    if (string.equals("png")) {
                        return true;
                    }
                    return string.equals("gif");
                }

                @Override
                public String getDescription() {
                    return "Image Files: jpg, png, gif";
                }
            });
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                File file = this.fc.getSelectedFile();
                try {
                    BufferedImage bufferedImage = ImageIO.read(file);
                    this.imagePanel.setImage(bufferedImage);
                    this.zoomPanel.setImage(bufferedImage);
                    this.setTitle("Image Viewer - " + file.getName());
                }
                catch (IIOException iIOException) {
                    JOptionPane.showMessageDialog(this, "Could not load image!\n" + iIOException.getMessage());
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "Could not load image!\n" + iOException.getMessage());
                }
            }
        }
        if (actionEvent.getSource() == this.file_exit) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        new DisplayImage();
    }

    class Magnifier
    extends JFrame {
        public Magnifier(ZoomPanel zoomPanel) {
            super("Magnifier");
            this.getContentPane().add(zoomPanel);
            this.setSize(250, 250);
            this.setLocation(700, 50);
            this.setVisible(true);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    Magnifier.this.setVisible(false);
                }
            });
        }
    }

    class MouseImagePanel
    extends ImagePanel {
        public MouseImagePanel() {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (MouseImagePanel.this.image != null) {
                        int n = mouseEvent.getX() - MouseImagePanel.this.getOffsetX();
                        int n2 = mouseEvent.getY() - MouseImagePanel.this.getOffsetY();
                        DisplayImage.this.mousePosition.setText(n + ", " + n2);
                        DisplayImage.this.zoomPanel.update(n, n2);
                    } else {
                        DisplayImage.this.mousePosition.setText("No image loaded");
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (MouseImagePanel.this.image != null) {
                        JOptionPane.showMessageDialog(DisplayImage.this, "X: " + mouseEvent.getX() + ", Y: " + mouseEvent.getY());
                    }
                }
            });
        }
    }
}

