/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ZoomPanel
extends JPanel {
    protected int windowWidth;
    protected int windowHeight;
    protected BufferedImage img = null;
    protected int x = 0;
    protected int y = 0;

    public ZoomPanel(int n, int n2) {
        this.setSize(n, n2);
    }

    @Override
    public void setSize(int n, int n2) {
        this.windowWidth = n / 2;
        this.windowHeight = n2 / 2;
    }

    public void update(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.img = bufferedImage;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.img != null) {
            graphics.drawImage(this.img, 0, 0, this.getWidth(), this.getHeight(), this.x - this.windowWidth, this.y - this.windowHeight, this.x + this.windowWidth, this.y + this.windowHeight, this);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight());
            graphics.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
        } else {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

