/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.facecropping;

import ac.essex.ooechs.imaging.commons.Pixel;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.NodeSaver;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;

public class AccurateFaceCroppingGUI
extends JFrame {
    protected Vector<File> files;
    protected int cursor = 0;
    protected PixelLoader currentImage;
    protected String currentFilename;
    protected File currentDirectory;
    protected CroppingPanel panel;

    public static void main(String[] stringArray) {
        new AccurateFaceCroppingGUI(new File("/home/ooechs/Desktop/faces"));
    }

    public AccurateFaceCroppingGUI(File file) {
        this.getFiles(file);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    AccurateFaceCroppingGUI.this.next();
                }
                if (keyEvent.getKeyCode() == 38 && AccurateFaceCroppingGUI.this.panel.currentPixel != null) {
                    --AccurateFaceCroppingGUI.this.panel.currentPixel.y;
                    AccurateFaceCroppingGUI.this.panel.repaint();
                }
                if (keyEvent.getKeyCode() == 40 && AccurateFaceCroppingGUI.this.panel.currentPixel != null) {
                    ++AccurateFaceCroppingGUI.this.panel.currentPixel.y;
                    AccurateFaceCroppingGUI.this.panel.repaint();
                }
                if (keyEvent.getKeyCode() == 37 && AccurateFaceCroppingGUI.this.panel.currentPixel != null) {
                    --AccurateFaceCroppingGUI.this.panel.currentPixel.x;
                    AccurateFaceCroppingGUI.this.panel.repaint();
                }
                if (keyEvent.getKeyCode() == 39 && AccurateFaceCroppingGUI.this.panel.currentPixel != null) {
                    ++AccurateFaceCroppingGUI.this.panel.currentPixel.x;
                    AccurateFaceCroppingGUI.this.panel.repaint();
                }
            }
        });
        this.panel = new CroppingPanel();
        this.getContentPane().add(this.panel);
        this.setTitle("Accurate Face Cropping");
        this.setSize(640, 480);
        this.setVisible(true);
        this.setLocationRelativeTo(null);
        this.next();
    }

    public void getFiles(File file) {
        this.currentDirectory = file;
        this.files = new Vector(50);
        File[] fileArray = file.listFiles(new ImageFilenameFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            this.files.add(file2);
        }
    }

    public void next() {
        try {
            this.currentImage = new PixelLoader(this.files.elementAt(this.cursor));
            this.currentFilename = this.currentImage.getFilename();
            this.panel.setImage(this.currentImage);
            ++this.cursor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class CroppingPanel
    extends ImagePanel {
        public Pixel currentPixel;
        int mode = 0;
        Pixel leftEye;
        Pixel rightEye;
        Pixel centerPoint;
        Pixel mouth;
        double eyeAngle;
        int x;
        int y;
        double eyeDx;
        double eyeDy;

        public CroppingPanel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (CroppingPanel.this.mode == 0) {
                        CroppingPanel.this.currentPixel = CroppingPanel.this.leftEye = new Pixel(CroppingPanel.this.getX(mouseEvent), CroppingPanel.this.getY(mouseEvent));
                        ++CroppingPanel.this.mode;
                        CroppingPanel.this.repaint();
                        return;
                    }
                    if (CroppingPanel.this.mode == 1) {
                        CroppingPanel.this.rightEye = new Pixel(CroppingPanel.this.getX(mouseEvent), CroppingPanel.this.getY(mouseEvent));
                        ++CroppingPanel.this.mode;
                        CroppingPanel.this.calculateCenterPoint();
                        CroppingPanel.this.repaint();
                        CroppingPanel.this.currentPixel = CroppingPanel.this.rightEye;
                        return;
                    }
                    if (CroppingPanel.this.mode == 2) {
                        System.out.println("Saving nodes");
                        Vector<Pixel> vector = new Vector<Pixel>();
                        vector.add(CroppingPanel.this.leftEye);
                        vector.add(CroppingPanel.this.rightEye);
                        vector.add(CroppingPanel.this.mouth);
                        try {
                            NodeSaver.save(vector, new File(AccurateFaceCroppingGUI.this.currentDirectory, AccurateFaceCroppingGUI.this.currentFilename + ".nodes"));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        AccurateFaceCroppingGUI.this.next();
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    CroppingPanel.this.x = CroppingPanel.this.getX(mouseEvent);
                    CroppingPanel.this.y = CroppingPanel.this.getY(mouseEvent);
                    if (CroppingPanel.this.mode > 1) {
                        CroppingPanel.this.calculateCenterPoint();
                        CroppingPanel.this.repaint();
                    }
                }
            });
        }

        public void calculateCenterPoint() {
            this.eyeDx = this.rightEye.x - this.leftEye.x;
            this.eyeDy = this.rightEye.y - this.leftEye.y;
            double d = (double)this.leftEye.x + this.eyeDx / 2.0;
            double d2 = (double)this.leftEye.y + this.eyeDy / 2.0;
            this.centerPoint = new Pixel((int)d, (int)d2);
            this.eyeAngle = Math.tan(this.eyeDy / this.eyeDx);
        }

        @Override
        public void setImage(PixelLoader pixelLoader) {
            super.setImage(pixelLoader);
            this.mode = 0;
            this.leftEye = null;
            this.rightEye = null;
            this.mouth = null;
            this.centerPoint = null;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.leftEye != null) {
                this.paintNode(this.leftEye, graphics);
            }
            if (this.rightEye != null) {
                this.paintNode(this.rightEye, graphics);
            }
            if (this.centerPoint != null) {
                this.paintNode(this.centerPoint, graphics);
            }
            if (this.mode > 1) {
                this.drawLine(graphics, this.leftEye.x, this.leftEye.y, this.rightEye.x, this.rightEye.y);
                int n = this.y - this.centerPoint.y;
                int n2 = (int)((double)n * Math.tan(-this.eyeAngle));
                this.mouth = new Pixel(this.centerPoint.x + n2, this.centerPoint.y + n);
                this.drawLine(graphics, this.centerPoint.x, this.centerPoint.y, this.mouth.x, this.mouth.y);
                this.drawLine(graphics, (int)((double)this.mouth.x - this.eyeDx / 2.0), (int)((double)this.mouth.y - this.eyeDy / 2.0), (int)((double)this.mouth.x + this.eyeDx / 2.0), (int)((double)this.mouth.y + this.eyeDy / 2.0));
            }
            if (this.mouth != null) {
                this.paintNode(this.mouth, graphics);
            }
        }

        public void paintNode(Pixel pixel, Graphics graphics) {
            int n = 5;
            graphics.setColor(Color.WHITE);
            this.drawLine(graphics, pixel.x, pixel.y - n, pixel.x, pixel.y + n);
            this.drawLine(graphics, pixel.x + n, pixel.y, pixel.x - n, pixel.y);
        }
    }
}

