/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.training;

import ac.essex.ooechs.imaging.commons.ImageWindow;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.Resizer;
import ac.essex.ooechs.imaging.commons.apps.training.ImageWaiter;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class ImageDownloader
extends Thread {
    public static final String SAVE_TO = "/home/ooechs/Desktop/downloaded-test-images/";
    public static final int LEAVE_ORIGINAL = 0;
    public static final int RESIZE = 1;
    public static final int CROP = 2;
    protected String keyword;
    protected int imagesRequired;
    protected int width;
    protected int height;
    protected int mode;
    ImageWaiter waiter;
    private int attemptsCounter = 0;
    private int successCounter = 0;
    private int threads = 0;

    public static void main(String[] stringArray) {
        new ImageDownloader("dog", 10, null).start();
        new ImageDownloader("dog", 10, 320, 240, 2, null).start();
        new ImageDownloader("dog", 10, 320, 240, 1, null).start();
        new ImageDownloader("http://www.calvin.edu/news/photos/staff/", "a");
    }

    public ImageDownloader(String string, int n, ImageWaiter imageWaiter) {
        this(string, n, -1, -1, 0, imageWaiter);
    }

    public ImageDownloader(String string, int n, int n2, int n3, int n4, ImageWaiter imageWaiter) {
        this.keyword = string;
        this.width = n2;
        this.height = n3;
        this.mode = n4;
        this.waiter = imageWaiter;
        this.imagesRequired = n;
    }

    public ImageDownloader(String string, String string2) {
        this.keyword = string2;
        this.downloadDirectory(string);
    }

    @Override
    public void run() {
        System.out.println("Using ASK Image Search...");
        int n = 1;
        while (this.getSuccessCounter() < this.imagesRequired) {
            System.out.println("Getting page: " + n);
            this.ASKimageSearch("http://images.uk.ask.com/pictures?q=" + this.keyword + "&page=" + n);
            ++n;
        }
        System.out.println("Got: " + this.getSuccessCounter() + " images successfully ( of " + this.attemptsCounter + " attempts )");
    }

    private synchronized void ASKimageSearch(String string) {
        try {
            URLConnection uRLConnection = new URL(string).openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder(4096);
            while ((string = dataInputStream.readLine()) != null) {
                stringBuilder.append(string);
            }
            String string2 = stringBuilder.toString();
            Vector<String> vector = new Vector<String>(100);
            int n = 0;
            while (true) {
                int n2;
                String string3 = "imagesrc%3D";
                String string4 = "%26";
                if ((n = string2.indexOf(string3, n + 1)) == -1 || (n2 = string2.indexOf(string4, n + 1)) == -1) break;
                String string5 = this.decode(string2.substring(n + string3.length(), n2));
                if (!vector.contains(string5)) {
                    vector.add(string5);
                }
                n = n2 + 1;
            }
            uRLConnection = null;
            for (int i = 0; i < vector.size(); ++i) {
                ++this.attemptsCounter;
                new Downloader(this, (String)vector.elementAt(i), this.keyword + this.attemptsCounter + ".jpg").start();
            }
            try {
                System.out.println("Waiting, got " + this.getSuccessCounter() + " images");
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("!! Interrupted");
            }
        }
        catch (Exception exception) {
            System.out.println("!! Exception caught: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void downloadDirectory(String string) {
        try {
            String string2;
            URLConnection uRLConnection = new URL(string).openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            StringBuilder stringBuilder = new StringBuilder(4096);
            while ((string2 = dataInputStream.readLine()) != null) {
                stringBuilder.append(string2);
            }
            String string3 = stringBuilder.toString();
            Vector<String> vector = new Vector<String>(100);
            int n = 0;
            while (true) {
                int n2;
                String string4 = "href=\"";
                String string5 = "\"";
                if ((n = string3.indexOf(string4, n + 1)) == -1 || (n2 = string3.indexOf(string5, n + 1 + string4.length())) == -1) break;
                String string6 = string3.substring(n + string4.length(), n2);
                if (!vector.contains(string6) && string6.toLowerCase().endsWith(".jpg")) {
                    vector.add(string6);
                }
                n = n2 + 1;
            }
            uRLConnection = null;
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            System.out.println("Found " + vector.size() + " images.");
            for (int i = 0; i < vector.size(); ++i) {
                ++this.attemptsCounter;
                new Downloader(this, string + (String)vector.elementAt(i), this.keyword + this.attemptsCounter + ".jpg").start();
                System.out.println((String)vector.elementAt(i));
            }
        }
        catch (Exception exception) {
            System.out.println("!! Exception caught: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private synchronized void incrementSuccessCounter() {
        ++this.successCounter;
    }

    private synchronized int getSuccessCounter() {
        return this.successCounter;
    }

    private synchronized void registerThread() {
        ++this.threads;
    }

    private synchronized void deregisterThread() {
        --this.threads;
    }

    private synchronized int countThreads() {
        return this.threads;
    }

    private synchronized void stopWaiting() {
        System.out.println("Stopped Waiting, got " + this.getSuccessCounter() + " images");
        this.notify();
    }

    private String decode(String string) {
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '%') {
                if (cArray[i + 1] != '2' || cArray[i + 2] != '5') continue;
                if (cArray[i + 3] == '2' && cArray[i + 4] == 'F') {
                    stringBuilder.append('/');
                    i += 4;
                    continue;
                }
                if (cArray[i + 3] == '3' && cArray[i + 4] == 'A') {
                    stringBuilder.append(":");
                    i += 4;
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    class Downloader
    extends Thread {
        String httpURL;
        ImageDownloader parent;
        String filename;

        public Downloader(ImageDownloader imageDownloader2, String string, String string2) {
            ImageDownloader.this.registerThread();
            this.httpURL = string;
            this.parent = imageDownloader2;
            this.filename = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int n;
                String string;
                File file = new File(ImageDownloader.SAVE_TO);
                if (!file.exists()) {
                    System.out.println("Creating directory: /home/ooechs/Desktop/downloaded-test-images/");
                    file.mkdirs();
                }
                if ((string = this.httpURL.substring(this.httpURL.lastIndexOf(47) + 1).toLowerCase()).endsWith("gif")) {
                    return;
                }
                System.out.println("Downloading: " + this.httpURL);
                URL uRL = new URL(this.httpURL);
                InputStream inputStream = uRL.openStream();
                File file2 = new File(file, this.filename);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                System.out.println("Saved: " + this.filename);
                PixelLoader pixelLoader = new PixelLoader(file2);
                if (!pixelLoader.loadedOK) {
                    file2.delete();
                } else {
                    switch (ImageDownloader.this.mode) {
                        case 1: {
                            Resizer.resize(file2, 250);
                            break;
                        }
                        case 2: {
                            if (pixelLoader.getWidth() > ImageDownloader.this.width && pixelLoader.getHeight() > ImageDownloader.this.height) {
                                if (pixelLoader.getWidth() > ImageDownloader.this.width * 3) {
                                    Resizer.resize(file2, ImageDownloader.this.width * 3);
                                    pixelLoader = new PixelLoader(file2);
                                }
                                int n2 = pixelLoader.getWidth() - ImageDownloader.this.width;
                                int n3 = pixelLoader.getHeight() - ImageDownloader.this.height;
                                int n4 = (int)(Math.random() * (double)n2);
                                int n5 = (int)(Math.random() * (double)n3);
                                ImageWindow imageWindow = new ImageWindow(n4, n5, ImageDownloader.this.width, ImageDownloader.this.height);
                                pixelLoader = pixelLoader.getSubImage(imageWindow);
                                pixelLoader.saveAs(file2);
                                break;
                            }
                            file2.delete();
                        }
                    }
                }
                ImageDownloader.this.incrementSuccessCounter();
                if (ImageDownloader.this.waiter != null) {
                    ImageDownloader.this.waiter.receiveImage(file2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File Not Found: " + this.httpURL);
            }
            catch (Exception exception) {
                System.err.println("Exception caught: " + exception.getMessage());
            }
            finally {
                ImageDownloader.this.deregisterThread();
            }
            if (ImageDownloader.this.countThreads() < 1) {
                this.parent.stopWaiting();
            }
        }
    }
}

