/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.training;

import ac.essex.ooechs.imaging.commons.HaarRegions;
import ac.essex.ooechs.imaging.commons.Pixel;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.Resizer;
import ac.essex.ooechs.imaging.commons.apps.training.ImageDownloader;
import ac.essex.ooechs.imaging.commons.apps.training.ImageWaiter;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.BigEyeCroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.CroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.EyeCroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.FaceCroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.MouthCroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.RowleyFaceCroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.SimpleCroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.SquareCroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.StrategyException;
import ac.essex.ooechs.imaging.commons.cmu.FaceDefinition;
import ac.essex.ooechs.imaging.commons.cmu.GroundTruthReader;
import ac.essex.ooechs.imaging.commons.evolved.FaceDetectorA;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import ac.essex.ooechs.imaging.commons.util.Region;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class TrainingDataGUI
extends JFrame
implements ActionListener,
ImageWaiter {
    public static final String DEFAULT_FILENAME = "eye";
    File truthLocation = new File("/home/ooechs/ecj-training/faces/mit+cmu/truth.txt");
    CroppingPanel panel;
    int cropAllNumber = 5;
    JLabel coordinates;
    JLabel results;
    JLabel createdCount;
    int cropCount;
    JTextField directory;
    JTextField filename;
    JButton nextButton;
    JButton btnBrowse;
    ImageDownloader downloader;
    JMenuItem file_openFromWeb;
    JMenuItem file_openFromFolder;
    JMenuItem file_exit;
    JMenuItem edit_saveLocation;
    JMenuItem edit_cropSettings;
    JMenuItem run_facedetector;
    JMenuItem run_cropAll;
    JMenuItem run_stopFaceDetector;
    JMenuItem tools_autocropFaces;
    JMenuItem tools_autocropNonFaces;
    JMenuItem tools_autocropEyes;
    JMenuItem tools_autocropMouths;
    Vector<StrategyMenuItem> strategyMenus;
    int segmentsX = 4;
    int segmentsY = 4;
    int width = 32;
    int height = 40;
    double aspectRatio = 0.5;
    boolean autoResize = false;
    boolean maintainCropRegionAspectRatio = true;
    boolean crosshair = true;
    int crossHairX = 2;
    int crossHairY = 2;
    Vector<Pixel> objects;
    Vector<CroppingStrategy> strategies = new Vector(10);
    public static File currentDirectory;
    Vector<File> images;
    CropDialog cropDialog;
    int counter = 0;
    Vector buffer;
    final int BUFFER_SIZE = 5;
    public static String currentFilename;
    GroundTruthReader truth;

    public static void main(String[] stringArray) {
        new TrainingDataGUI();
    }

    public TrainingDataGUI() {
        super("Training Image Creator");
        JComponent jComponent;
        Object object;
        this.strategies.add(new SimpleCroppingStrategy());
        this.strategies.add(new RowleyFaceCroppingStrategy());
        this.strategies.add(new MouthCroppingStrategy());
        this.strategies.add(new EyeCroppingStrategy());
        this.strategies.add(new BigEyeCroppingStrategy());
        this.strategies.add(new SquareCroppingStrategy());
        this.directory = new JTextField(System.getProperty("user.dir"));
        this.images = new Vector(100);
        Container container = this.getContentPane();
        this.panel = new CroppingPanel();
        this.coordinates = new JLabel("");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.nextButton = new JButton("Next Image");
        this.results = new JLabel("No Images Found.");
        JMenu jMenu = new JMenu("File");
        this.file_openFromFolder = new JMenuItem("Acquire from local computer");
        this.file_openFromWeb = new JMenuItem("Acquire from www");
        this.file_exit = new JMenuItem("Exit");
        this.file_openFromWeb.addActionListener(this);
        this.file_openFromFolder.addActionListener(this);
        this.file_exit.addActionListener(this);
        jMenu.add(this.file_openFromWeb);
        jMenu.add(this.file_openFromFolder);
        jMenu.add(this.file_exit);
        JMenu jMenu2 = new JMenu("Edit");
        this.edit_saveLocation = new JMenuItem("Save Folder");
        this.edit_cropSettings = new JMenuItem("Cropping Settings");
        this.edit_saveLocation.addActionListener(this);
        this.edit_cropSettings.addActionListener(this);
        jMenu2.add(this.edit_saveLocation);
        jMenu2.add(this.edit_cropSettings);
        JMenu jMenu3 = new JMenu("Run");
        this.run_facedetector = new JMenuItem("Face Detector");
        this.run_cropAll = new JMenuItem("Crop All");
        this.run_stopFaceDetector = new JMenuItem("Stop");
        this.run_facedetector.addActionListener(this);
        this.run_cropAll.addActionListener(this);
        this.run_stopFaceDetector.addActionListener(this);
        this.run_cropAll.setEnabled(false);
        jMenu3.add(this.run_facedetector);
        jMenu3.add(this.run_cropAll);
        jMenu3.add(this.run_stopFaceDetector);
        JMenu jMenu4 = new JMenu("Crop");
        this.strategyMenus = new Vector(10);
        StrategyMenuItem strategyMenuItem = new StrategyMenuItem("Manual", null);
        strategyMenuItem.addActionListener(this);
        strategyMenuItem.setSelected(true);
        jMenu4.add(strategyMenuItem);
        this.strategyMenus.add(strategyMenuItem);
        for (int i = 0; i < this.strategies.size(); ++i) {
            object = this.strategies.elementAt(i);
            jComponent = new StrategyMenuItem(object.getName(), (CroppingStrategy)object);
            ((AbstractButton)jComponent).addActionListener(this);
            jMenu4.add((JMenuItem)jComponent);
            this.strategyMenus.add((StrategyMenuItem)jComponent);
        }
        this.tools_autocropFaces = new JMenuItem("Auto Crop Faces");
        this.tools_autocropFaces.addActionListener(this);
        this.tools_autocropNonFaces = new JMenuItem("Auto Crop Non Faces");
        this.tools_autocropNonFaces.addActionListener(this);
        this.tools_autocropNonFaces.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenu4.addSeparator();
        jMenu4.add(this.tools_autocropFaces);
        jMenu4.add(this.tools_autocropNonFaces);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
        jPanel.add(new JLabel("Saving to:"));
        this.directory.setPreferredSize(new Dimension(350, 20));
        jPanel.add(this.directory);
        this.btnBrowse = new JButton("...");
        this.btnBrowse.setToolTipText("Choose another folder to save images to");
        this.btnBrowse.addActionListener(this);
        jPanel.add(this.btnBrowse);
        this.filename = new JTextField(DEFAULT_FILENAME);
        this.filename.setPreferredSize(new Dimension(100, 20));
        jPanel.add(this.filename);
        jPanel.add(new JLabel(".bmp"));
        this.nextButton.addActionListener(this);
        container.add((Component)jPanel, "North");
        container.add((Component)new JScrollPane(this.panel), "Center");
        object = new JPanel(new GridLayout(1, 2));
        jComponent = new JPanel(new FlowLayout(0));
        this.createdCount = new JLabel("");
        jComponent.add(this.results);
        jComponent.add(this.coordinates);
        jComponent.add(this.createdCount);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.nextButton);
        ((Container)object).add(jComponent);
        ((Container)object).add(jPanel2);
        container.add((Component)object, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setSize(740, 480);
        this.setVisible(true);
    }

    public void incrementCropCount() {
        ++this.cropCount;
        this.createdCount.setText("Created " + this.cropCount + " images.");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object[] objectArray;
        File[] fileArray;
        int n2;
        Object object;
        if (actionEvent.getSource() instanceof StrategyMenuItem) {
            object = (StrategyMenuItem)actionEvent.getSource();
            this.panel.nodes.clear();
            this.panel.currentNode = null;
            this.panel.repaint();
            this.panel.currentStrategy = ((StrategyMenuItem)object).getStrategy();
            if (((StrategyMenuItem)object).getStrategy() != null) {
                JOptionPane.showMessageDialog(this, ((StrategyMenuItem)object).getStrategy().getDescription());
            }
            for (n2 = 0; n2 < this.strategyMenus.size(); ++n2) {
                fileArray.setSelected((fileArray = this.strategyMenus.elementAt(n2)) == actionEvent.getSource());
            }
        }
        if (actionEvent.getSource() == this.tools_autocropFaces) {
            this.autoCropFaces();
        }
        if (actionEvent.getSource() == this.tools_autocropNonFaces) {
            this.autoCropNonFaces();
        }
        if (actionEvent.getSource() == this.file_openFromWeb && (object = (String)JOptionPane.showInputDialog(this, "Search For\n", "Get Images from Web", -1, null, null, "")) != null && ((String)object).length() > 0 && (fileArray = (String)JOptionPane.showInputDialog(this, "How many images required?\n", "Get Images from Web", -1, null, objectArray = new Object[]{"10", "50", "100", "200", "500"}, "100")) != null && fileArray.length() > 0) {
            this.images.setSize(0);
            this.results.setText(this.images.size() + " images available");
            try {
                n = Integer.parseInt((String)fileArray);
                System.out.println("Searching for " + n + " images");
                this.downloader = new ImageDownloader((String)object, n, 92, 112, 0, this);
                this.downloader.start();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Please enter a number of images to search for.");
            }
        }
        if (actionEvent.getSource() == this.edit_saveLocation || actionEvent.getSource() == this.btnBrowse) {
            object = new JFileChooser(this.directory.getText());
            ((JFileChooser)object).setDialogTitle("Choose Save Folder");
            ((JFileChooser)object).setFileSelectionMode(1);
            n2 = ((JFileChooser)object).showOpenDialog(this);
            if (n2 == 0) {
                this.directory.setText(((JFileChooser)object).getSelectedFile().getAbsolutePath());
            }
        }
        if (actionEvent.getSource() == this.run_facedetector) {
            this.run_cropAll.setEnabled(true);
            this.panel.showObjects();
        }
        if (actionEvent.getSource() == this.run_stopFaceDetector) {
            this.run_cropAll.setEnabled(false);
            this.panel.stopShowingObjects();
        }
        if (actionEvent.getSource() == this.run_cropAll) {
            this.run_cropAll.setEnabled(false);
            this.panel.cropAll();
        }
        if (actionEvent.getSource() == this.edit_cropSettings) {
            if (this.cropDialog == null) {
                this.cropDialog = new CropDialog();
            } else {
                this.cropDialog.synchronise();
                this.cropDialog.setVisible(true);
            }
        }
        if (actionEvent.getSource() == this.file_openFromFolder) {
            object = new JFileChooser();
            ((JFileChooser)object).setFileSelectionMode(1);
            n2 = ((JFileChooser)object).showOpenDialog(this);
            if (n2 == 0) {
                this.images.setSize(0);
                this.results.setText(this.images.size() + " images available");
                currentDirectory = ((JFileChooser)object).getSelectedFile();
                fileArray = currentDirectory.listFiles();
                for (n = 0; n < fileArray.length; ++n) {
                    File file = fileArray[n];
                    if (!ImageFilenameFilter.isImage(file)) continue;
                    try {
                        this.images.add(file);
                        if (this.panel.getImage() == null) {
                            this.next();
                        }
                        this.results.setText(this.images.size() + " images available");
                        continue;
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(this, "Error: " + exception.getMessage());
                    }
                }
                if (this.images.size() == 0) {
                    JOptionPane.showMessageDialog(this, "Could not find any images in this folder.");
                }
            }
        }
        if (actionEvent.getSource() == this.file_exit) {
            System.exit(0);
        }
        if (actionEvent.getSource() == this.nextButton) {
            this.next();
        }
    }

    @Override
    public void receiveImage(File file) {
        this.results.setText(this.images.size() + " images available");
        this.images.add(file);
        if (this.panel.getImage() == null) {
            this.next();
        }
    }

    public void next() {
        this.objects = null;
        this.run_cropAll.setEnabled(false);
        if (this.images.size() == 0) {
            return;
        }
        this.panel.cropRegion = null;
        this.panel.nodes.clear();
        this.panel.currentNode = null;
        this.panel.previousCrops.setSize(0);
        BufferedImage bufferedImage = this.panel.getImage();
        if (bufferedImage != null) {
            bufferedImage = null;
            if (this.counter > 20) {
                this.counter = 0;
                System.gc();
            }
            ++this.counter;
        }
        try {
            PixelLoader pixelLoader = new PixelLoader(this.images.firstElement());
            currentFilename = pixelLoader.getFile().getName();
            this.panel.setImage(pixelLoader);
        }
        catch (Exception exception) {
            System.err.println("Can't load image.");
        }
        this.images.removeElementAt(0);
        this.results.setText(this.images.size() + " images available");
    }

    public void autoCropFaces() {
        Vector<FaceDefinition> vector;
        if (this.truth == null) {
            this.truth = new GroundTruthReader(this.truthLocation);
        }
        if ((vector = this.truth.getFaces(currentFilename)) == null) {
            JOptionPane.showMessageDialog(this, "Cannot find truth definitions for this image: " + currentFilename);
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                FaceDefinition faceDefinition = vector.elementAt(i);
                this.panel.cropRegion = new FaceCroppingStrategy().getCroppingRegion(faceDefinition.getLeftEye(), faceDefinition.getRightEye());
                this.panel.crop(true);
            }
        }
    }

    public void autoCropNonFaces() {
        for (int i = 0; i < 5; ++i) {
            int n;
            int n2 = n = (int)Math.max((double)Math.min(this.panel.getImage().getWidth(), this.panel.getImage().getHeight()) * 0.5 * Math.random(), 20.0);
            int n3 = (int)Math.min((double)this.panel.getImage().getWidth() * Math.random(), (double)(this.panel.getImage().getWidth() - n));
            int n4 = (int)Math.min((double)this.panel.getImage().getHeight() * Math.random(), (double)(this.panel.getImage().getHeight() - n2));
            this.panel.cropRegion = new Region(n3, n4, n, n2);
            boolean bl = false;
            for (int j = 0; j < this.panel.previousCrops.size(); ++j) {
                Region region = this.panel.previousCrops.elementAt(j);
                if (!(this.panel.cropRegion.overlap(region) > 0.33)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.panel.crop(true);
            }
            this.panel.cropRegion = null;
        }
    }

    public void autoCropEyes() {
        Vector<FaceDefinition> vector;
        if (this.truth == null) {
            this.truth = new GroundTruthReader(this.truthLocation);
        }
        if ((vector = this.truth.getFaces(currentFilename)) == null) {
            JOptionPane.showMessageDialog(this, "Cannot find truth definitions for this image: " + currentFilename);
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                FaceDefinition faceDefinition = vector.elementAt(i);
                this.panel.cropRegion = new FaceCroppingStrategy().getCroppingRegion(faceDefinition.getLeftEye(), faceDefinition.getRightEye());
                this.panel.crop(true);
            }
        }
    }

    static {
        currentFilename = "[NO FILE]";
    }

    class CroppingPanel
    extends ImagePanel {
        final int CROP = 0;
        final int MOVE = 1;
        int currentX;
        int currentY;
        int moveX;
        int moveY;
        boolean mouseDown = false;
        int mode = 0;
        Region cropRegion;
        Region previousPosition;
        Region ne;
        Region nw;
        Region se;
        Region sw;
        Region n;
        Region e;
        Region s;
        Region w;
        CroppingStrategy currentStrategy = null;
        Vector<Pixel> nodes;
        Pixel currentNode = null;
        Vector<Region> previousCrops = new Vector(20);
        HaarRegions haar;

        public CroppingPanel() {
            this.nodes = new Vector(10);
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    CroppingPanel.this.requestFocusInWindow();
                    CroppingPanel.this.currentX = CroppingPanel.this.getX(mouseEvent);
                    CroppingPanel.this.currentY = CroppingPanel.this.getY(mouseEvent);
                    TrainingDataGUI.this.coordinates.setText("x=" + CroppingPanel.this.currentX + ", y=" + CroppingPanel.this.currentY);
                    CroppingPanel.this.mouseDown = false;
                    if (CroppingPanel.this.cropRegion != null) {
                        if (CroppingPanel.this.cropRegion.contains(mouseEvent, CroppingPanel.this)) {
                            CroppingPanel.this.setCursor(new Cursor(13));
                            return;
                        }
                        if (CroppingPanel.this.ne != null && CroppingPanel.this.ne.contains(mouseEvent, CroppingPanel.this)) {
                            CroppingPanel.this.setCursor(new Cursor(7));
                            return;
                        }
                        if (CroppingPanel.this.se != null && CroppingPanel.this.se.contains(mouseEvent, CroppingPanel.this)) {
                            CroppingPanel.this.setCursor(new Cursor(5));
                            return;
                        }
                        if (CroppingPanel.this.sw != null && CroppingPanel.this.sw.contains(mouseEvent, CroppingPanel.this)) {
                            CroppingPanel.this.setCursor(new Cursor(4));
                            return;
                        }
                        if (CroppingPanel.this.nw != null && CroppingPanel.this.nw.contains(mouseEvent, CroppingPanel.this)) {
                            CroppingPanel.this.setCursor(new Cursor(6));
                            return;
                        }
                        if (CroppingPanel.this.n != null && CroppingPanel.this.n.contains(mouseEvent, CroppingPanel.this)) {
                            CroppingPanel.this.setCursor(new Cursor(8));
                            return;
                        }
                        if (CroppingPanel.this.s != null && CroppingPanel.this.s.contains(mouseEvent, CroppingPanel.this)) {
                            CroppingPanel.this.setCursor(new Cursor(9));
                            return;
                        }
                        if (CroppingPanel.this.e != null && CroppingPanel.this.e.contains(mouseEvent, CroppingPanel.this)) {
                            CroppingPanel.this.setCursor(new Cursor(11));
                            return;
                        }
                        if (CroppingPanel.this.w != null && CroppingPanel.this.w.contains(mouseEvent, CroppingPanel.this)) {
                            CroppingPanel.this.setCursor(new Cursor(10));
                            return;
                        }
                    }
                    CroppingPanel.this.setCursor(new Cursor(0));
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    if (!CroppingPanel.this.mouseDown) {
                        CroppingPanel.this.moveX = CroppingPanel.this.getX(mouseEvent);
                        CroppingPanel.this.moveY = CroppingPanel.this.getY(mouseEvent);
                        switch (CroppingPanel.this.getCursor().getType()) {
                            case 0: {
                                CroppingPanel.this.cropRegion = new Region(CroppingPanel.this.getX(mouseEvent), mouseEvent.getY());
                                break;
                            }
                            default: {
                                CroppingPanel.this.previousPosition = new Region(CroppingPanel.this.cropRegion);
                                break;
                            }
                        }
                    } else {
                        int n = CroppingPanel.this.getX(mouseEvent) - CroppingPanel.this.moveX;
                        int n2 = CroppingPanel.this.getY(mouseEvent) - CroppingPanel.this.moveY;
                        switch (CroppingPanel.this.getCursor().getType()) {
                            case 6: {
                                CroppingPanel.this.cropRegion.x1 = CroppingPanel.this.previousPosition.x1 + n;
                                CroppingPanel.this.cropRegion.y1 = CroppingPanel.this.previousPosition.y1 + n2;
                                break;
                            }
                            case 7: {
                                CroppingPanel.this.cropRegion.x2 = CroppingPanel.this.previousPosition.x2 + n;
                                CroppingPanel.this.cropRegion.y1 = CroppingPanel.this.previousPosition.y1 + n2;
                                break;
                            }
                            case 5: {
                                CroppingPanel.this.cropRegion.x2 = CroppingPanel.this.previousPosition.x2 + n;
                                CroppingPanel.this.cropRegion.y2 = CroppingPanel.this.previousPosition.y2 + n2;
                                break;
                            }
                            case 4: {
                                CroppingPanel.this.cropRegion.x1 = CroppingPanel.this.previousPosition.x1 + n;
                                CroppingPanel.this.cropRegion.y2 = CroppingPanel.this.previousPosition.y2 + n2;
                                break;
                            }
                            case 8: {
                                CroppingPanel.this.cropRegion.y1 = CroppingPanel.this.previousPosition.y1 + n2;
                                break;
                            }
                            case 11: {
                                CroppingPanel.this.cropRegion.x2 = CroppingPanel.this.previousPosition.x2 + n;
                                break;
                            }
                            case 9: {
                                CroppingPanel.this.cropRegion.y2 = CroppingPanel.this.previousPosition.y2 + n2;
                                break;
                            }
                            case 10: {
                                CroppingPanel.this.cropRegion.x1 = CroppingPanel.this.previousPosition.x1 + n;
                                break;
                            }
                            case 13: {
                                CroppingPanel.this.cropRegion.move(CroppingPanel.this.previousPosition, n, n2);
                                break;
                            }
                            case 0: {
                                CroppingPanel.this.cropRegion.x2 = CroppingPanel.this.getX(mouseEvent);
                                CroppingPanel.this.cropRegion.y2 = CroppingPanel.this.getY(mouseEvent);
                            }
                        }
                    }
                    CroppingPanel.this.placeHandles();
                    CroppingPanel.this.mouseDown = true;
                    CroppingPanel.this.repaint();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() != 1) {
                        CroppingPanel.this.cropRegion = null;
                        CroppingPanel.this.nodes.clear();
                        CroppingPanel.this.currentNode = null;
                    } else if (CroppingPanel.this.currentStrategy == null) {
                        if (mouseEvent.getClickCount() == 2) {
                            CroppingPanel.this.crop(false);
                        }
                        if (mouseEvent.getClickCount() == 1) {
                            CroppingPanel.this.setSize();
                        }
                    } else {
                        CroppingPanel.this.currentNode = new Pixel(CroppingPanel.this.getX(mouseEvent), CroppingPanel.this.getY(mouseEvent));
                        if (CroppingPanel.this.nodes.size() == CroppingPanel.this.currentStrategy.countNodes()) {
                            CroppingPanel.this.nodes.setElementAt(CroppingPanel.this.currentNode, CroppingPanel.this.nodes.size() - 1);
                        } else {
                            CroppingPanel.this.nodes.add(CroppingPanel.this.currentNode);
                        }
                    }
                    CroppingPanel.this.repaint();
                }
            });
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    if (mouseWheelEvent.getUnitsToScroll() > 0) {
                        CroppingPanel.this.zoomOut();
                    } else {
                        CroppingPanel.this.zoomIn();
                    }
                    CroppingPanel.this.repaint();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == 's') {
                        CroppingPanel.this.setStandardisedSize();
                    }
                    if (keyEvent.getKeyChar() == 'f') {
                        TrainingDataGUI.this.autoCropFaces();
                    }
                    if (keyEvent.getKeyChar() == 'r') {
                        TrainingDataGUI.this.run_cropAll.setEnabled(true);
                        TrainingDataGUI.this.panel.showObjects();
                    }
                    if (keyEvent.getKeyChar() == 'c') {
                        TrainingDataGUI.this.run_cropAll.setEnabled(false);
                        TrainingDataGUI.this.panel.cropAll();
                    }
                    if (CroppingPanel.this.cropRegion != null) {
                        if (keyEvent.getKeyCode() == 38) {
                            CroppingPanel.this.cropRegion.move(0, -1);
                            CroppingPanel.this.placeHandles();
                            CroppingPanel.this.repaint();
                        }
                        if (keyEvent.getKeyCode() == 40) {
                            CroppingPanel.this.cropRegion.move(0, 1);
                            CroppingPanel.this.placeHandles();
                            CroppingPanel.this.repaint();
                        }
                        if (keyEvent.getKeyCode() == 37) {
                            CroppingPanel.this.cropRegion.move(-1, 0);
                            CroppingPanel.this.placeHandles();
                            CroppingPanel.this.repaint();
                        }
                        if (keyEvent.getKeyCode() == 39) {
                            CroppingPanel.this.cropRegion.move(1, 0);
                            CroppingPanel.this.placeHandles();
                            CroppingPanel.this.repaint();
                        }
                        if (keyEvent.getKeyCode() == 27) {
                            CroppingPanel.this.cropRegion = null;
                            CroppingPanel.this.repaint();
                        }
                        if (keyEvent.getKeyCode() == 10) {
                            CroppingPanel.this.crop(false);
                        }
                    } else {
                        if (CroppingPanel.this.currentNode != null) {
                            if (keyEvent.getKeyCode() == 38) {
                                CroppingPanel.this.currentNode.move(0, -1);
                                CroppingPanel.this.repaint();
                            }
                            if (keyEvent.getKeyCode() == 40) {
                                CroppingPanel.this.currentNode.move(0, 1);
                                CroppingPanel.this.repaint();
                            }
                            if (keyEvent.getKeyCode() == 37) {
                                CroppingPanel.this.currentNode.move(-1, 0);
                                CroppingPanel.this.repaint();
                            }
                            if (keyEvent.getKeyCode() == 39) {
                                CroppingPanel.this.currentNode.move(1, 0);
                                CroppingPanel.this.repaint();
                            }
                            if (keyEvent.getKeyCode() == 10) {
                                CroppingPanel.this.autoCreateCropRegion();
                                CroppingPanel.this.repaint();
                            }
                            return;
                        }
                        if (keyEvent.getKeyCode() == 39) {
                            TrainingDataGUI.this.next();
                        }
                    }
                    if (keyEvent.getKeyCode() == 32) {
                        CroppingPanel.this.cropRegion = new Region(CroppingPanel.this.currentX, CroppingPanel.this.currentY);
                        CroppingPanel.this.setStandardisedSize();
                        CroppingPanel.this.crop(false);
                    }
                }
            });
        }

        private void autoCreateCropRegion() {
            System.out.println("Auto create crop region");
            try {
                this.cropRegion = this.currentStrategy.getCropRegion(this.image, this.nodes);
                this.nodes.clear();
                this.currentNode = null;
                this.placeHandles();
                this.repaint();
            }
            catch (StrategyException strategyException) {
                JOptionPane.showMessageDialog(this, strategyException.getMessage());
            }
        }

        private void setStandardisedSize() {
            if (this.cropRegion != null) {
                this.cropRegion.setWidth(TrainingDataGUI.this.width);
                this.cropRegion.setHeight(TrainingDataGUI.this.height);
                this.placeHandles();
                this.repaint();
            }
        }

        private void placeHandles() {
            int n = 9;
            int n2 = 6;
            this.nw = new Region(this.cropRegion.getStartX() - n, this.cropRegion.getStartY() - n, n2, n2);
            this.ne = new Region(this.cropRegion.getStartX() + this.cropRegion.getWidth() + (n - n2), this.cropRegion.getStartY() - n, n2, n2);
            this.n = new Region(this.cropRegion.getStartX(), this.cropRegion.getStartY(), n2, n2);
            this.n.move((this.cropRegion.getWidth() - n2) / 2, -n);
            this.w = new Region(this.cropRegion.getStartX(), this.cropRegion.getStartY(), n2, n2);
            this.w.move(-n, (this.cropRegion.getHeight() - n2) / 2);
            this.e = new Region(this.cropRegion.getStartX(), this.cropRegion.getStartY(), n2, n2);
            this.e.move(this.cropRegion.getWidth() + (n - n2), (this.cropRegion.getHeight() - n2) / 2);
            this.s = new Region(this.cropRegion.getStartX(), this.cropRegion.getStartY(), n2, n2);
            this.s.move((this.cropRegion.getWidth() - n2) / 2, this.cropRegion.getHeight() + (n - n2));
            this.sw = new Region(this.cropRegion.getStartX() - n, this.cropRegion.getStartY() + this.cropRegion.getHeight() + (n - n2), n2, n2);
            this.se = new Region(this.cropRegion.getStartX() + this.cropRegion.getWidth() + (n - n2), this.cropRegion.getStartY() + this.cropRegion.getHeight() + (n - n2), n2, n2);
        }

        public void setSize() {
            if (this.cropRegion != null) {
                int n = this.cropRegion.getHeight() / TrainingDataGUI.this.segmentsY * TrainingDataGUI.this.segmentsY;
                double d = (double)n * TrainingDataGUI.this.aspectRatio;
                double d2 = d - (double)this.cropRegion.getWidth();
                this.cropRegion.setWidth((int)d);
                this.cropRegion.setHeight(n);
                this.cropRegion.move((int)(-d2 / 2.0), 0);
                this.placeHandles();
                this.repaint();
            }
        }

        public void cropAll() {
            if (TrainingDataGUI.this.objects == null) {
                return;
            }
            double d = (double)TrainingDataGUI.this.cropAllNumber / (double)TrainingDataGUI.this.objects.size();
            this.cropRegion = null;
            Graphics graphics = this.getImage().getGraphics();
            Vector<Pixel> vector = new Vector<Pixel>(TrainingDataGUI.this.cropAllNumber);
            for (int i = 0; i < TrainingDataGUI.this.objects.size(); ++i) {
                if (!(Math.random() < d)) continue;
                Pixel pixel = TrainingDataGUI.this.objects.elementAt(i);
                this.cropRegion = new Region(pixel.x, pixel.y, TrainingDataGUI.this.width, TrainingDataGUI.this.height);
                this.crop(true);
                vector.add(pixel);
            }
            this.repaint();
        }

        public void crop(boolean bl) {
            if (this.getImage() != null) {
                try {
                    int n = this.cropRegion.getWidth();
                    int n2 = this.cropRegion.getHeight();
                    int n3 = this.cropRegion.getStartX();
                    int n4 = this.cropRegion.getStartY();
                    PixelLoader pixelLoader = new PixelLoader(this.getImage().getSubimage(n3, n4, n, n2));
                    this.previousCrops.add(this.cropRegion);
                    this.save(pixelLoader, bl);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, exception.getMessage());
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(this, "No image selected. Search for an image first.");
            }
            this.cropRegion = null;
            this.repaint();
        }

        public void save(PixelLoader pixelLoader, boolean bl) {
            try {
                File file;
                File file2 = new File(TrainingDataGUI.this.directory.getText());
                file2.mkdirs();
                int n = 0;
                String string = "autocropped";
                if (!bl) {
                    string = TrainingDataGUI.this.filename.getText();
                }
                while ((file = new File(file2, string + this.counterToString(++n) + ".bmp")).exists()) {
                }
                pixelLoader.saveAs(file);
                if (TrainingDataGUI.this.autoResize) {
                    Resizer.resize(file, TrainingDataGUI.this.width);
                }
                TrainingDataGUI.this.incrementCropCount();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage());
            }
        }

        private String counterToString(int n) {
            if (n < 10) {
                return "00" + n;
            }
            if (n < 100) {
                return "0" + n;
            }
            return String.valueOf(n);
        }

        public void showObjects() {
            if (this.image != null) {
                this.haar = new HaarRegions(new PixelLoader(this.image));
                this.haar.setWindowPosition(0, 0, TrainingDataGUI.this.width, TrainingDataGUI.this.height, TrainingDataGUI.this.segmentsX, TrainingDataGUI.this.segmentsY);
                TrainingDataGUI.this.objects = new FaceDetectorA().getObjects(this.haar);
                this.repaint();
            } else {
                JOptionPane.showMessageDialog(this, "No image loaded!");
            }
        }

        public void stopShowingObjects() {
            TrainingDataGUI.this.objects = null;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            super.paintComponent(graphics);
            graphics.setColor(Color.BLACK);
            for (n4 = 0; n4 < this.previousCrops.size(); ++n4) {
                Region region = this.previousCrops.elementAt(n4);
                int n5 = region.getWidth();
                n3 = region.getHeight();
                n2 = region.getStartX();
                int n6 = region.getStartY();
                this.fillRect(graphics, n2, n6, n5, n3);
            }
            if (TrainingDataGUI.this.objects != null) {
                new FaceDetectorA().drawObjects(TrainingDataGUI.this.objects, this.haar, graphics);
            }
            n4 = 5;
            for (n = 0; n < this.nodes.size(); ++n) {
                Pixel pixel = this.nodes.elementAt(n);
                graphics.setColor(Color.WHITE);
                this.drawLine(graphics, pixel.x, pixel.y - n4, pixel.x, pixel.y + n4);
                this.drawLine(graphics, pixel.x + n4, pixel.y, pixel.x - n4, pixel.y);
            }
            if (this.cropRegion != null) {
                int n7;
                int n8;
                n = this.cropRegion.getWidth();
                int n9 = this.cropRegion.getHeight();
                n3 = this.cropRegion.getStartX();
                n2 = this.cropRegion.getStartY();
                Color color = Color.BLACK;
                if (this.image != null) {
                    if (n3 + n > this.image.getWidth()) {
                        color = Color.RED;
                    }
                    if (n2 + n9 > this.image.getHeight()) {
                        color = Color.RED;
                    }
                    if (n3 < 0) {
                        color = Color.RED;
                    }
                    if (n2 < 0) {
                        color = Color.RED;
                    }
                }
                graphics.setColor(color);
                this.drawRect(graphics, n3, n2, n, n9);
                graphics.setColor(Color.GRAY);
                for (n8 = 1; n8 < TrainingDataGUI.this.segmentsY; ++n8) {
                    n7 = n2 + (int)((double)n9 * ((double)n8 / (double)TrainingDataGUI.this.segmentsY));
                    graphics.setColor(Color.GRAY);
                    if (TrainingDataGUI.this.crosshair && n8 == TrainingDataGUI.this.crossHairX) {
                        graphics.setColor(color);
                    }
                    this.drawLine(graphics, n3, n7, n3 + n, n7);
                }
                for (n8 = 1; n8 < TrainingDataGUI.this.segmentsX; ++n8) {
                    n7 = n3 + (int)((double)n * ((double)n8 / (double)TrainingDataGUI.this.segmentsX));
                    graphics.setColor(Color.GRAY);
                    if (TrainingDataGUI.this.crosshair && n8 == TrainingDataGUI.this.crossHairY) {
                        graphics.setColor(color);
                    }
                    this.drawLine(graphics, n7, n2, n7, n2 + n9);
                }
                graphics.setColor(Color.BLACK);
                if (this.ne != null) {
                    this.ne.fill(graphics, this);
                    this.nw.fill(graphics, this);
                    this.se.fill(graphics, this);
                    this.sw.fill(graphics, this);
                    this.n.fill(graphics, this);
                    this.w.fill(graphics, this);
                    this.e.fill(graphics, this);
                    this.s.fill(graphics, this);
                }
            }
        }
    }

    class CropDialog
    extends JFrame
    implements ActionListener {
        JButton ok;
        JButton cancel;
        JTextField segmentsXField;
        JTextField segmentsYField;
        JTextField widthField;
        JTextField heightField;
        JTextField crosshairXField;
        JTextField crosshairYField;
        JCheckBox resize;
        JCheckBox maintainAspectRatio;
        JCheckBox showCrosshair;

        public void synchronise() {
            this.segmentsXField.setText(String.valueOf(TrainingDataGUI.this.segmentsX));
            this.segmentsYField.setText(String.valueOf(TrainingDataGUI.this.segmentsY));
            this.widthField.setText(String.valueOf(TrainingDataGUI.this.width));
            this.heightField.setText(String.valueOf(TrainingDataGUI.this.height));
            this.crosshairXField.setText(String.valueOf(TrainingDataGUI.this.crossHairX));
            this.crosshairYField.setText(String.valueOf(TrainingDataGUI.this.crossHairY));
            this.resize.setSelected(TrainingDataGUI.this.autoResize);
            this.showCrosshair.setSelected(TrainingDataGUI.this.crosshair);
            this.maintainAspectRatio.setSelected(TrainingDataGUI.this.maintainCropRegionAspectRatio);
        }

        public CropDialog() {
            super("Crop Settings");
            JPanel jPanel = new JPanel(new GridLayout(7, 1));
            this.segmentsXField = new JTextField(String.valueOf(TrainingDataGUI.this.segmentsX));
            this.segmentsYField = new JTextField(String.valueOf(TrainingDataGUI.this.segmentsY));
            this.resize = new JCheckBox("Auto resize crop region to:", TrainingDataGUI.this.autoResize);
            this.resize.addActionListener(this);
            this.widthField = new JTextField(String.valueOf(TrainingDataGUI.this.width));
            this.heightField = new JTextField(String.valueOf(TrainingDataGUI.this.height));
            this.showCrosshair = new JCheckBox("Show Crosshair", TrainingDataGUI.this.crosshair);
            this.crosshairXField = new JTextField(String.valueOf(TrainingDataGUI.this.crossHairX));
            this.crosshairYField = new JTextField(String.valueOf(TrainingDataGUI.this.crossHairY));
            this.maintainAspectRatio = new JCheckBox("Maintain Aspect Ratio", TrainingDataGUI.this.maintainCropRegionAspectRatio);
            this.updateTextFields();
            jPanel.add(new JLabel("Segments X:"));
            jPanel.add(this.segmentsXField);
            jPanel.add(new JLabel("Segments Y:"));
            jPanel.add(this.segmentsYField);
            jPanel.add(new JLabel("Resize:"));
            jPanel.add(this.resize);
            jPanel.add(new JLabel("Width:"));
            jPanel.add(this.widthField);
            jPanel.add(new JLabel("Height"));
            jPanel.add(this.heightField);
            jPanel.add(new JLabel("Aspect Ratio:"));
            jPanel.add(this.maintainAspectRatio);
            jPanel.add(new JLabel("Special:"));
            jPanel.add(this.showCrosshair);
            JPanel jPanel2 = new JPanel(new FlowLayout(2));
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            jPanel2.add(this.ok);
            jPanel2.add(this.cancel);
            Container container = this.getContentPane();
            container.add((Component)jPanel, "Center");
            container.add((Component)jPanel2, "South");
            this.setSize(350, 200);
            this.setVisible(true);
        }

        private void updateTextFields() {
            this.widthField.setEnabled(this.resize.isSelected());
            this.heightField.setEnabled(this.resize.isSelected());
            this.crosshairXField.setEnabled(this.showCrosshair.isSelected());
            this.crosshairYField.setEnabled(this.showCrosshair.isSelected());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.resize || actionEvent.getSource() == this.showCrosshair) {
                this.updateTextFields();
                return;
            }
            if (actionEvent.getSource() == this.ok) {
                try {
                    TrainingDataGUI.this.autoResize = this.resize.isSelected();
                    TrainingDataGUI.this.maintainCropRegionAspectRatio = this.maintainAspectRatio.isSelected();
                    TrainingDataGUI.this.crosshair = this.showCrosshair.isSelected();
                    TrainingDataGUI.this.segmentsX = Integer.parseInt(this.segmentsXField.getText());
                    TrainingDataGUI.this.segmentsY = Integer.parseInt(this.segmentsYField.getText());
                    if (this.resize.isSelected()) {
                        TrainingDataGUI.this.width = Integer.parseInt(this.widthField.getText());
                        TrainingDataGUI.this.height = Integer.parseInt(this.heightField.getText());
                    }
                    if (this.showCrosshair.isSelected()) {
                        TrainingDataGUI.this.crossHairX = Integer.parseInt(this.crosshairXField.getText());
                        TrainingDataGUI.this.crossHairY = Integer.parseInt(this.crosshairYField.getText());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Can't read number:\n" + numberFormatException.getMessage());
                    return;
                }
            }
            this.setVisible(false);
        }
    }

    class StrategyMenuItem
    extends JCheckBoxMenuItem {
        CroppingStrategy strategy;

        public StrategyMenuItem(String string, CroppingStrategy croppingStrategy) {
            super(string);
            this.strategy = croppingStrategy;
        }

        public CroppingStrategy getStrategy() {
            return this.strategy;
        }
    }
}

