/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.training.strategies;

import ac.essex.ooechs.imaging.commons.Pixel;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.CroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.StrategyException;
import ac.essex.ooechs.imaging.commons.util.Region;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class EyeCroppingStrategy
implements CroppingStrategy {
    @Override
    public String getName() {
        return "Eye Cropper";
    }

    @Override
    public String getDescription() {
        return "Click on the left and right side of the eye to crop.";
    }

    @Override
    public int countNodes() {
        return 2;
    }

    @Override
    public double getAspectRatio() {
        return 1.0;
    }

    @Override
    public Region getCropRegion(BufferedImage bufferedImage, Vector<Pixel> vector) throws StrategyException {
        if (vector.size() != this.countNodes()) {
            throw new StrategyException("Cannot crop, I need an eye position first!");
        }
        Pixel pixel = vector.elementAt(0);
        Pixel pixel2 = vector.elementAt(1);
        return this.getCroppingRegion(pixel, pixel2);
    }

    public Region getCroppingRegion(Pixel pixel, Pixel pixel2) {
        Pixel pixel3;
        Pixel pixel4;
        Pixel pixel5;
        Pixel pixel6;
        if (pixel.x < pixel2.x) {
            pixel6 = pixel;
            pixel5 = pixel2;
        } else {
            pixel6 = pixel2;
            pixel5 = pixel;
        }
        if (pixel.y < pixel2.y) {
            pixel4 = pixel;
            pixel3 = pixel2;
        } else {
            pixel4 = pixel2;
            pixel3 = pixel;
        }
        double d = pixel5.x - pixel6.x;
        double d2 = pixel3.y - pixel4.y;
        double d3 = (double)pixel6.x + d / 2.0;
        double d4 = (double)pixel4.y + d2 / 2.0;
        double d5 = d * 2.0;
        double d6 = d5 / this.getAspectRatio();
        double d7 = d3 - d5 / 2.0;
        double d8 = d4 - d6 * 0.5;
        return new Region((int)d7, (int)d8, (int)d5, (int)d6);
    }
}

