/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.training.strategies;

import ac.essex.ooechs.imaging.commons.Pixel;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.CroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.StrategyException;
import ac.essex.ooechs.imaging.commons.util.Region;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class MouthCroppingStrategy
implements CroppingStrategy {
    @Override
    public String getName() {
        return "Mouth Cropper";
    }

    @Override
    public String getDescription() {
        return "Select the outer edges of the mouth on the left and right to create the cropped region";
    }

    @Override
    public int countNodes() {
        return 2;
    }

    @Override
    public double getAspectRatio() {
        return 1.0;
    }

    @Override
    public Region getCropRegion(BufferedImage bufferedImage, Vector<Pixel> vector) throws StrategyException {
        Pixel pixel;
        Pixel pixel2;
        Pixel pixel3;
        Pixel pixel4;
        if (vector.size() != this.countNodes()) {
            throw new StrategyException("Cannot crop, I need two eye positions to create a face!");
        }
        Pixel pixel5 = vector.elementAt(0);
        Pixel pixel6 = vector.elementAt(1);
        if (pixel5.x < pixel6.x) {
            pixel4 = pixel5;
            pixel3 = pixel6;
        } else {
            pixel4 = pixel6;
            pixel3 = pixel5;
        }
        if (pixel5.y < pixel6.y) {
            pixel2 = pixel5;
            pixel = pixel6;
        } else {
            pixel2 = pixel6;
            pixel = pixel5;
        }
        double d = pixel3.x - pixel4.x;
        double d2 = pixel.y - pixel2.y;
        double d3 = (double)pixel4.x + d / 2.0;
        double d4 = (double)pixel2.y + d2 / 2.0;
        double d5 = d * 1.0;
        double d6 = d5 / this.getAspectRatio();
        double d7 = d3 - d5 / 2.0;
        double d8 = d4 - d6 * 0.4;
        return new Region((int)d7, (int)d8, (int)d5, (int)d6);
    }
}

