/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.training.strategies;

import ac.essex.ooechs.imaging.commons.Pixel;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.apps.training.TrainingDataGUI;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.CroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.NodeSaver;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.StrategyException;
import ac.essex.ooechs.imaging.commons.subpixel.SubPixel;
import ac.essex.ooechs.imaging.commons.util.Region;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class RowleyFaceCroppingStrategy
implements CroppingStrategy {
    static boolean dontSaveImages = true;

    public static void main(String[] stringArray) throws Exception {
        File file = new File("/home/ooechs/Desktop/faces");
        File[] fileArray = file.listFiles();
        dontSaveImages = false;
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            File file3 = new File(file2.getParentFile(), file2.getName() + ".nodes");
            if (!file3.exists()) continue;
            PixelLoader pixelLoader = new PixelLoader(file2);
            Vector<Pixel> vector = NodeSaver.load(file3);
            System.out.println("Processing image");
            new RowleyFaceCroppingStrategy().getCroppingRegion(pixelLoader, vector.elementAt(0), vector.elementAt(1), vector.elementAt(2));
        }
    }

    @Override
    public String getName() {
        return "Rowley Face";
    }

    @Override
    public String getDescription() {
        return "Click on the center of the left and right eyes, then on the middle of the upper lip";
    }

    @Override
    public int countNodes() {
        return 3;
    }

    @Override
    public double getAspectRatio() {
        return 1.0;
    }

    @Override
    public Region getCropRegion(BufferedImage bufferedImage, Vector<Pixel> vector) throws StrategyException {
        if (vector.size() != this.countNodes()) {
            throw new StrategyException("Cannot crop, I need an eye position first!");
        }
        Pixel pixel = vector.elementAt(0);
        Pixel pixel2 = vector.elementAt(1);
        Pixel pixel3 = vector.elementAt(2);
        if (TrainingDataGUI.currentDirectory != null) {
            try {
                NodeSaver.save(vector, new File(TrainingDataGUI.currentDirectory, TrainingDataGUI.currentFilename + ".nodes"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.getCroppingRegion(new PixelLoader(bufferedImage), pixel, pixel2, pixel3);
    }

    public Region getCroppingRegion(PixelLoader pixelLoader, Pixel pixel, Pixel pixel2, Pixel pixel3) {
        double d;
        double d2;
        double d3;
        Pixel pixel4 = pixel;
        Pixel pixel5 = pixel2;
        double d4 = pixel5.x - pixel4.x;
        double d5 = pixel5.y - pixel4.y;
        double d6 = (double)pixel4.x + d4 / 2.0;
        double d7 = (double)pixel4.y + d5 / 2.0;
        double d8 = d7 - (double)pixel3.y;
        double d9 = d6 - (double)pixel3.x;
        double d10 = Math.tan(d5 / d4);
        double d11 = Math.sqrt(d9 * d9 + d8 * d8);
        double d12 = d11 * 2.0;
        int n = (int)(d12 * 2.0);
        double d13 = d10;
        if (!dontSaveImages) {
            d3 = (int)(d11 / 0.6);
            for (d2 = -5.0; d2 <= 5.0; d2 += 5.0) {
                d = Math.toRadians(d2);
                PixelLoader pixelLoader2 = SubPixel.extractRectangle(pixelLoader, pixel3.x, pixel3.y, n, n, d13);
                double d14 = d12 - d3 / 2.0;
                double d15 = d12 - d11 - d3 * 0.0 - d3 / 4.0;
                try {
                    PixelLoader pixelLoader3 = SubPixel.extractRectangle(pixelLoader2, d12, d12 - d11 * 0.5, (int)d3, (int)d3, d);
                    pixelLoader3.normalise();
                    pixelLoader3.saveAs("/home/ooechs/Desktop/faces/cropped/" + pixelLoader.getFilename() + d2 + ".bmp");
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        d3 = d4 * 2.0;
        d2 = d3 / this.getAspectRatio();
        d = d6 - d3 / 2.0;
        double d16 = d7 - d2 * 0.5;
        return new Region((int)d, (int)d16, (int)d3, (int)d2);
    }
}

