/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.training.strategies;

import ac.essex.ooechs.imaging.commons.Pixel;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.CroppingStrategy;
import ac.essex.ooechs.imaging.commons.apps.training.strategies.StrategyException;
import ac.essex.ooechs.imaging.commons.util.Region;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class SquareCroppingStrategy
implements CroppingStrategy {
    @Override
    public String getName() {
        return "Square Cropper";
    }

    @Override
    public String getDescription() {
        return "Click on the bottom left and top right of the object to crop.";
    }

    @Override
    public int countNodes() {
        return 2;
    }

    @Override
    public double getAspectRatio() {
        return 1.0;
    }

    @Override
    public Region getCropRegion(BufferedImage bufferedImage, Vector<Pixel> vector) throws StrategyException {
        if (vector.size() != this.countNodes()) {
            throw new StrategyException("Cannot crop, I need two positions first!");
        }
        Pixel pixel = vector.elementAt(0);
        Pixel pixel2 = vector.elementAt(1);
        return this.getCroppingRegion(pixel, pixel2);
    }

    public Region getCroppingRegion(Pixel pixel, Pixel pixel2) {
        Pixel pixel3;
        Pixel pixel4;
        Pixel pixel5;
        Pixel pixel6;
        if (pixel.x < pixel2.x) {
            pixel6 = pixel;
            pixel5 = pixel2;
        } else {
            pixel6 = pixel2;
            pixel5 = pixel;
        }
        if (pixel.y < pixel2.y) {
            pixel4 = pixel;
            pixel3 = pixel2;
        } else {
            pixel4 = pixel2;
            pixel3 = pixel;
        }
        int n = pixel5.x - pixel6.x;
        int n2 = pixel3.y - pixel4.y;
        int n3 = Math.max(n, n2);
        int n4 = pixel6.x - (n3 - n) / 2;
        int n5 = pixel4.y - (n3 - n2) / 2;
        return new Region(n4, n5, n3, n3);
    }
}

