/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.webcam;

import ac.essex.ooechs.imaging.commons.apps.webcam.MyVideoFormat;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CannotRealizeException;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;

public class JWebCam
extends JFrame
implements WindowListener,
ComponentListener {
    protected static final int MIN_WIDTH = 100;
    protected static final int MIN_HEIGHT = 100;
    protected static int shotCounter = 1;
    protected JLabel statusBar = null;
    protected JPanel visualContainer = null;
    protected Component visualComponent = null;
    protected JToolBar toolbar = null;
    protected MyToolBarAction formatButton = null;
    protected MyToolBarAction captureButton = null;
    protected Player player = null;
    protected CaptureDeviceInfo webCamDeviceInfo = null;
    protected MediaLocator ml = null;
    protected Dimension imageSize = null;
    protected FormatControl formatControl = null;
    protected VideoFormat currentFormat = null;
    protected Format[] videoFormats = null;
    protected MyVideoFormat[] myFormatList = null;
    protected MyCaptureDeviceInfo[] myCaptureDevices = null;
    protected boolean initialised = false;

    public JWebCam(String string) {
        super(string);
        this.setSize(320, 260);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.visualContainer = new JPanel();
        this.visualContainer.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.visualContainer, "Center");
        this.statusBar = new JLabel(""){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(10, super.getPreferredSize().height);
            }
        };
        this.statusBar.setBorder(new EtchedBorder());
        this.getContentPane().add((Component)this.statusBar, "South");
    }

    public boolean initialise() throws Exception {
        Object[] objectArray = this.autoDetect();
        if (objectArray.length > 0) {
            if (objectArray.length == 1) {
                System.out.println("Note : 1 web cam detected");
                return this.initialise(objectArray[0].capDevInfo);
            }
            System.out.println("Note : " + objectArray.length + " web cams detected");
            Object object = JOptionPane.showInputDialog(this, "Select Video format", "Capture format selection", 1, null, objectArray, objectArray[0]);
            if (object != null) {
                return this.initialise(((MyCaptureDeviceInfo)object).capDevInfo);
            }
            return this.initialise(null);
        }
        return this.initialise(null);
    }

    public boolean initialise(CaptureDeviceInfo captureDeviceInfo) throws Exception {
        this.statusBar.setText("Initialising...");
        this.webCamDeviceInfo = captureDeviceInfo;
        if (this.webCamDeviceInfo != null) {
            this.statusBar.setText("Connecting to : " + this.webCamDeviceInfo.getName());
            try {
                this.setUpToolBar();
                this.getContentPane().add((Component)this.toolbar, "North");
                this.ml = this.webCamDeviceInfo.getLocator();
                if (this.ml != null) {
                    this.player = Manager.createRealizedPlayer((MediaLocator)this.ml);
                    if (this.player != null) {
                        this.player.start();
                        this.formatControl = (FormatControl)this.player.getControl("javax.media.control.FormatControl");
                        this.videoFormats = this.webCamDeviceInfo.getFormats();
                        this.myFormatList = new MyVideoFormat[this.videoFormats.length];
                        for (int i = 0; i < this.videoFormats.length; ++i) {
                            this.myFormatList[i] = new MyVideoFormat((VideoFormat)this.videoFormats[i]);
                        }
                        Format format = this.formatControl.getFormat();
                        this.visualComponent = this.player.getVisualComponent();
                        if (this.visualComponent != null) {
                            this.visualContainer.add(this.visualComponent, "Center");
                            if (format instanceof VideoFormat) {
                                this.currentFormat = (VideoFormat)format;
                                this.imageSize = this.currentFormat.getSize();
                                this.visualContainer.setPreferredSize(this.imageSize);
                                this.setSize(this.imageSize.width, this.imageSize.height + this.statusBar.getHeight() + this.toolbar.getHeight());
                            } else {
                                System.err.println("Error : Cannot get current video format");
                            }
                            this.invalidate();
                            this.pack();
                            return true;
                        }
                        System.err.println("Error : Could not get visual component");
                        return false;
                    }
                    System.err.println("Error : Cannot create player");
                    this.statusBar.setText("Cannot create player");
                    return false;
                }
                System.err.println("Error : No MediaLocator for " + this.webCamDeviceInfo.getName());
                this.statusBar.setText("No Media Locator for : " + this.webCamDeviceInfo.getName());
                return false;
            }
            catch (IOException iOException) {
                System.err.println("Error connecting to [" + this.webCamDeviceInfo.getName() + "] : " + iOException.getMessage());
                this.statusBar.setText("Connecting to : " + this.webCamDeviceInfo.getName());
                return false;
            }
            catch (NoPlayerException noPlayerException) {
                this.statusBar.setText("Cannot create player");
                return false;
            }
            catch (CannotRealizeException cannotRealizeException) {
                this.statusBar.setText("Cannot realize player");
                return false;
            }
        }
        return false;
    }

    public void setFormat(VideoFormat videoFormat) {
        if (this.formatControl != null) {
            this.player.stop();
            this.currentFormat = videoFormat;
            if (this.visualComponent != null) {
                this.visualContainer.remove(this.visualComponent);
            }
            this.imageSize = this.currentFormat.getSize();
            this.visualContainer.setPreferredSize(this.imageSize);
            this.statusBar.setText("Format : " + this.currentFormat);
            System.out.println("Format : " + this.currentFormat);
            this.formatControl.setFormat((Format)this.currentFormat);
            this.player.start();
            this.visualComponent = this.player.getVisualComponent();
            if (this.visualComponent != null) {
                this.visualContainer.add(this.visualComponent, "Center");
            }
            this.invalidate();
            this.pack();
        } else {
            System.out.println("Visual component not an instance of FormatControl");
            this.statusBar.setText("Visual component cannot change format");
        }
    }

    public VideoFormat getFormat() {
        return this.currentFormat;
    }

    protected void setUpToolBar() {
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.formatButton = new MyToolBarAction("Resolution", "BtnFormat.jpg");
        this.captureButton = new MyToolBarAction("Capture", "BtnCapture.jpg");
        this.toolbar.add(this.formatButton);
        this.toolbar.add(this.captureButton);
        this.getContentPane().add((Component)this.toolbar, "North");
    }

    protected void toolbarHandler(MyToolBarAction myToolBarAction) {
        if (myToolBarAction == this.formatButton) {
            Object object = JOptionPane.showInputDialog(this, "Select Video format", "Capture format selection", 1, null, this.myFormatList, this.currentFormat);
            if (object != null) {
                this.setFormat(((MyVideoFormat)object).format);
            }
        } else if (myToolBarAction == this.captureButton) {
            Image image = this.grabFrameImage();
            if (image != null) {
                MySnapshot mySnapshot = new MySnapshot(image, new Dimension(this.imageSize));
            } else {
                System.err.println("Error : Could not grab frame");
            }
        }
    }

    public MyCaptureDeviceInfo[] autoDetect() {
        Vector vector = CaptureDeviceManager.getDeviceList(null);
        CaptureDeviceInfo captureDeviceInfo = null;
        Vector<MyCaptureDeviceInfo> vector2 = new Vector<MyCaptureDeviceInfo>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                captureDeviceInfo = (CaptureDeviceInfo)vector.elementAt(i);
                String string = captureDeviceInfo.getName();
                if (string.startsWith("vf")) {
                    System.out.println("DeviceManager List : " + string);
                    vector2.addElement(new MyCaptureDeviceInfo(captureDeviceInfo));
                }
                System.out.println(string);
            }
        }
        MyCaptureDeviceInfo[] myCaptureDeviceInfoArray = new MyCaptureDeviceInfo[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            myCaptureDeviceInfoArray[i] = (MyCaptureDeviceInfo)vector2.elementAt(i);
        }
        return myCaptureDeviceInfoArray;
    }

    public void deviceInfo() {
        if (this.webCamDeviceInfo != null) {
            Format[] formatArray = this.webCamDeviceInfo.getFormats();
            if (formatArray == null || formatArray.length > 0) {
                // empty if block
            }
            for (int i = 0; i < formatArray.length; ++i) {
                Format format = formatArray[i];
                if (!(format instanceof VideoFormat)) continue;
                Dimension dimension = ((VideoFormat)format).getSize();
            }
        } else {
            System.out.println("Error : No web cam detected");
        }
    }

    public Buffer grabFrameBuffer() {
        if (this.player != null) {
            FrameGrabbingControl frameGrabbingControl = (FrameGrabbingControl)this.player.getControl("javax.media.control.FrameGrabbingControl");
            if (frameGrabbingControl != null) {
                return frameGrabbingControl.grabFrame();
            }
            System.err.println("Error : FrameGrabbingControl is null");
            return null;
        }
        System.err.println("Error : Player is null");
        return null;
    }

    public Image grabFrameImage() {
        Buffer buffer = this.grabFrameBuffer();
        if (buffer != null) {
            BufferToImage bufferToImage = new BufferToImage((VideoFormat)buffer.getFormat());
            if (bufferToImage != null) {
                Image image = bufferToImage.createImage(buffer);
                if (image != null) {
                    return image;
                }
                System.err.println("Error : BufferToImage cannot convert buffer");
                return null;
            }
            System.err.println("Error : cannot create BufferToImage instance");
            return null;
        }
        System.out.println("Error : Buffer grabbed is null");
        return null;
    }

    public void playerClose() {
        if (this.player != null) {
            this.player.close();
            this.player.deallocate();
            this.player = null;
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.playerClose();
        System.exit(1);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getSize();
        boolean bl = false;
        if (dimension.width < 100) {
            dimension.width = 100;
            bl = true;
        }
        if (dimension.height < 100) {
            dimension.height = 100;
            bl = true;
        }
        if (bl) {
            this.setSize(dimension);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    protected void finalize() throws Throwable {
        this.playerClose();
        super.finalize();
    }

    public static void main(String[] stringArray) {
        try {
            JWebCam jWebCam = new JWebCam("Web Cam Capture");
            jWebCam.setVisible(true);
            if (!jWebCam.initialise()) {
                System.out.println("Web Cam not detected / initialised");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class MySnapshot
    extends JFrame
    implements ImageObserver {
        protected Image photo = null;
        protected int shotNumber = shotCounter++;

        public MySnapshot(Image image, Dimension dimension) {
            this.setTitle("Photo" + this.shotNumber);
            this.photo = image;
            this.setDefaultCloseOperation(2);
            int n = this.photo.getWidth(this);
            int n2 = this.photo.getHeight(this);
            this.setSize(dimension.width, dimension.height);
            final FileDialog fileDialog = new FileDialog((Frame)this, "Save JPEG", 1);
            final MySnapshot mySnapshot = this;
            fileDialog.setFile("Photo" + this.shotNumber);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    fileDialog.show();
                    String string = fileDialog.getFile();
                    if (string != null) {
                        if (MySnapshot.this.saveJPEG(string)) {
                            JOptionPane.showMessageDialog(mySnapshot, "Saved " + string);
                            MySnapshot.this.setVisible(false);
                            MySnapshot.this.dispose();
                        } else {
                            JOptionPane.showMessageDialog(mySnapshot, "Error saving " + string);
                        }
                    } else {
                        MySnapshot.this.setVisible(false);
                        MySnapshot.this.dispose();
                    }
                }
            });
            this.setVisible(true);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.drawImage(this.photo, 0, 0, this.getWidth(), this.getHeight(), Color.black, this);
        }

        public boolean saveJPEG(String string) {
            boolean bl = false;
            BufferedImage bufferedImage = new BufferedImage(this.photo.getWidth(null), this.photo.getHeight(null), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.photo, null, null);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string);
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                jPEGEncodeParam.setQuality(1.0f, false);
                jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
                jPEGImageEncoder.encode(bufferedImage);
                fileOutputStream.close();
                bl = true;
            }
            catch (Exception exception) {
                System.out.println("Error saving JPEG : " + exception.getMessage());
            }
            return bl;
        }
    }

    class MyCaptureDeviceInfo {
        public CaptureDeviceInfo capDevInfo;

        public MyCaptureDeviceInfo(CaptureDeviceInfo captureDeviceInfo) {
            this.capDevInfo = captureDeviceInfo;
        }

        public String toString() {
            return this.capDevInfo.getName();
        }
    }

    class MyToolBarAction
    extends AbstractAction {
        public MyToolBarAction(String string, String string2) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JWebCam.this.toolbarHandler(this);
        }
    }
}

