/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.apps.webcam;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.apps.webcam.MyVideoFormat;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class WebcamGrabber {
    public JFrame window;
    private Player player;
    private Component visualComponent;

    public static void main(String[] stringArray) throws Exception {
        new WebcamGrabber();
    }

    public WebcamGrabber() throws Exception {
        this(true);
    }

    public WebcamGrabber(boolean bl) throws Exception {
        try {
            Object[] objectArray = this.autoDetect();
            if (objectArray.length == 0) {
                throw new Exception("No webcams detected - did you run jmfinit?");
            }
            Object object = JOptionPane.showInputDialog(null, "Select Video format", "Capture format selection", 1, null, objectArray, objectArray[0]);
            if (object == null) {
                return;
            }
            CaptureDeviceInfo captureDeviceInfo = ((MyCaptureDeviceInfo)object).capDevInfo;
            MediaLocator mediaLocator = captureDeviceInfo.getLocator();
            this.player = Manager.createRealizedPlayer((MediaLocator)mediaLocator);
            this.player.start();
            FormatControl formatControl = (FormatControl)this.player.getControl("javax.media.control.FormatControl");
            Format[] formatArray = captureDeviceInfo.getFormats();
            MyVideoFormat[] myVideoFormatArray = new MyVideoFormat[formatArray.length];
            for (int i = 0; i < formatArray.length; ++i) {
                myVideoFormatArray[i] = new MyVideoFormat((VideoFormat)formatArray[i]);
            }
            Format format = formatControl.getFormat();
            this.visualComponent = this.player.getVisualComponent();
            if (this.visualComponent != null) {
                if (bl) {
                    this.window = new JFrame("Camera");
                    this.window.add(this.visualComponent);
                    this.window.setSize(320, 240);
                    this.window.setVisible(true);
                    this.window.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                            WebcamGrabber.this.player.stop();
                            WebcamGrabber.this.window.dispose();
                        }
                    });
                }
                if (format instanceof VideoFormat) {
                    VideoFormat videoFormat = (VideoFormat)format;
                    Dimension dimension = videoFormat.getSize();
                    if (bl) {
                        this.window.setPreferredSize(dimension);
                    } else {
                        this.visualComponent.setPreferredSize(dimension);
                    }
                } else {
                    System.err.println("Error : Cannot get current video format");
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public Component getVisualComponent() {
        return this.visualComponent;
    }

    public PixelLoader grab() {
        long l = System.currentTimeMillis();
        BufferedImage bufferedImage = this.toBufferedImage(this.grabFrameImage());
        PixelLoader pixelLoader = new PixelLoader(bufferedImage);
        return pixelLoader;
    }

    private Buffer grabFrameBuffer() {
        if (this.player != null) {
            FrameGrabbingControl frameGrabbingControl = (FrameGrabbingControl)this.player.getControl("javax.media.control.FrameGrabbingControl");
            if (frameGrabbingControl != null) {
                return frameGrabbingControl.grabFrame();
            }
            System.err.println("Error : FrameGrabbingControl is null");
            return null;
        }
        System.err.println("Error : Player is null");
        return null;
    }

    private Image grabFrameImage() {
        Buffer buffer = this.grabFrameBuffer();
        if (buffer != null) {
            BufferToImage bufferToImage = new BufferToImage((VideoFormat)buffer.getFormat());
            if (bufferToImage != null) {
                Image image = bufferToImage.createImage(buffer);
                if (image != null) {
                    return image;
                }
                System.err.println("Error : BufferToImage cannot convert buffer");
                return null;
            }
            System.err.println("Error : cannot create BufferToImage instance");
            return null;
        }
        System.out.println("Error : Buffer grabbed is null");
        return null;
    }

    private BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = false;
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public MyCaptureDeviceInfo[] autoDetect() {
        Vector vector = CaptureDeviceManager.getDeviceList(null);
        CaptureDeviceInfo captureDeviceInfo = null;
        Vector<MyCaptureDeviceInfo> vector2 = new Vector<MyCaptureDeviceInfo>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                captureDeviceInfo = (CaptureDeviceInfo)vector.elementAt(i);
                String string = captureDeviceInfo.getName();
                System.out.println("DeviceManager List : " + string);
                vector2.addElement(new MyCaptureDeviceInfo(captureDeviceInfo));
                System.out.println(string);
            }
        }
        Collections.sort(vector2);
        MyCaptureDeviceInfo[] myCaptureDeviceInfoArray = new MyCaptureDeviceInfo[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            myCaptureDeviceInfoArray[i] = (MyCaptureDeviceInfo)vector2.elementAt(i);
        }
        return myCaptureDeviceInfoArray;
    }

    class MyCaptureDeviceInfo
    implements Comparable {
        public CaptureDeviceInfo capDevInfo;

        public MyCaptureDeviceInfo(CaptureDeviceInfo captureDeviceInfo) {
            this.capDevInfo = captureDeviceInfo;
        }

        public int compareTo(Object object) {
            MyCaptureDeviceInfo myCaptureDeviceInfo = (MyCaptureDeviceInfo)object;
            boolean bl = this.capDevInfo.getName().startsWith("v");
            boolean bl2 = myCaptureDeviceInfo.capDevInfo.getName().startsWith("v");
            if (bl && !bl2) {
                return -1;
            }
            if (!bl && bl2) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.capDevInfo.getName();
        }
    }
}

