/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.colourconstancy;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.colourconstancy.ImageTransformer;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import java.awt.Color;

public class ColourConstancyTester {
    public static void main(String[] stringArray) throws Exception {
        new ColourConstancyTester();
    }

    public ColourConstancyTester() throws Exception {
        PixelLoader pixelLoader = new PixelLoader("/home/ooechs/Desktop/exposure/underexposed.jpg");
        new IlluminationTransform().transform(pixelLoader).saveAs("/home/ooechs/Desktop/exposure/improved.jpg");
    }

    class GreyWorldAssumptionTransform
    extends ImageTransformer {
        FastStatistics avr = new FastStatistics();
        FastStatistics avg = new FastStatistics();
        FastStatistics avb = new FastStatistics();

        @Override
        public void init(PixelLoader pixelLoader, int n, int n2) {
            this.avr.addData(pixelLoader.getRed(n, n2));
            this.avg.addData(pixelLoader.getGreen(n, n2));
            this.avb.addData(pixelLoader.getBlue(n, n2));
        }

        @Override
        public int transform(PixelLoader pixelLoader, int n, int n2) {
            int n3;
            int n4;
            int n5 = (int)((float)pixelLoader.getRed(n, n2) - this.avr.getMean() + 128.0f);
            if (n5 > 255) {
                n5 = 255;
            }
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)((float)pixelLoader.getGreen(n, n2) - this.avg.getMean() + 128.0f)) > 255) {
                n4 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = (int)((float)pixelLoader.getBlue(n, n2) - this.avb.getMean() + 128.0f)) > 255) {
                n3 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            return new Color(n5, n4, n3).getRGB();
        }
    }

    class WhitePatchRetinexTransform
    extends ImageTransformer {
        int highestGrey = 0;
        float maxR;
        float maxG;
        float maxB;

        WhitePatchRetinexTransform() {
        }

        @Override
        public void init(PixelLoader pixelLoader, int n, int n2) {
            if (pixelLoader.getGreyValue(n, n2) > this.highestGrey) {
                this.maxR = pixelLoader.getRed(n, n2);
                this.maxG = pixelLoader.getGreen(n, n2);
                this.maxB = pixelLoader.getBlue(n, n2);
                this.highestGrey = pixelLoader.getGreyValue(n, n2);
            }
        }

        @Override
        public int transform(PixelLoader pixelLoader, int n, int n2) {
            int n3;
            int n4;
            int n5 = (int)((float)pixelLoader.getRed(n, n2) / this.maxR * 255.0f);
            if (n5 > 255) {
                n5 = 255;
            }
            if (n5 < 0) {
                n5 = 0;
            }
            if ((n4 = (int)((float)pixelLoader.getGreen(n, n2) / this.maxG * 255.0f)) > 255) {
                n4 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = (int)((float)pixelLoader.getBlue(n, n2) / this.maxB * 255.0f)) > 255) {
                n3 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            return new Color(n5, n4, n3).getRGB();
        }
    }

    class IlluminationTransform
    extends ImageTransformer {
        IlluminationTransform() {
        }

        @Override
        public int transform(PixelLoader pixelLoader, int n, int n2) {
            float f = pixelLoader.get3x3Stats(n, n2, 1, 10).getMean();
            float f2 = pixelLoader.get3x3Stats(n, n2, 2, 10).getMean();
            float f3 = pixelLoader.get3x3Stats(n, n2, 3, 10).getMean();
            float f4 = pixelLoader.get3x3Stats(n, n2, 6).getMean();
            float f5 = 128.0f / f4;
            if ((f5 = (f5 + 1.0f) / 2.0f) < 1.0f) {
                f5 = 1.0f;
            }
            float f6 = Math.min(255.0f, f * f5);
            float f7 = Math.min(255.0f, f2 * f5);
            float f8 = Math.min(255.0f, f3 * f5);
            int n3 = (int)((float)pixelLoader.getRed(n, n2) / f * f6);
            int n4 = (int)((float)pixelLoader.getGreen(n, n2) / f2 * f7);
            int n5 = (int)((float)pixelLoader.getBlue(n, n2) / f3 * f8);
            if (n3 > 255) {
                n3 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n5 > 255) {
                n5 = 255;
            }
            if (n5 < 0) {
                n5 = 0;
            }
            return new Color(n3, n4, n5).getRGB();
        }
    }
}

