/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.edge;

import ac.essex.ooechs.imaging.commons.ConvolutionMatrix;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import ac.essex.ooechs.imaging.commons.util.panels.FileTree;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EdgeDetectionGUI
extends JFrame {
    protected ImagePanel p = new ImagePanel();
    protected JButton load;
    protected JButton segment;
    protected JSlider thresholdSlider;
    File f = null;

    public EdgeDetectionGUI(File file) {
        super("Edge Detection");
        FileTree fileTree = new FileTree(file, new ImageFilenameFilter()){

            @Override
            public void onSelectFile(File file) {
                EdgeDetectionGUI.this.loadImage(file);
            }
        };
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new JLabel("Edge Detection: Sobel, Threshold:"));
        this.thresholdSlider = new JSlider(0, 512);
        jToolBar.add(this.thresholdSlider);
        this.thresholdSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!EdgeDetectionGUI.this.thresholdSlider.getValueIsAdjusting()) {
                    EdgeDetectionGUI.this.segment();
                }
            }
        });
        this.getContentPane().add((Component)jToolBar, "North");
        JSplitPane jSplitPane = new JSplitPane(1, true, new JScrollPane(fileTree), new JScrollPane(this.p));
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.setDefaultCloseOperation(3);
        this.setSize(640, 480);
        this.setVisible(true);
    }

    protected void loadImage(File file) {
        if (file != null) {
            this.f = file;
            this.segment();
        }
    }

    protected void segment() {
        new Thread(){

            @Override
            public void run() {
                int n;
                int n2;
                if (EdgeDetectionGUI.this.f == null) {
                    return;
                }
                try {
                    EdgeDetectionGUI.this.p.setImage(new PixelLoader(EdgeDetectionGUI.this.f));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                int n3 = EdgeDetectionGUI.this.thresholdSlider.getValue();
                BufferedImage bufferedImage = EdgeDetectionGUI.this.p.getImage();
                PixelLoader pixelLoader = new PixelLoader(bufferedImage);
                ConvolutionMatrix convolutionMatrix = new ConvolutionMatrix(8);
                ConvolutionMatrix convolutionMatrix2 = new ConvolutionMatrix(9);
                double[][] dArray = new double[pixelLoader.getWidth()][pixelLoader.getHeight()];
                for (n2 = 0; n2 < bufferedImage.getHeight(); ++n2) {
                    for (n = 0; n < bufferedImage.getWidth(); ++n) {
                        double d;
                        double d2 = pixelLoader.getConvolved(n, n2, convolutionMatrix);
                        double d3 = pixelLoader.getConvolved(n, n2, convolutionMatrix2);
                        dArray[n][n2] = d = Math.abs(d2) + Math.abs(d3);
                    }
                }
                for (n = n2 = 0; n < bufferedImage.getHeight() - n2; ++n) {
                    block5: for (int i = n2; i < bufferedImage.getWidth() - n2; ++i) {
                        double d = dArray[i][n];
                        if (!(d > (double)n3)) continue;
                        for (int j = -n2; j <= n2; ++j) {
                            for (int k = -n2; k <= n2; ++k) {
                                if (dArray[j + i][k + n] > d) continue block5;
                            }
                        }
                        bufferedImage.setRGB(i, n, Color.RED.getRGB());
                    }
                }
                EdgeDetectionGUI.this.p.repaint();
            }
        }.start();
    }

    public static void main(String[] stringArray) {
        File file = new File("/home/ooechs/Desktop/Documents/Papers/Pipelines/data");
        new EdgeDetectionGUI(file);
    }
}

