/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.edge.hough;

import ac.essex.ooechs.imaging.commons.util.LineEquation;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class HoughLine {
    protected double theta;
    protected double r;

    public HoughLine(double d, double d2) {
        this.theta = d;
        this.r = d2;
    }

    public void draw(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getWidth();
        int n4 = (int)(Math.sqrt(2.0) * (double)Math.max(n2, n3)) / 2;
        float f = n3 / 2;
        float f2 = n2 / 2;
        double d = Math.sin(this.theta);
        double d2 = Math.cos(this.theta);
        if (this.theta < 0.7853981633974483 || this.theta > 2.356194490192345) {
            for (int i = 0; i < n2; ++i) {
                int n5 = (int)((this.r - (double)n4 - (double)((float)i - f2) * d) / d2 + (double)f);
                if (n5 >= n3 || n5 < 0) continue;
                bufferedImage.setRGB(n5, i, n);
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                int n6 = (int)((this.r - (double)n4 - (double)((float)i - f) * d2) / d + (double)f2);
                if (n6 >= n2 || n6 < 0) continue;
                bufferedImage.setRGB(i, n6, n);
            }
        }
    }

    public void draw(BufferedImage bufferedImage, Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = bufferedImage.getHeight();
        int n6 = bufferedImage.getWidth();
        int n7 = (int)(Math.sqrt(2.0) * (double)Math.max(n5, n6)) / 2;
        float f = n6 / 2;
        float f2 = n5 / 2;
        double d = Math.sin(this.theta);
        double d2 = Math.cos(this.theta);
        if (this.theta < 0.7853981633974483 || this.theta > 2.356194490192345) {
            n4 = 1;
            n3 = (int)((this.r - (double)n7 - (double)((float)n4 - f2) * d) / d2 + (double)f);
            n2 = n5 - 1;
            n = (int)((this.r - (double)n7 - (double)((float)n2 - f2) * d) / d2 + (double)f);
        } else {
            n3 = 1;
            n4 = (int)((this.r - (double)n7 - (double)((float)n3 - f) * d2) / d + (double)f2);
            n = n6 - 1;
            n2 = (int)((this.r - (double)n7 - (double)((float)n - f) * d2) / d + (double)f2);
        }
        graphics.drawLine(n3, n4, n, n2);
    }

    public LineEquation getLine(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = bufferedImage.getHeight();
        int n6 = bufferedImage.getWidth();
        int n7 = (int)(Math.sqrt(2.0) * (double)Math.max(n5, n6)) / 2;
        float f = n6 / 2;
        float f2 = n5 / 2;
        double d = Math.sin(this.theta);
        double d2 = Math.cos(this.theta);
        if (this.theta < 0.7853981633974483 || this.theta > 2.356194490192345) {
            n4 = 1;
            n3 = (int)((this.r - (double)n7 - (double)((float)n4 - f2) * d) / d2 + (double)f);
            n2 = n5 - 1;
            n = (int)((this.r - (double)n7 - (double)((float)n2 - f2) * d) / d2 + (double)f);
        } else {
            n3 = 1;
            n4 = (int)((this.r - (double)n7 - (double)((float)n3 - f) * d2) / d + (double)f2);
            n = n6 - 1;
            n2 = (int)((this.r - (double)n7 - (double)((float)n - f) * d2) / d + (double)f2);
        }
        return new LineEquation(n3, n4, n, n2);
    }

    public double getTheta() {
        return this.theta;
    }

    public double getR() {
        return this.r;
    }
}

