/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.edge.hough;

import ac.essex.ooechs.imaging.commons.edge.hough.HoughLine;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.imageio.ImageIO;

public class HoughTransform
extends Thread {
    int neighbourhoodSize = 4;
    final int maxTheta = 360;
    final double thetaStep = Math.PI / 360;
    protected int width;
    protected int height;
    protected int[][] houghArray;
    protected float centerX;
    protected float centerY;
    protected int houghHeight;
    protected int doubleHeight;
    protected int numPoints;
    private double[] sinCache;
    private double[] cosCache;

    public static void main(String[] stringArray) throws Exception {
        String string = "/home/ooechs/Desktop/vase.png";
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        HoughTransform houghTransform = new HoughTransform(bufferedImage.getWidth(), bufferedImage.getHeight());
        houghTransform.addPoints(bufferedImage);
        Vector<HoughLine> vector = houghTransform.getLines(30);
        for (int i = 0; i < vector.size(); ++i) {
            HoughLine houghLine = vector.elementAt(i);
            houghLine.draw(bufferedImage, Color.RED.getRGB());
        }
    }

    public int getNeighbourhoodSize() {
        return this.neighbourhoodSize;
    }

    public void setNeighbourhoodSize(int n) {
        this.neighbourhoodSize = n;
    }

    public HoughTransform(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.initialise();
    }

    public void initialise() {
        this.houghHeight = (int)(Math.sqrt(2.0) * (double)Math.max(this.height, this.width)) / 2;
        this.doubleHeight = 2 * this.houghHeight;
        this.clearHoughArray();
        this.centerX = this.width / 2;
        this.centerY = this.height / 2;
        this.numPoints = 0;
        this.sinCache = new double[360];
        this.cosCache = (double[])this.sinCache.clone();
        for (int i = 0; i < 360; ++i) {
            double d = (double)i * (Math.PI / 360);
            this.sinCache[i] = Math.sin(d);
            this.cosCache[i] = Math.cos(d);
        }
    }

    public void clearHoughArray() {
        this.houghArray = new int[360][this.doubleHeight];
    }

    public void addPoints(BufferedImage bufferedImage) {
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                if ((bufferedImage.getRGB(i, j) & 0xFF) == 0) continue;
                this.addPoint(i, j);
            }
        }
    }

    public void addPoint(int n, int n2) {
        for (int i = 0; i < 360; ++i) {
            int n3 = (int)((double)((float)n - this.centerX) * this.cosCache[i] + (double)((float)n2 - this.centerY) * this.sinCache[i]);
            if ((n3 += this.houghHeight) < 0 || n3 >= this.doubleHeight) continue;
            int[] nArray = this.houghArray[i];
            int n4 = n3;
            nArray[n4] = nArray[n4] + 1;
        }
        ++this.numPoints;
    }

    public Vector<HoughLine> getLines(int n) {
        Vector<HoughLine> vector = new Vector<HoughLine>(20);
        if (this.numPoints == 0) {
            return vector;
        }
        for (int i = 0; i < 360; ++i) {
            block1: for (int j = this.neighbourhoodSize; j < this.doubleHeight - this.neighbourhoodSize; ++j) {
                if (this.houghArray[i][j] <= n) continue;
                int n2 = this.houghArray[i][j];
                for (int k = -this.neighbourhoodSize; k <= this.neighbourhoodSize; ++k) {
                    for (int i2 = -this.neighbourhoodSize; i2 <= this.neighbourhoodSize; ++i2) {
                        int n3 = i + k;
                        int n4 = j + i2;
                        if (n3 < 0) {
                            n3 += 360;
                        } else if (n3 >= 360) {
                            n3 -= 360;
                        }
                        if (this.houghArray[n3][n4] > n2) continue block1;
                    }
                }
                double d = (double)i * (Math.PI / 360);
                vector.add(new HoughLine(d, j));
            }
        }
        return vector;
    }

    public int getHighestValue() {
        int n = 0;
        for (int i = 0; i < 360; ++i) {
            for (int j = 0; j < this.doubleHeight; ++j) {
                if (this.houghArray[i][j] <= n) continue;
                n = this.houghArray[i][j];
            }
        }
        return n;
    }

    public BufferedImage getHoughArrayImage() {
        int n = this.getHighestValue();
        BufferedImage bufferedImage = new BufferedImage(360, this.doubleHeight, 2);
        for (int i = 0; i < 360; ++i) {
            for (int j = 0; j < this.doubleHeight; ++j) {
                double d = 255.0 * (double)this.houghArray[i][j] / (double)n;
                int n2 = 255 - (int)d;
                int n3 = new Color(n2, n2, n2).getRGB();
                bufferedImage.setRGB(i, j, n3);
            }
        }
        return bufferedImage;
    }
}

