/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.edge.hough.local;

import ac.essex.ooechs.imaging.commons.Pixel;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import java.awt.Color;
import java.awt.Graphics;

public class LocalHoughTransform {
    protected double maxTheta = 1.5707963267948966;
    protected double minTheta = -1.5707963267948966;
    protected double thetaRange = this.maxTheta - this.minTheta;
    protected int[] houghArray;
    protected int points;
    protected int steps;
    protected double mean = 0.0;
    protected int highest = 0;

    public static void main(String[] stringArray) throws Exception {
        int n = 10;
        int n2 = 11;
        int n3 = 11;
        LocalHoughTransform localHoughTransform = new LocalHoughTransform(36);
        PixelLoader pixelLoader = new PixelLoader("/home/ooechs/Desktop/naughtyline.png");
        for (int i = 0; i < pixelLoader.getHeight(); ++i) {
            for (int j = 0; j < pixelLoader.getWidth(); ++j) {
                if (pixelLoader.getGreyValue(j, i) <= 0) continue;
                localHoughTransform.addPoint(j - n2, i - n3);
            }
        }
        double d = localHoughTransform.getAngle();
        int n4 = (int)((double)n * Math.sin(d));
        int n5 = (int)((double)n * Math.cos(d));
        if (localHoughTransform.getStrength() < 0.1) {
            // empty if block
        }
        Pixel pixel = new Pixel(n2 + n5, n3 + n4);
        Pixel pixel2 = new Pixel(n2 - n5, n3 - n4);
        Graphics graphics = pixelLoader.getBufferedImage().getGraphics();
        graphics.setColor(Color.RED);
        graphics.drawLine(pixel.x, pixel.y, pixel2.x, pixel2.y);
        pixelLoader.setRGB(n2, n3, Color.YELLOW.getRGB());
        pixelLoader.saveAs("/home/ooechs/Desktop/naughtyline2.png");
        System.out.println(localHoughTransform.getAngle());
        System.out.println("Points: " + localHoughTransform.getPoints());
        System.out.println("Strength: " + localHoughTransform.getStrength());
    }

    public LocalHoughTransform() {
        this(8);
    }

    public LocalHoughTransform(int n) {
        this.steps = n;
        this.houghArray = new int[n + 1];
    }

    public void addPoint(int n, int n2) {
        int n3;
        if (n == 0 && n2 == 0) {
            return;
        }
        double d = Math.atan((double)n2 / (double)n);
        int n4 = n3 = (int)((d += 1.5707963267948966) / this.thetaRange * (double)this.steps);
        this.houghArray[n4] = this.houghArray[n4] + 1;
        ++this.points;
    }

    public double getAngle() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.houghArray.length; ++i) {
            double d3 = this.houghArray[i];
            if (!(d3 > d)) continue;
            d = d3;
            this.highest = i;
            d2 = (double)i / (double)this.steps * this.thetaRange + this.minTheta;
        }
        return d2;
    }

    public boolean isHorizontal(double d) {
        return d >= 0.7853981633974483 && d <= 0.7853981633974483;
    }

    public double getStrength() {
        return (double)this.highest / (double)this.points;
    }

    public int getPoints() {
        return this.points;
    }
}

