/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.fast;

import ac.essex.ooechs.imaging.commons.StatisticsSolver;

public class FastStatistics {
    private float sumXSquared = 0.0f;
    private float totalX = 0.0f;
    private int n = 0;
    private float max = Float.MIN_VALUE;
    private float min = Float.MAX_VALUE;

    public static void main(String[] stringArray) {
        StatisticsSolver statisticsSolver = new StatisticsSolver();
        statisticsSolver.addData(1.0f);
        statisticsSolver.addData(2.0f);
        statisticsSolver.addData(3.0f);
        statisticsSolver.addData(4.0f);
        statisticsSolver.addData(5.0f);
        System.out.println(statisticsSolver.getVariance());
        FastStatistics fastStatistics = new FastStatistics();
        fastStatistics.addData(1.0f);
        fastStatistics.addData(2.0f);
        fastStatistics.addData(3.0f);
        fastStatistics.addData(4.0f);
        fastStatistics.addData(5.0f);
        System.out.println(fastStatistics.getVariance());
    }

    public float getStatistic(int n) {
        switch (n) {
            case 1: {
                return this.getTotal();
            }
            case 5: {
                return this.getMean();
            }
            case 3: {
                return this.getMax();
            }
            case 2: {
                return this.getMin();
            }
            case 4: {
                return this.getRange();
            }
            case 7: {
                return this.getVariance();
            }
            case 8: {
                return this.getStandardDeviation();
            }
        }
        throw new RuntimeException("Invalid statistic type: " + n);
    }

    public void addData(float f) {
        this.totalX += f;
        this.sumXSquared += f * f;
        if (f > this.max) {
            this.max = f;
        }
        if (f < this.min) {
            this.min = f;
        }
        ++this.n;
    }

    public int getN() {
        return this.n;
    }

    public float getTotal() {
        return this.totalX;
    }

    public float getMean() {
        return this.totalX / (float)this.n;
    }

    public float getVariance() {
        float f = this.getMean();
        return this.sumXSquared / (float)this.n - f * f;
    }

    public float getStandardDeviation() {
        return (float)Math.sqrt(this.getVariance());
    }

    public float getRange() {
        return this.max - this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getMin() {
        return this.min;
    }

    public void reset() {
        this.sumXSquared = 0.0f;
        this.totalX = 0.0f;
        this.n = 0;
    }

    public String toString() {
        return "mean=" + this.getMean() + ", min=" + this.getMin() + ", max=" + this.getMax() + ", sd=" + this.getStandardDeviation() + ", n=" + this.getN();
    }
}

