/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.fast;

import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.fast.IntegralImage;
import java.io.File;

public class HaarlikeFeatures {
    public static final int HORIZONTALLY_ADJACENT = 1;
    public static final int VERTICALLY_ADJACENT = 2;
    public static final int FIRST_SHAPE = 1;
    public static final int SECOND_SHAPE = 2;
    public static final int SUM = 1;
    public static final int VARIANCE = 2;
    protected int mode;
    protected IntegralImage image;

    public static void main(String[] stringArray) throws Exception {
        IntegralImage integralImage = new IntegralImage(new File("/home/ooechs/Data/faces/test/face/test-face-0.bmp"));
        integralImage.getHaarlikeFeatures().getTwoRectangleFeature(0, 1, 20, 1, 2);
        FastStatistics fastStatistics = new FastStatistics();
        for (int i = 0; i < 6; ++i) {
            long l = System.currentTimeMillis();
            for (int j = 0; j < 1000; ++j) {
                for (int k = 0; k < 20; ++k) {
                    for (int i2 = 0; i2 < 20; ++i2) {
                        for (int i3 = 0; i3 < 20; ++i3) {
                            for (int i4 = 0; i4 < 20; ++i4) {
                                integralImage.getHaarlikeFeatures().getTwoRectangleFeature(k, i2, i3, i4, 2);
                            }
                        }
                    }
                }
            }
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (i <= 0) continue;
            System.out.println("Time: " + l3);
            fastStatistics.addData(l3);
        }
        System.out.println("Mean: " + fastStatistics.getMean());
    }

    public HaarlikeFeatures(IntegralImage integralImage, int n) {
        this.image = integralImage;
        this.mode = n;
    }

    public double getTwoRectangleFeature(int n, int n2, int n3, int n4, int n5) {
        double d;
        int n6 = n3 << 1;
        int n7 = n4 << 1;
        if (n5 == 1) {
            if (n + n6 > this.image.width) {
                return 0.0;
            }
            if (n2 + n4 > this.image.height) {
                return 0.0;
            }
        } else {
            if (n + n3 > this.image.width) {
                return 0.0;
            }
            if (n2 + n7 > this.image.height) {
                return 0.0;
            }
        }
        double d2 = this.getSum(n, n2, n3, n4);
        double d3 = d = n5 == 1 ? this.getSum(n, n2, n6, n4) : this.getSum(n, n2, n3, n7);
        if (this.mode == 1) {
            double d4 = n3 * n4;
            return (d - d2) / d4;
        }
        return d - d2;
    }

    public double getThreeRectangleFeature(int n, int n2, int n3, int n4, int n5) {
        double d;
        int n6 = n3 * 3;
        int n7 = n4 * 3;
        if (n5 == 1) {
            if (n + n6 > this.image.width) {
                return 0.0;
            }
            if (n2 + n4 > this.image.height) {
                return 0.0;
            }
        } else {
            if (n + n3 > this.image.height) {
                return 0.0;
            }
            if (n2 + n7 > this.image.height) {
                return 0.0;
            }
        }
        double d2 = n5 == 1 ? this.getSum(n + n3, n2, n3, n4) : this.getSum(n, n2 + n4, n3, n4);
        double d3 = d = n5 == 1 ? this.getSum(n, n2, n6, n4) : this.getSum(n, n2, n3, n7);
        if (this.mode == 1) {
            double d4 = n3 * n4 * 2;
            return (d - d2) / d4;
        }
        return d - d2;
    }

    public double getFourRectangleFeature(int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 << 1;
        int n7 = n4 << 1;
        if (n + n6 > this.image.width) {
            return 0.0;
        }
        if (n2 + n7 > this.image.height) {
            return 0.0;
        }
        double d = this.getSum(n, n2, n6, n7);
        if (n5 == 1) {
            d -= this.getSum(n, n2, n3, n4);
            d -= this.getSum(n + n3, n2 + n4, n3, n4);
        } else {
            d -= this.getSum(n + n3, n2, n3, n4);
            d -= this.getSum(n, n2 + n4, n3, n4);
        }
        if (this.mode == 1) {
            double d2 = n3 * n4 * 2;
            return d / d2;
        }
        return d;
    }

    public double getSum(int n, int n2, int n3, int n4) {
        if (this.mode == 1) {
            return this.image.getSum(n, n2, n + n3, n2 + n4);
        }
        return this.image.getStdDeviation(n, n2, n + n3, n2 + n4);
    }
}

