/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.fast;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.fast.HaarlikeFeatures;
import java.io.File;

public class IntegralImage {
    protected String filename;
    protected PixelLoader image;
    protected int[][] sumIntegralImage;
    protected long[][] sumSquaredIntegralImage;
    protected int width;
    protected int height;
    protected HaarlikeFeatures haarFeatures;
    protected HaarlikeFeatures haarFeaturesVariance;

    public static void main(String[] stringArray) throws Exception {
        IntegralImage integralImage = new IntegralImage(new File("/home/ooechs/Desktop/Screenshot-2.png"));
        integralImage.check(0, 0, 100, 100);
    }

    public IntegralImage(File file) throws Exception {
        this(new PixelLoader(file));
    }

    public IntegralImage(PixelLoader pixelLoader) {
        this.filename = pixelLoader.getFilename();
        this.image = pixelLoader;
        this.width = pixelLoader.getWidth();
        this.height = pixelLoader.getHeight();
        this.createIntegralImage();
    }

    public String getFilename() {
        return this.filename;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public PixelLoader getPixelLoader() {
        return this.image;
    }

    public void setPixelLoaderNull() {
        this.image = null;
    }

    private void createIntegralImage() {
        this.sumIntegralImage = new int[this.image.getWidth() + 1][this.image.getHeight() + 1];
        this.sumSquaredIntegralImage = new long[this.image.getWidth() + 1][this.image.getHeight() + 1];
        int n = 1;
        for (int i = 0; i < this.image.getWidth(); ++i) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            for (int j = 0; j < this.image.getHeight(); ++j) {
                int n5 = this.image.getGreyValue(i, j);
                this.sumIntegralImage[n][n4] = (n == 0 ? 0 : this.sumIntegralImage[n - 1][n4]) + (n2 += n5);
                this.sumSquaredIntegralImage[n][n4] = (n == 0 ? 0L : this.sumSquaredIntegralImage[n - 1][n4]) + (long)(n3 += n5 * n5);
                ++n4;
            }
            ++n;
        }
    }

    protected void check(int n, int n2, int n3, int n4) {
        FastStatistics fastStatistics = new FastStatistics();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                fastStatistics.addData(this.image.getGreyValue(n + j, n2 + i));
            }
        }
        double d = fastStatistics.getTotal();
        double d2 = fastStatistics.getVariance();
        if ((double)this.getSum(n, n2, n + n3, n2 + n4) == d) {
            System.out.println("SUM Check passed: " + d);
        } else {
            System.out.println("SUM Check FAILED");
        }
        System.out.println("Mean: " + fastStatistics.getMean());
        double d3 = this.getVariance(n, n2, n + n3, n2 + n4);
        if (d3 == d2) {
            System.out.println("Variance Check passed: " + d2);
        } else {
            System.out.println("Variance Check FAILED: " + d3 + " != " + d2);
        }
    }

    public int getSum(int n, int n2, int n3, int n4) {
        int n5 = this.sumIntegralImage[n][n2];
        int n6 = this.sumIntegralImage[n3][n2];
        int n7 = this.sumIntegralImage[n][n4];
        int n8 = this.sumIntegralImage[n3][n4];
        return n8 - n6 - n7 + n5;
    }

    public double getMean(int n, int n2, int n3, int n4) {
        return (double)this.getSum(n, n2, n3, n4) / this.getArea(n, n2, n3, n4);
    }

    public long getSquaredSum(int n, int n2, int n3, int n4) {
        long l = this.sumSquaredIntegralImage[n][n2];
        long l2 = this.sumSquaredIntegralImage[n3][n2];
        long l3 = this.sumSquaredIntegralImage[n][n4];
        long l4 = this.sumSquaredIntegralImage[n3][n4];
        return l4 - l2 - l3 + l;
    }

    public double getArea(int n, int n2, int n3, int n4) {
        int n5 = Math.abs(n3 - n);
        int n6 = Math.abs(n4 - n2);
        return n5 * n6;
    }

    public double getVariance(int n, int n2, int n3, int n4) {
        double d = this.getArea(n, n2, n3, n4);
        double d2 = (double)this.getSum(n, n2, n3, n4) / d;
        double d3 = this.getSquaredSum(n, n2, n3, n4);
        return d3 / d - d2 * d2;
    }

    public double getStdDeviation(int n, int n2, int n3, int n4) {
        return Math.sqrt(this.getVariance(n, n2, n3, n4));
    }

    public HaarlikeFeatures getHaarlikeFeatures() {
        if (this.haarFeatures == null) {
            this.haarFeatures = new HaarlikeFeatures(this, 1);
        }
        return this.haarFeatures;
    }

    public HaarlikeFeatures getHaarlikeFeaturesVariance() {
        if (this.haarFeaturesVariance == null) {
            this.haarFeaturesVariance = new HaarlikeFeatures(this, 2);
        }
        return this.haarFeaturesVariance;
    }
}

