/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.matching;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.matching.Point;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import ac.essex.ooechs.imaging.commons.util.panels.ScalingImageFrame;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.File;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class MatchingGUI
extends JFrame {
    protected Vector<File> files;
    protected int cursor = 0;
    protected PixelLoader currentImage;
    protected String currentFilename;
    protected File currentDirectory;
    protected PointSelectionPanel panel;
    protected Vector<MatchImage> matchImages = new Vector();

    public static void main(String[] stringArray) {
        new MatchingGUI(new File("c:\\campusplans\\"));
    }

    public MatchingGUI(File file) {
        this.getFiles(file);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    MatchingGUI.this.next();
                }
                if (keyEvent.getKeyCode() == 38 && MatchingGUI.this.panel.currentPixel != null) {
                    MatchingGUI.this.panel.currentPixel.y -= 1.0;
                    MatchingGUI.this.panel.repaint();
                }
                if (keyEvent.getKeyCode() == 40 && MatchingGUI.this.panel.currentPixel != null) {
                    MatchingGUI.this.panel.currentPixel.y += 1.0;
                    MatchingGUI.this.panel.repaint();
                }
                if (keyEvent.getKeyCode() == 37 && MatchingGUI.this.panel.currentPixel != null) {
                    MatchingGUI.this.panel.currentPixel.x -= 1.0;
                    MatchingGUI.this.panel.repaint();
                }
                if (keyEvent.getKeyCode() == 39 && MatchingGUI.this.panel.currentPixel != null) {
                    MatchingGUI.this.panel.currentPixel.x += 1.0;
                    MatchingGUI.this.panel.repaint();
                }
            }
        });
        this.panel = new PointSelectionPanel();
        this.getContentPane().add(new JScrollPane(this.panel));
        this.setTitle("Image Matching GUI");
        this.setSize(640, 480);
        this.setVisible(true);
        this.setLocationRelativeTo(null);
        this.next();
    }

    public void getFiles(File file) {
        this.currentDirectory = file;
        this.files = new Vector(50);
        File[] fileArray = file.listFiles(new ImageFilenameFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            this.files.add(file2);
        }
    }

    public boolean next() {
        try {
            if (this.cursor < this.files.size()) {
                this.currentImage = new PixelLoader(this.files.elementAt(this.cursor));
                this.currentFilename = this.currentImage.getFilename();
                this.panel.setImage(this.currentImage);
                ++this.cursor;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public BufferedImage generateMatchImage() {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.matchImages.size(); ++n) {
            MatchImage matchImage = this.matchImages.elementAt(n);
            matchImage.scale();
            if (matchImage.tX < d) {
                d = matchImage.tX;
            }
            if (matchImage.tY < d2) {
                d2 = matchImage.tY;
            }
            double d5 = matchImage.tX + (double)matchImage.newWidth;
            double d6 = matchImage.tY + (double)matchImage.newHeight;
            if (d5 > d3) {
                d3 = d5;
            }
            if (!(d6 > d4)) continue;
            d4 = d6;
        }
        n = (int)(d3 - d);
        int n2 = (int)(d4 - d2);
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.5f};
        float[] fArray2 = new float[4];
        RescaleOp rescaleOp = new RescaleOp(fArray, fArray2, null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        for (int i = 0; i < this.matchImages.size(); ++i) {
            MatchImage matchImage = this.matchImages.elementAt(i);
            graphics2D.drawImage(matchImage.getMatchImage(), rescaleOp, (int)(d + matchImage.tX), (int)(d2 + matchImage.tY));
        }
        return bufferedImage;
    }

    public void process() {
        MatchImage matchImage;
        int n;
        double d = Double.MAX_VALUE;
        MatchImage matchImage2 = null;
        for (n = 0; n < this.matchImages.size(); ++n) {
            matchImage = this.matchImages.elementAt(n);
            double d2 = matchImage.getDist();
            if (!(d2 < d)) continue;
            d = d2;
            matchImage2 = matchImage;
        }
        for (n = 0; n < this.matchImages.size(); ++n) {
            matchImage = this.matchImages.elementAt(n);
            if (matchImage == matchImage2) continue;
            matchImage.scaleX = matchImage.dx / matchImage2.dx;
            matchImage.scaleY = matchImage.dy / matchImage2.dy;
            matchImage.pointA.x /= matchImage.scaleX;
            matchImage.pointA.y /= matchImage.scaleY;
            matchImage.pointB.x /= matchImage.scaleX;
            matchImage.pointB.y /= matchImage.scaleY;
            matchImage.tX = matchImage2.pointA.x - matchImage.pointA.x;
            matchImage.tY = matchImage2.pointA.y - matchImage.pointA.y;
        }
        BufferedImage bufferedImage = this.generateMatchImage();
        new ScalingImageFrame(bufferedImage);
    }

    class MatchImage {
        public PixelLoader image;
        public Point pointA;
        public Point pointB;
        public double dx;
        public double dy;
        public double scaleX = 1.0;
        public double scaleY = 1.0;
        public double tX;
        public double tY;
        public int newWidth;
        public int newHeight;

        public MatchImage(PixelLoader pixelLoader, Point point, Point point2) {
            this.image = pixelLoader;
            this.pointB = point2;
            this.pointA = point;
            this.dx = Math.abs(point2.x - point.x);
            this.dy = Math.abs(point2.y - point.y);
        }

        public double getDist() {
            return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        }

        public void scale() {
            BufferedImage bufferedImage = this.image.getBufferedImage();
            this.newWidth = (int)((double)bufferedImage.getWidth() * this.scaleX);
            this.newHeight = (int)((double)bufferedImage.getHeight() * this.scaleY);
        }

        public BufferedImage getMatchImage() {
            BufferedImage bufferedImage = this.image.getBufferedImage();
            BufferedImage bufferedImage2 = new BufferedImage(this.newWidth, this.newHeight, 2);
            Graphics graphics = bufferedImage2.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, this.newWidth, this.newHeight, null);
            return bufferedImage2;
        }
    }

    class PointSelectionPanel
    extends ImagePanel {
        public Point currentPixel;
        public Point pointA;
        public Point pointB;
        int mode = 0;

        public PointSelectionPanel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (PointSelectionPanel.this.mode == 0) {
                        PointSelectionPanel.this.currentPixel = PointSelectionPanel.this.pointA = new Point(PointSelectionPanel.this.getX(mouseEvent), PointSelectionPanel.this.getY(mouseEvent));
                        ++PointSelectionPanel.this.mode;
                        PointSelectionPanel.this.repaint();
                        return;
                    }
                    if (PointSelectionPanel.this.mode == 1) {
                        PointSelectionPanel.this.pointB = new Point(PointSelectionPanel.this.getX(mouseEvent), PointSelectionPanel.this.getY(mouseEvent));
                        ++PointSelectionPanel.this.mode;
                        PointSelectionPanel.this.repaint();
                        PointSelectionPanel.this.currentPixel = PointSelectionPanel.this.pointB;
                        return;
                    }
                    if (PointSelectionPanel.this.mode == 2) {
                        MatchingGUI.this.matchImages.add(new MatchImage(MatchingGUI.this.currentImage, PointSelectionPanel.this.pointA, PointSelectionPanel.this.pointB));
                        if (!MatchingGUI.this.next()) {
                            MatchingGUI.this.process();
                        }
                    }
                }
            });
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    if (mouseWheelEvent.getUnitsToScroll() > 0) {
                        PointSelectionPanel.this.zoomOut();
                    } else {
                        PointSelectionPanel.this.zoomIn();
                    }
                    PointSelectionPanel.this.repaint();
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (PointSelectionPanel.this.mode > 1) {
                        PointSelectionPanel.this.repaint();
                    }
                }
            });
        }

        @Override
        public void setImage(PixelLoader pixelLoader) {
            super.setImage(pixelLoader);
            this.mode = 0;
            this.pointA = null;
            this.pointB = null;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.pointA != null) {
                this.paintNode(this.pointA, graphics);
            }
            if (this.pointB != null) {
                this.paintNode(this.pointB, graphics);
            }
        }

        public void paintNode(Point point, Graphics graphics) {
            int n = 10;
            graphics.setColor(Color.RED);
            this.drawLine(graphics, (int)point.x, (int)point.y - n, (int)point.x, (int)point.y + n);
            this.drawLine(graphics, (int)point.x + n, (int)point.y, (int)point.x - n, (int)point.y);
        }
    }
}

