/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.multichannel;

import ac.essex.ooechs.imaging.commons.StatisticsSolver;
import ac.essex.ooechs.imaging.commons.multichannel.MultiChannelPixelData;
import ac.essex.ooechs.imaging.commons.util.CSVWriter;
import java.util.Vector;

public abstract class MultiChannelImageData {
    protected Vector<String> channels = new Vector();
    protected Vector<MultiChannelPixelData> data = new Vector();

    public void addChannel(String string) {
        this.channels.add(string);
    }

    public void addPixel(MultiChannelPixelData multiChannelPixelData) {
        this.data.add(multiChannelPixelData);
    }

    public Vector<MultiChannelPixelData> getData() {
        return this.data;
    }

    public StatisticsSolver getChannelStats(int n, int n2) {
        float[] fArray = this.data.elementAt(n).getData(n2);
        StatisticsSolver statisticsSolver = new StatisticsSolver(fArray.length);
        statisticsSolver.addData(fArray);
        return statisticsSolver;
    }

    public CSVWriter toCSV() {
        CSVWriter cSVWriter = new CSVWriter();
        for (int i = 0; i < this.data.size(); ++i) {
            int n;
            MultiChannelPixelData multiChannelPixelData = this.data.elementAt(i);
            for (n = 0; n < 9; ++n) {
                for (int j = 0; j < this.channels.size(); ++j) {
                    cSVWriter.addData(multiChannelPixelData.getData(j, n));
                }
            }
            for (n = 0; n < this.channels.size(); ++n) {
                StatisticsSolver statisticsSolver = this.getChannelStats(i, n);
                cSVWriter.addData(statisticsSolver.getMean());
                cSVWriter.addData(statisticsSolver.getStandardDeviation());
                cSVWriter.addData(statisticsSolver.getMin());
                cSVWriter.addData(statisticsSolver.getMax());
                cSVWriter.addData(statisticsSolver.getRange());
            }
            cSVWriter.addData(multiChannelPixelData.getClassID());
            cSVWriter.newLine();
        }
        return cSVWriter;
    }
}

