/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.segmentation;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import ac.essex.ooechs.imaging.commons.util.panels.FileTree;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class DataCrawlerGUI
extends JFrame {
    protected ImagePanel p = new ImagePanel();
    protected JButton load;
    protected JButton segment;
    private int startX;
    private int startY;

    public DataCrawlerGUI(File file) {
        super("Data Crawler GUI");
        this.p.setCursor(new Cursor(1));
        this.p.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                DataCrawlerGUI.this.startX = DataCrawlerGUI.this.p.getX(mouseEvent);
                DataCrawlerGUI.this.startY = DataCrawlerGUI.this.p.getY(mouseEvent);
                DataCrawlerGUI.this.crawl();
            }
        });
        FileTree fileTree = new FileTree(file, new ImageFilenameFilter()){

            @Override
            public void onSelectFile(File file) {
                DataCrawlerGUI.this.loadImage(file);
            }
        };
        JSplitPane jSplitPane = new JSplitPane(1, true, new JScrollPane(fileTree), new JScrollPane(this.p));
        this.getContentPane().add(jSplitPane);
        this.setDefaultCloseOperation(3);
        this.setSize(640, 480);
        this.setVisible(true);
    }

    protected void loadImage(File file) {
        if (file != null) {
            try {
                this.p.setImage(new PixelLoader(file));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void crawl() {
        new Thread(){

            @Override
            public void run() {
                Graphics graphics = DataCrawlerGUI.this.p.getGraphics();
                graphics.setColor(Color.RED);
                PixelLoader pixelLoader = new PixelLoader(DataCrawlerGUI.this.p.getImage());
                int n = pixelLoader.getGreyValue(DataCrawlerGUI.this.startX, DataCrawlerGUI.this.startY);
                boolean[][] blArray = new boolean[pixelLoader.getWidth()][pixelLoader.getHeight()];
                DataCrawlerGUI.this.crawlOneStep(blArray, n, pixelLoader, DataCrawlerGUI.this.startX, DataCrawlerGUI.this.startY, graphics);
            }
        }.start();
    }

    private void crawlOneStep(boolean[][] blArray, int n, PixelLoader pixelLoader, int n2, int n3, Graphics graphics) {
        try {
            graphics.drawRect(n2, n3, 1, 1);
            blArray[n2][n3] = true;
            int n4 = Integer.MAX_VALUE;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    if (j == 0 && i == 0 || blArray[n12 = n2 + j][n11 = n3 + i] || (n10 = Math.abs((n9 = pixelLoader.getGreyValue(n12, n11)) - n)) >= n4) continue;
                    n4 = n10;
                    n5 = n12;
                    n6 = n11;
                    n7 = j;
                    n8 = i;
                }
            }
            if ((double)n4 / (double)n < 0.2) {
                if (n8 == 0) {
                    blArray[n2 + n7][n3 - 1] = true;
                    blArray[n2 + n7][n3 + 1] = true;
                }
                if (n7 == 0) {
                    blArray[n2 - 1][n3 + n8] = true;
                    blArray[n2 + 1][n3 + n8] = true;
                }
                if (n7 != 0 && n8 != 0) {
                    blArray[n2 + n7][n3] = true;
                    blArray[n2][n3 + n8] = true;
                }
                this.crawlOneStep(blArray, n, pixelLoader, n5, n6, graphics);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        File file = new File("/home/ooechs/Desktop/Documents/Papers/Pipelines/data");
        new DataCrawlerGUI(file);
    }
}

