/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.segmentation;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import ac.essex.ooechs.imaging.commons.util.panels.FileTree;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FeatureDetectionGUI
extends JFrame {
    protected ImagePanel p = new ImagePanel();
    protected int DEFAULT_BLOCKSIZE = 10;
    protected int DEFAULT_THRESHOLD = 540;
    protected JSlider blockSizeSlider;
    protected JSlider thresholdSlider;
    protected JButton segment;
    File f;

    public FeatureDetectionGUI(File file) {
        super("Feature Detection GUI");
        FileTree fileTree = new FileTree(file, new ImageFilenameFilter()){

            @Override
            public void onSelectFile(File file) {
                FeatureDetectionGUI.this.loadImage(file);
            }
        };
        JToolBar jToolBar = new JToolBar();
        this.blockSizeSlider = new JSlider(1, 100);
        this.blockSizeSlider.setValue(this.DEFAULT_BLOCKSIZE);
        this.thresholdSlider = new JSlider(0, 2000);
        this.thresholdSlider.setValue(this.DEFAULT_THRESHOLD);
        this.blockSizeSlider.setPaintLabels(true);
        this.blockSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!FeatureDetectionGUI.this.blockSizeSlider.getValueIsAdjusting()) {
                    FeatureDetectionGUI.this.segment();
                }
            }
        });
        jToolBar.add(new JLabel("Block size:"));
        jToolBar.add(this.blockSizeSlider);
        jToolBar.add(new JLabel("Threshold:"));
        jToolBar.add(this.thresholdSlider);
        this.thresholdSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!FeatureDetectionGUI.this.thresholdSlider.getValueIsAdjusting()) {
                    FeatureDetectionGUI.this.segment();
                }
            }
        });
        Container container = this.getContentPane();
        JSplitPane jSplitPane = new JSplitPane(1, true, new JScrollPane(fileTree), new JScrollPane(this.p));
        container.add((Component)jToolBar, "North");
        container.add((Component)jSplitPane, "Center");
        this.setDefaultCloseOperation(3);
        this.setSize(1040, 480);
        this.setVisible(true);
    }

    protected void loadImage(File file) {
        if (file != null) {
            try {
                this.f = file;
                this.segment();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void segment() {
        if (this.f == null) {
            return;
        }
        try {
            this.p.setImage(new PixelLoader(this.f));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        new Thread(){

            @Override
            public void run() {
                int n = FeatureDetectionGUI.this.blockSizeSlider.getValue();
                int n2 = FeatureDetectionGUI.this.thresholdSlider.getValue();
                System.out.println("************");
                System.out.println("Blocksize: " + n);
                System.out.println("Threshold: " + n2);
                BufferedImage bufferedImage = FeatureDetectionGUI.this.p.getImage();
                Graphics graphics = FeatureDetectionGUI.this.p.getGraphics();
                graphics.setColor(Color.BLACK);
                PixelLoader pixelLoader = new PixelLoader(bufferedImage);
                for (int i = 0; i <= bufferedImage.getHeight() - n; i += n) {
                    for (int j = 0; j <= bufferedImage.getWidth() - n; j += n) {
                        int n3;
                        FastStatistics fastStatistics = new FastStatistics();
                        for (n3 = 0; n3 < n; ++n3) {
                            int n4 = i + n3;
                            for (int k = 0; k < n; ++k) {
                                int n5 = j + k;
                                fastStatistics.addData(pixelLoader.get3x3Variance(n5, n4));
                            }
                        }
                        n3 = (int)fastStatistics.getMean();
                        if (n3 >= n2) continue;
                        graphics.setColor(Color.WHITE);
                        graphics.fillRect(j, i, n, n);
                    }
                }
            }
        }.start();
    }

    public static void main(String[] stringArray) {
        File file = new File("/home/ooechs/Desktop/Documents/Papers/Pipelines/data");
        new FeatureDetectionGUI(file);
    }
}

