/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.segmentation;

import ac.essex.ooechs.imaging.commons.ConvolutionMatrix;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.segmentation.Segmenter;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import ac.essex.ooechs.imaging.commons.util.panels.FileTree;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class SegmentationGUI
extends JFrame {
    protected ImagePanel p;
    protected JButton load;
    protected JButton segment;
    protected Segmenter segmenter;

    public SegmentationGUI(File file, Segmenter segmenter) {
        super("Image Browser");
        this.segmenter = segmenter;
        this.p = new ImagePanel();
        this.p.setDisplayCentered(true);
        FileTree fileTree = new FileTree(file, new ImageFilenameFilter()){

            @Override
            public void onSelectFile(File file) {
                SegmentationGUI.this.loadImage(file);
            }
        };
        JSplitPane jSplitPane = new JSplitPane(1, true, new JScrollPane(fileTree), new JScrollPane(this.p));
        this.getContentPane().add(jSplitPane);
        this.setDefaultCloseOperation(3);
        this.setSize(640, 480);
        this.setVisible(true);
    }

    protected void loadImage(File file) {
        if (file != null) {
            try {
                this.p.setImage(new PixelLoader(file));
                this.segment();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void segment() {
        if (this.segmenter == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                BufferedImage bufferedImage = SegmentationGUI.this.p.getImage();
                PixelLoader pixelLoader = new PixelLoader(bufferedImage);
                for (int i = 0; i < bufferedImage.getHeight(); ++i) {
                    for (int j = 0; j < bufferedImage.getWidth(); ++j) {
                        int n = SegmentationGUI.this.segmenter.segment(pixelLoader, j, i);
                        if (n < 0) continue;
                        int n2 = SegmentationGUI.this.segmenter.getColor(n);
                        bufferedImage.setRGB(j, i, n2);
                    }
                }
                SegmentationGUI.this.p.repaint();
            }
        }.start();
    }

    public static void main(String[] stringArray) {
        File file = new File("/home/ooechs/Desktop/Documents/Papers/Pipelines/data");
        Segmenter segmenter = new Segmenter(){

            @Override
            public int getColor(int n) {
                return new Color(n, n, n).getRGB();
            }

            @Override
            public int segment(PixelLoader pixelLoader, int n, int n2) {
                int n3 = pixelLoader.getConvolved(n, n2, new ConvolutionMatrix(8));
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 > 255) {
                    n3 = 255;
                }
                return n3;
            }
        };
        new SegmentationGUI(file, segmenter);
    }
}

