/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.signal;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.signal.SignalDefinition;
import ac.essex.ooechs.imaging.commons.util.panels.ImageFrame;
import ac.essex.ooechs.imaging.commons.window.data.Window;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class Signal {
    public double[] data;
    public int channel;
    public int statistic;
    public int classID;

    public static void main(String[] stringArray) throws Exception {
        PixelLoader pixelLoader = new PixelLoader("/home/ooechs/Desktop/pipes_coloured/Unusual/image128.bmp");
        Signal signal = new Signal(0, 5, pixelLoader);
        new ImageFrame(signal.getChart(400, 300), "Mean: Grey");
        Signal signal2 = new Signal(1, 5, pixelLoader);
        new ImageFrame(signal2.getChart(400, 300), "Red");
        Signal signal3 = new Signal(2, 5, pixelLoader);
        new ImageFrame(signal3.getChart(400, 300), "Green");
        Signal signal4 = new Signal(3, 5, pixelLoader);
        new ImageFrame(signal4.getChart(400, 300), "Blue");
        Signal signal5 = new Signal(0, 8, pixelLoader);
        new ImageFrame(signal5.getChart(400, 300), "Std Dev: Grey");
    }

    public Signal(SignalDefinition signalDefinition, PixelLoader pixelLoader) {
        this(signalDefinition.channel, signalDefinition.statistic, pixelLoader);
    }

    public Signal(int n, int n2, PixelLoader pixelLoader) {
        this(n, n2, pixelLoader, new Window(pixelLoader.getWidth(), pixelLoader.getHeight(), 0, 0, null));
    }

    public Signal(SignalDefinition signalDefinition, PixelLoader pixelLoader, Window window) {
        this(signalDefinition.channel, signalDefinition.statistic, pixelLoader, window);
    }

    public Signal(int n, int n2, PixelLoader pixelLoader, Window window) {
        this.data = new double[window.getWidth()];
        this.channel = n;
        this.statistic = n2;
        this.data = this.getSignal(pixelLoader, window);
    }

    private double[] getSignal(PixelLoader pixelLoader, Window window) {
        Vector<Double> vector = new Vector<Double>();
        int n = 1;
        for (int i = 0; i < window.width - n; i += n) {
            FastStatistics fastStatistics = new FastStatistics();
            int n2 = i + window.x;
            block7: for (int j = 0; j < window.height; ++j) {
                int n3 = j + window.y;
                switch (this.channel) {
                    case 0: {
                        fastStatistics.addData(pixelLoader.getGreyValue(n2, n3));
                        continue block7;
                    }
                    case 1: {
                        fastStatistics.addData(pixelLoader.getRed(n2, n3));
                        continue block7;
                    }
                    case 2: {
                        fastStatistics.addData(pixelLoader.getGreen(n2, n3));
                        continue block7;
                    }
                    case 3: {
                        fastStatistics.addData(pixelLoader.getBlue(n2, n3));
                    }
                }
            }
            vector.add(Double.valueOf(fastStatistics.getStatistic(this.statistic)));
        }
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Double d = (Double)vector.elementAt(i);
            dArray[i] = d;
        }
        return dArray;
    }

    public BufferedImage getChart(int n, int n2) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < this.data.length; ++i) {
            double d = this.data[i];
            defaultCategoryDataset.addValue(d, (Comparable)((Object)"i"), (Comparable)((Object)String.valueOf(i)));
        }
        JFreeChart jFreeChart = ChartFactory.createLineChart(null, (String)"x", (String)"y", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        return jFreeChart.createBufferedImage(n, n2);
    }
}

