/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.signal;

import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.signal.Signal;
import ac.essex.ooechs.imaging.commons.signal.SignalFeature;
import java.util.Vector;

public class SignalProcessor {
    double[] data;

    public static void main(String[] stringArray) {
    }

    public SignalProcessor(Signal signal) {
        this(signal.data);
    }

    public SignalProcessor(double[] dArray) {
        this.data = dArray;
    }

    public static int getMaxWidth(Vector<SignalFeature> vector) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            SignalFeature signalFeature = vector.elementAt(i);
            if (signalFeature.width <= n) continue;
            n = signalFeature.width;
        }
        return n;
    }

    public static int getMinWidth(Vector<SignalFeature> vector) {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < vector.size(); ++i) {
            SignalFeature signalFeature = vector.elementAt(i);
            if (signalFeature.width >= n) continue;
            n = signalFeature.width;
        }
        return n;
    }

    public static double getHeightRange(Vector<SignalFeature> vector) {
        FastStatistics fastStatistics = new FastStatistics();
        for (int i = 0; i < vector.size(); ++i) {
            SignalFeature signalFeature = vector.elementAt(i);
            fastStatistics.addData((float)signalFeature.height);
        }
        return fastStatistics.getRange();
    }

    public Vector<SignalFeature> getPeaks(int n, int n2, double d) {
        Vector<SignalFeature> vector = new Vector<SignalFeature>(2);
        double d2 = 0.0;
        int n3 = -1;
        double d3 = -1.0;
        int n4 = -1;
        for (int i = n; i < n2; ++i) {
            double d4 = this.data[i];
            if (i > n) {
                if (d2 < d && d4 > d) {
                    n3 = i;
                    d3 = d4;
                    n4 = i;
                }
                if (n3 != -1) {
                    if (d3 < d4) {
                        d3 = d4;
                        n4 = i;
                    }
                    if (d2 > d && d4 < d) {
                        int n5 = i - n3;
                        vector.add(new SignalFeature(1, n4, d3, n5));
                        n3 = -1;
                    }
                }
            }
            d2 = d4;
        }
        return vector;
    }

    public Vector<SignalFeature> getTroughs(int n, int n2, double d) {
        Vector<SignalFeature> vector = new Vector<SignalFeature>(2);
        double d2 = 0.0;
        int n3 = -1;
        double d3 = -1.0;
        int n4 = -1;
        for (int i = n; i < n2; ++i) {
            double d4 = this.data[i];
            if (i > n) {
                if (d2 > d && d4 < d) {
                    n3 = i;
                    d3 = d4;
                    n4 = i;
                }
                if (n3 != -1) {
                    if (d3 < d4) {
                        d3 = d4;
                        n4 = i;
                    }
                    if (d2 < d && d4 > d) {
                        int n5 = i - n3;
                        vector.add(new SignalFeature(2, n4, d3, n5));
                        n3 = -1;
                    }
                }
            }
            d2 = d4;
        }
        return vector;
    }
}

