/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.subpixel;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.subpixel.LineExtractor;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import ac.essex.ooechs.imaging.commons.util.panels.FileTree;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class LineExtractorGUI
extends JFrame {
    protected ImagePanel p;
    protected JButton load;
    protected JButton segment;
    private int startX;
    private int startY;
    ImagePanel p2 = new ImagePanel();

    public LineExtractorGUI(File file) {
        super("Line Crawler GUI");
        this.p2.setPreferredSize(new Dimension(100, -1));
        this.p = new ImagePanel();
        this.p.setCursor(new Cursor(1));
        this.p.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                LineExtractorGUI.this.startX = LineExtractorGUI.this.p.getX(mouseEvent);
                LineExtractorGUI.this.startY = LineExtractorGUI.this.p.getY(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = LineExtractorGUI.this.p.getX(mouseEvent);
                int n2 = LineExtractorGUI.this.p.getY(mouseEvent);
                double d = LineExtractorGUI.this.startX - n;
                double d2 = LineExtractorGUI.this.startY - n2;
                double d3 = (double)LineExtractorGUI.this.startX - d / 2.0;
                double d4 = (double)LineExtractorGUI.this.startY - d2 / 2.0;
                Graphics graphics = LineExtractorGUI.this.p.getGraphics();
                graphics.drawLine(LineExtractorGUI.this.startX, LineExtractorGUI.this.startY, LineExtractorGUI.this.p.getX(mouseEvent), LineExtractorGUI.this.p.getY(mouseEvent));
                graphics.drawRect((int)d3, (int)d4, 1, 1);
                PixelLoader pixelLoader = new PixelLoader(LineExtractorGUI.this.p.getImage());
                LineExtractorGUI.this.p2.setImage(LineExtractor.extract(pixelLoader, 50, LineExtractorGUI.this.startX, LineExtractorGUI.this.startY, n, n2));
            }
        });
        this.p.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Graphics graphics = LineExtractorGUI.this.p.getGraphics();
                LineExtractorGUI.this.p.drawImage(graphics, LineExtractorGUI.this.p.getImage());
                graphics.setColor(Color.RED);
                graphics.drawLine(LineExtractorGUI.this.startX, LineExtractorGUI.this.startY, LineExtractorGUI.this.p.getX(mouseEvent), LineExtractorGUI.this.p.getY(mouseEvent));
            }
        });
        FileTree fileTree = new FileTree(file, new ImageFilenameFilter()){

            @Override
            public void onSelectFile(File file) {
                LineExtractorGUI.this.loadImage(file);
            }
        };
        JSplitPane jSplitPane = new JSplitPane(1, true, new JScrollPane(fileTree), new JScrollPane(this.p));
        this.getContentPane().add(jSplitPane);
        this.getContentPane().add((Component)this.p2, "East");
        this.setDefaultCloseOperation(3);
        this.setSize(980, 480);
        this.setVisible(true);
    }

    protected void loadImage(File file) {
        if (file != null) {
            try {
                this.p.setImage(new PixelLoader(file));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected void crawl() {
        new Thread(){

            @Override
            public void run() {
            }
        }.start();
    }

    public static void main(String[] stringArray) {
        File file = new File("/home/ooechs/Desktop/Documents/Papers/Pipelines/data");
        new LineExtractorGUI(file);
    }
}

