/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.test;

import ac.essex.ooechs.imaging.commons.HaarRegions;
import java.io.Serializable;

public class HaarDefinition
implements Comparable,
Serializable {
    public static final int ONE_RECT_FEATURE = 1;
    public static final int HORIZONTAL_TWO_RECT_FEATURE = 2;
    public static final int VERTICAL_TWO_RECT_FEATURE = 3;
    public static final int HORIZONTAL_THREE_RECT_FEATURE = 4;
    public static final int VERTICAL_THREE_RECT_FEATURE = 5;
    public static final int FOUR_RECT_FEATURE = 6;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    protected double stdDeviation;
    protected int type;

    public HaarDefinition(int n, int n2, int n3, int n4, int n5, double d) {
        this.type = n;
        this.width = n2;
        this.height = n3;
        this.x = n4;
        this.y = n5;
        this.stdDeviation = d;
    }

    public int compareTo(Object object) {
        if (object instanceof HaarDefinition) {
            HaarDefinition haarDefinition = (HaarDefinition)object;
            return haarDefinition.stdDeviation > this.stdDeviation ? -1 : 1;
        }
        return -1;
    }

    public double getHaarCalculation(HaarRegions haarRegions) {
        switch (this.type) {
            case 1: {
                return haarRegions.getOneRectangleFeature(this.x, this.y, this.width, this.height);
            }
            case 2: {
                return haarRegions.getTwoRectangleFeature(this.x, this.y, this.width, this.height, 1, 1);
            }
            case 3: {
                return haarRegions.getTwoRectangleFeature(this.x, this.y, this.width, this.height, 2, 1);
            }
            case 4: {
                return haarRegions.getThreeRectangleFeature(this.x, this.y, this.width, this.height, 1);
            }
            case 5: {
                return haarRegions.getThreeRectangleFeature(this.x, this.y, this.width, this.height, 2);
            }
            case 6: {
                return haarRegions.getFourRectangleFeature(this.x, this.y, this.width, this.height, 1);
            }
        }
        System.err.println("HaarDefinition.java: Invalid type: " + this.type);
        return -1.0;
    }

    public boolean similarTo(HaarDefinition haarDefinition) {
        int n = 3;
        boolean bl = Math.abs(haarDefinition.x - this.x) <= n;
        boolean bl2 = Math.abs(haarDefinition.y - this.y) <= n;
        boolean bl3 = Math.abs(haarDefinition.width - this.width) <= n;
        boolean bl4 = Math.abs(haarDefinition.height - this.height) <= n;
        return bl && bl2 && bl3 && bl4;
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "image.getOneRectangleFeature(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
            }
            case 2: {
                return "image.getTwoRectangleFeature(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ", HaarRegions.HORIZONTALLY_ADJACENT, HaarRegions.FIRST_SHAPE)";
            }
            case 3: {
                return "image.getTwoRectangleFeature(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ", HaarRegions.VERTICALLY_ADJACENT, HaarRegions.FIRST_SHAPE)";
            }
            case 4: {
                return "image.getThreeRectangleFeature(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ", HaarRegions.HORIZONTALLY_ADJACENT)";
            }
            case 5: {
                return "image.getThreeRectangleFeature(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ", HaarRegions.VERTICALLY_ADJACENT)";
            }
            case 6: {
                return "image.getFourRectangleFeature(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ", HaarRegions.FIRST_SHAPE)";
            }
        }
        System.err.println("HaarDefinition.java: Invalid type: " + this.type);
        return "-UNKNOWN_TYPE-";
    }
}

