/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.test;

import ac.essex.ooechs.imaging.commons.HaarRegions;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.test.HaarDefinition;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Vector;

public class HaarFeatureFinder {
    protected int windowBlocksX;
    protected int windowBlocksY;
    protected double maxAreaPercentagePermitted;
    int xPosMin = 5;
    int yPosMin = 4;
    int xPosMax = 11;
    int yPosMax = 16;

    public static void main(String[] stringArray) {
        File file = new File("/home/ooechs/ecj-training/faces/essex/mit/test/scaled48x60/");
        HaarFeatureFinder haarFeatureFinder = new HaarFeatureFinder(16, 20, 50.0);
        haarFeatureFinder.findFeatures(haarFeatureFinder.getImages(file), 1, 2, 5);
    }

    public HaarFeatureFinder(int n, int n2, double d) {
        this.windowBlocksX = n;
        this.windowBlocksY = n2;
        this.maxAreaPercentagePermitted = d;
    }

    public Vector<HaarRegions> getImages(File file) {
        File[] fileArray = file.listFiles(new ImageFilenameFilter());
        Vector<HaarRegions> vector = new Vector<HaarRegions>(fileArray.length);
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                File file2 = fileArray[i];
                HaarRegions haarRegions = new HaarRegions(new PixelLoader(file2));
                vector.add(haarRegions);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    public void findOneRectFeatures(Vector<HaarRegions> vector, int n) {
        this.findFeatures(vector, 1, 1, n);
    }

    public void findHorizontalTwoRectFeatures(Vector<HaarRegions> vector, int n) {
        this.findFeatures(vector, 2, 1, n);
    }

    public void findVerticalTwoRectFeatures(Vector<HaarRegions> vector, int n) {
        this.findFeatures(vector, 1, 2, n);
    }

    public void findHorizontalThreeRectFeatures(Vector<HaarRegions> vector, int n) {
        this.findFeatures(vector, 3, 1, n);
    }

    public void findVerticalThreeRectFeatures(Vector<HaarRegions> vector, int n) {
        this.findFeatures(vector, 1, 3, n);
    }

    public void findFourRectFeatures(Vector<HaarRegions> vector, int n) {
        this.findFeatures(vector, 2, 2, n);
    }

    public Vector<HaarDefinition> findFeatures(Vector<HaarRegions> vector, int n, int n2, int n3) {
        int n4;
        int n5;
        Vector<HaarDefinition> vector2 = new Vector<HaarDefinition>(1000);
        System.out.println("Autodiscovering weak classifiers (this may take some time)");
        int n6 = 0;
        int n7 = this.windowBlocksX * this.windowBlocksY;
        double d = (double)n7 * (this.maxAreaPercentagePermitted / 100.0);
        for (int i = 1; i < this.windowBlocksX - 1; ++i) {
            for (n5 = 1; n5 < this.windowBlocksY - 1; ++n5) {
                if ((double)(i * n5) >= d) continue;
                for (int j = 0; j < this.windowBlocksY - n5 * n2; ++j) {
                    for (n4 = 0; n4 < this.windowBlocksX - i * n; ++n4) {
                        if (n4 < this.xPosMin || n4 + i * n > this.xPosMax || j < this.yPosMin || j + (n5 & n2) > this.yPosMax) continue;
                        FastStatistics fastStatistics = new FastStatistics();
                        for (int k = 0; k < vector.size(); ++k) {
                            HaarRegions haarRegions = vector.elementAt(k);
                            haarRegions.makeWindowFillImage(this.windowBlocksX, this.windowBlocksY);
                            if (n == 1 && n2 == 1) {
                                fastStatistics.addData(haarRegions.getOneRectangleFeature(n4, j, i, n5));
                            }
                            if (n == 2 && n2 == 1) {
                                fastStatistics.addData(haarRegions.getTwoRectangleFeature(n4, j, i, n5, 1, 1));
                            }
                            if (n == 1 && n2 == 2) {
                                fastStatistics.addData(haarRegions.getTwoRectangleFeature(n4, j, i, n5, 2, 1));
                            }
                            if (n == 3 && n2 == 1) {
                                fastStatistics.addData(haarRegions.getThreeRectangleFeature(n4, j, i, n5, 1));
                            }
                            if (n == 1 && n2 == 3) {
                                fastStatistics.addData(haarRegions.getThreeRectangleFeature(n4, j, i, n5, 2));
                            }
                            if (n != 2 || n2 != 2) continue;
                            fastStatistics.addData(haarRegions.getFourRectangleFeature(n4, j, i, n5, 1));
                        }
                        double d2 = fastStatistics.getStandardDeviation();
                        if (n == 1 && n2 == 1) {
                            vector2.add(new HaarDefinition(1, i, n5, n4, j, d2));
                        }
                        if (n == 2 && n2 == 1) {
                            vector2.add(new HaarDefinition(2, i, n5, n4, j, d2));
                        }
                        if (n == 1 && n2 == 2) {
                            vector2.add(new HaarDefinition(3, i, n5, n4, j, d2));
                        }
                        if (n == 3 && n2 == 1) {
                            vector2.add(new HaarDefinition(4, i, n5, n4, j, d2));
                        }
                        if (n == 1 && n2 == 3) {
                            vector2.add(new HaarDefinition(5, i, n5, n4, j, d2));
                        }
                        if (n != 2 || n2 != 2) continue;
                        vector2.add(new HaarDefinition(6, i, n5, n4, j, d2));
                    }
                }
                System.out.print(".");
                if (++n6 <= 50) continue;
                n6 = 0;
                System.out.println();
            }
        }
        Collections.sort(vector2);
        Vector<HaarDefinition> vector3 = new Vector<HaarDefinition>(10);
        for (n5 = 0; n5 < vector2.size(); ++n5) {
            HaarDefinition haarDefinition = (HaarDefinition)vector2.elementAt(n5);
            n4 = 0;
            for (int i = 0; i < vector3.size(); ++i) {
                HaarDefinition haarDefinition2 = (HaarDefinition)vector3.elementAt(i);
                if (!haarDefinition2.similarTo(haarDefinition)) continue;
                n4 = 1;
            }
            if (n4 != 0) continue;
            vector3.add(haarDefinition);
            if (vector3.size() >= n3) break;
        }
        System.out.println("\nResults: ");
        System.out.println("#\tStdDev\tFeature");
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        for (int i = 0; i < vector3.size(); ++i) {
            HaarDefinition haarDefinition = vector3.elementAt(i);
            System.out.println(i + 1 + "\t" + decimalFormat.format(haarDefinition.stdDeviation) + "\t" + haarDefinition);
        }
        return vector3;
    }
}

