/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.texture;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.texture.AbstractShape;
import ac.essex.ooechs.imaging.commons.util.Pythag;

public class Circle
implements AbstractShape {
    protected boolean[][] mask;
    protected int maskWidth;
    protected int maskHeight;
    protected int radius;

    public Circle(int n) {
        this.maskWidth = n * 2 + 1;
        this.maskHeight = n * 2 + 1;
        this.mask = new boolean[this.maskWidth][this.maskHeight];
        for (int i = 0; i < this.maskHeight; ++i) {
            for (int j = 0; j < this.maskWidth; ++j) {
                this.mask[j][i] = Pythag.distance(j - n, i - n) <= (double)n;
            }
        }
    }

    public int getSum(PixelLoader pixelLoader, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.maskHeight; ++i) {
            int n4 = n2 + (i - this.radius);
            for (int j = 0; j < this.maskWidth; ++j) {
                int n5 = n + (j - this.radius);
                try {
                    if (!this.mask[j][i]) continue;
                    n3 += pixelLoader.getGreyValue(n5, n4);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return n3;
    }

    @Override
    public FastStatistics getStatistics(PixelLoader pixelLoader, int n, int n2) {
        FastStatistics fastStatistics = new FastStatistics();
        for (int i = 0; i < this.maskHeight; ++i) {
            int n3 = n2 + (i - this.radius);
            for (int j = 0; j < this.maskWidth; ++j) {
                int n4 = n + (j - this.radius);
                try {
                    if (!this.mask[j][i]) continue;
                    fastStatistics.addData(pixelLoader.getGreyValue(n4, n3));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return fastStatistics;
    }
}

