/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.texture;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.StatisticsSolver;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.texture.AbstractShape;

public class Line
implements AbstractShape {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    protected int length;
    protected int orientation;
    protected int edgeCount = -1;

    public Line(int n, int n2) {
        this.length = n;
        this.orientation = n2;
    }

    public static void main(String[] stringArray) throws Exception {
        PixelLoader pixelLoader = new PixelLoader("/home/ooechs/Desktop/Lenna.png");
        StatisticsSolver statisticsSolver = new StatisticsSolver(11);
        for (int i = 0; i <= 10; ++i) {
            long l = System.currentTimeMillis();
            for (int j = 0; j <= 307200; ++j) {
                pixelLoader.getHLine1().getMean(pixelLoader, 50, 50);
            }
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (i > 0) {
                statisticsSolver.addData(l3);
            }
            System.out.println(l3);
        }
        System.out.println(statisticsSolver.getMean() + " | " + statisticsSolver.getStandardDeviation());
    }

    @Override
    public FastStatistics getStatistics(PixelLoader pixelLoader, int n, int n2) {
        int n3;
        int n4;
        int n5;
        double d = pixelLoader.getStdDeviation() / 2.0;
        FastStatistics fastStatistics = new FastStatistics();
        int n6 = pixelLoader.getWidth() - 1;
        int n7 = pixelLoader.getHeight() - 1;
        int n8 = 0;
        int n9 = -1;
        if (this.orientation == 1) {
            for (n5 = -this.length; n5 < this.length; ++n5) {
                n4 = n + n5;
                if (n4 < 0 || n4 >= n6 - 1) continue;
                n3 = pixelLoader.getGreyValue(n4, n2);
                fastStatistics.addData(n3);
                if (n9 != -1 && (double)Math.abs(n3 - n9) > d) {
                    ++n8;
                }
                n9 = n3;
            }
        }
        if (this.orientation == 2) {
            for (n5 = -this.length; n5 < this.length; ++n5) {
                n4 = n2 + n5;
                if (n4 < 0 || n4 >= n7 - 1) continue;
                n3 = pixelLoader.getGreyValue(n, n4);
                fastStatistics.addData(n3);
                if (n9 != -1 && (double)Math.abs(n3 - n9) > d) {
                    ++n8;
                }
                n9 = n3;
            }
        }
        this.edgeCount = n8;
        return fastStatistics;
    }

    public float getMean(PixelLoader pixelLoader, int n, int n2) {
        int n3;
        int n4;
        float f = 0.0f;
        int n5 = 0;
        int n6 = pixelLoader.getWidth() - 1;
        int n7 = pixelLoader.getHeight() - 1;
        if (this.orientation == 1) {
            for (n4 = -this.length; n4 < this.length; ++n4) {
                n3 = n + n4;
                if (n3 < 0 || n3 >= n6 - 1) continue;
                f += (float)pixelLoader.getGreyValue(n3, n2);
                ++n5;
            }
        }
        if (this.orientation == 2) {
            for (n4 = -this.length; n4 < this.length; ++n4) {
                n3 = n2 + n4;
                if (n3 < 0 || n3 >= n7 - 1) continue;
                f += (float)pixelLoader.getGreyValue(n, n3);
                ++n5;
            }
        }
        return f / (float)n5;
    }

    public int getEdgeCount(PixelLoader pixelLoader, int n, int n2) {
        if (this.edgeCount != -1) {
            this.getStatistics(pixelLoader, n, n2);
        }
        return this.edgeCount;
    }
}

