/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.texture;

import ac.essex.ooechs.imaging.commons.Pixel;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.texture.AbstractShape;
import java.util.ArrayList;

public class Perimeter
implements AbstractShape {
    public double[][] mean;
    public double[][] stddev;
    public int[] edgeCount;
    protected ArrayList<Pixel> mask;
    protected int[] maskX;
    protected int[] maskY;
    protected int c;

    public Perimeter(int n) {
        int n2 = Math.min(n, 50);
        this.maskX = new int[n2];
        this.maskY = new int[n2];
        this.c = 0;
        double d = Math.PI * 2 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            double d2 = d * (double)i;
            int n3 = (int)((double)n * Math.cos(d2));
            int n4 = (int)((double)n * Math.sin(d2));
            this.maskX[this.c] = n3;
            this.maskY[this.c] = n4;
            ++this.c;
        }
    }

    @Override
    public FastStatistics getStatistics(PixelLoader pixelLoader, int n, int n2) {
        FastStatistics fastStatistics = new FastStatistics();
        int n3 = pixelLoader.getWidth() - 1;
        int n4 = pixelLoader.getHeight() - 1;
        for (int i = 0; i < this.c; ++i) {
            int n5;
            int n6 = n + this.maskX[i];
            if (n6 < 0 || n6 >= n3 - 1 || (n5 = n2 + this.maskY[i]) < 0 || n5 >= n4 - 1) continue;
            fastStatistics.addData(pixelLoader.getGreyValue(n6, n5));
        }
        return fastStatistics;
    }

    public float getMean(PixelLoader pixelLoader, int n, int n2) {
        float f = 0.0f;
        int n3 = 0;
        int n4 = pixelLoader.getWidth() - 1;
        int n5 = pixelLoader.getHeight() - 1;
        for (int i = 0; i < this.c; ++i) {
            int n6;
            int n7 = n + this.maskX[i];
            if (n7 < 0 || n7 >= n4 - 1 || (n6 = n2 + this.maskY[i]) < 0 || n6 >= n5 - 1) continue;
            f += (float)pixelLoader.getGreyValue(n7, n6);
            ++n3;
        }
        return f / (float)n3;
    }
}

