/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.thresholding;

import ac.essex.ooechs.imaging.commons.thresholding.Thresholder;

public class EntropyThresholder
extends Thresholder {
    public EntropyThresholder(int n) {
        super(n);
    }

    @Override
    public int getOptimalThreshold() {
        int n = 0;
        double d = Double.MIN_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.hist.length; ++i) {
            double d4;
            int n2;
            d3 = 1.0 - (d2 += this.getNormalised(i));
            if (d2 == 0.0 || d3 == 0.0) continue;
            double d5 = 0.0;
            double d6 = 0.0;
            for (n2 = 0; n2 <= i; ++n2) {
                d4 = this.getNormalised(n2) / d2;
                if (!(d4 > 0.0)) continue;
                d5 -= d4 * Math.log(d4);
            }
            for (n2 = i + 1; n2 < this.hist.length; ++n2) {
                d4 = this.getNormalised(n2) / d3;
                if (!(d4 > 0.0)) continue;
                d6 -= d4 * Math.log(d4);
            }
            double d7 = d5 + d6;
            if (!(d7 > d)) continue;
            d = d7;
            n = i;
        }
        return n;
    }
}

