/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.thresholding;

public class GrayLevelClassMixtureModelling {
    public int[] histogram;
    private int threshold;
    private float mu1;
    private float mu2;
    private float sigma2_1;
    private float sigma2_2;
    private float mult1;
    private float mult2;
    private float twoVariance1;
    private float twoVariance2;
    private int total1;
    private int total2;
    private int INDEX_MIN = 1;
    private int INDEX_MAX = 253;
    public static final int MAX = 255;

    public GrayLevelClassMixtureModelling(int n, int[] nArray) {
        this.histogram = nArray;
        this.threshold = this.INDEX_MIN - 1;
    }

    public boolean incrementThreshold() {
        ++this.threshold;
        if (this.threshold > this.INDEX_MAX) {
            return false;
        }
        this.setValues();
        return true;
    }

    private void setValues() {
        int n;
        this.mu1 = 0.0f;
        this.mu2 = 0.0f;
        this.sigma2_1 = 0.0f;
        this.sigma2_2 = 0.0f;
        this.total1 = 0;
        this.total2 = 0;
        for (n = 0; n <= this.threshold; ++n) {
            this.total1 += this.histogram[n];
            this.mu1 += (float)(n * this.histogram[n]);
        }
        for (n = this.threshold + 1; n <= 255; ++n) {
            this.total2 += this.histogram[n];
            this.mu2 += (float)(n * this.histogram[n]);
        }
        if (this.total1 > 0) {
            this.mu1 /= (float)this.total1;
        }
        if (this.total2 > 0) {
            this.mu2 /= (float)this.total2;
        }
        if (this.mu1 != 0.0f) {
            for (n = 0; n <= this.threshold; ++n) {
                this.sigma2_1 = (float)((double)this.sigma2_1 + (double)this.histogram[n] * Math.pow((float)n - this.mu1, 2.0));
            }
            this.sigma2_1 /= (float)this.total1;
            this.mult1 = this.getAverage((int)this.mu1);
            this.twoVariance1 = 2.0f * this.sigma2_1;
        }
        if (this.mu2 != 0.0f) {
            for (n = this.threshold + 1; n <= 255; ++n) {
                this.sigma2_2 = (float)((double)this.sigma2_2 + (double)this.histogram[n] * Math.pow((float)n - this.mu2, 2.0));
            }
            this.sigma2_2 /= (float)this.total2;
            this.mult2 = this.getAverage((int)this.mu2);
            this.twoVariance2 = 2.0f * this.sigma2_2;
        }
    }

    private float getAverage(int n) {
        float f = this.histogram[n];
        int n2 = 1;
        if (n - 1 >= 0) {
            f += (float)this.histogram[n - 1];
            ++n2;
        }
        if (n + 1 < 255) {
            f += (float)this.histogram[n + 1];
            ++n2;
        }
        return f / (float)n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Index : " + this.threshold + "\n");
        stringBuffer.append("Mu1 : " + this.mu1 + " ");
        stringBuffer.append("Mu2 : " + this.mu2 + "\n");
        stringBuffer.append("Cardinal1 : " + this.total1 + " ");
        stringBuffer.append("Cardinal2 : " + this.total2 + "\n");
        stringBuffer.append("Variance1 : " + this.sigma2_1 + " ");
        stringBuffer.append("Variance2 : " + this.sigma2_2 + "\n");
        return stringBuffer.toString();
    }

    public float getMu1() {
        return this.mu1;
    }

    public float getMu2() {
        return this.mu2;
    }

    public float getVariance1() {
        return this.sigma2_1;
    }

    public float getVariance2() {
        return this.sigma2_2;
    }

    public float getTotal1() {
        return this.total1;
    }

    public float getTotal2() {
        return this.total2;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int n) {
        this.threshold = n;
        this.setValues();
    }

    public final float gamma1(int n) {
        if (this.sigma2_1 == 0.0f) {
            return 0.0f;
        }
        return (float)((double)this.mult1 * Math.exp(-Math.pow((float)n - this.mu1, 2.0) / (double)this.twoVariance1));
    }

    public final float gamma2(int n) {
        if (this.sigma2_2 == 0.0f) {
            return 0.0f;
        }
        return (float)((double)this.mult2 * Math.exp(-Math.pow((float)n - this.mu2, 2.0) / (double)this.twoVariance2));
    }

    public float gamma(int n) {
        return this.gamma1(n) + this.gamma2(n);
    }

    public float gammaDifference(int n) {
        return this.gamma1(n) - this.gamma2(n);
    }
}

