/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.thresholding;

import ac.essex.ooechs.imaging.commons.thresholding.GrayLevelClassMixtureModelling;
import ac.essex.ooechs.imaging.commons.thresholding.Thresholder;

public class MixtureModellingThresholder
extends Thresholder {
    static final int HMIN = 0;
    static final int HMAX = 256;

    public MixtureModellingThresholder(int n) {
        super(n);
    }

    @Override
    public int getOptimalThreshold() {
        GrayLevelClassMixtureModelling grayLevelClassMixtureModelling = new GrayLevelClassMixtureModelling(this.N, this.hist);
        int n = 0;
        float f = Float.MAX_VALUE;
        float f2 = 0.0f;
        float f3 = 0.0f;
        while (grayLevelClassMixtureModelling.incrementThreshold()) {
            float f4 = this.calculateError(grayLevelClassMixtureModelling);
            if (!(f4 < f)) continue;
            f = f4;
            n = grayLevelClassMixtureModelling.getThreshold();
            f2 = grayLevelClassMixtureModelling.getMu1();
            f3 = grayLevelClassMixtureModelling.getMu2();
        }
        grayLevelClassMixtureModelling.setThreshold(n);
        int n2 = this.findThreshold((int)f2, (int)f3, grayLevelClassMixtureModelling);
        System.out.println("Best threshold = " + n);
        System.out.println("Find threshold = " + n2);
        return n2;
    }

    private int findThreshold(int n, int n2, GrayLevelClassMixtureModelling grayLevelClassMixtureModelling) {
        float f = Float.MAX_VALUE;
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            float f2 = (float)Math.pow(grayLevelClassMixtureModelling.gammaDifference(i), 2.0);
            if (!(f > f2)) continue;
            f = f2;
            n3 = i;
        }
        return n3;
    }

    private float calculateError(GrayLevelClassMixtureModelling grayLevelClassMixtureModelling) {
        float f = 0.0f;
        for (int i = 0; i <= 255; ++i) {
            f = (float)((double)f + Math.pow(grayLevelClassMixtureModelling.gamma(i) - (float)grayLevelClassMixtureModelling.histogram[i], 2.0));
        }
        return f / 256.0f;
    }
}

