/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.thresholding;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import java.awt.Color;
import java.awt.image.BufferedImage;

public abstract class Thresholder {
    protected int[] hist;
    protected int N;

    public Thresholder(int n) {
        this.hist = new int[n + 1];
    }

    public void addData(int n) {
        int n2 = n;
        this.hist[n2] = this.hist[n2] + 1;
        ++this.N;
    }

    public BufferedImage threshold(PixelLoader pixelLoader, int n) {
        int n2 = Color.WHITE.getRGB();
        int n3 = Color.BLACK.getRGB();
        BufferedImage bufferedImage = new BufferedImage(pixelLoader.getWidth(), pixelLoader.getHeight(), 1);
        for (int i = 0; i < pixelLoader.getHeight(); ++i) {
            for (int j = 0; j < pixelLoader.getWidth(); ++j) {
                int n4 = pixelLoader.getGreyValue(j, i);
                int n5 = n4 < n ? n3 : n2;
                bufferedImage.setRGB(j, i, n5);
            }
        }
        return bufferedImage;
    }

    public double getNormalised(int n) {
        return (double)this.hist[n] / (double)this.N;
    }

    public abstract int getOptimalThreshold();
}

