/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class CSVReader {
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char LINE_COMMENT_START = '#';
    Vector<Vector<String>> lines;
    int position = 0;
    Vector<String> currentLine;

    public static void main(String[] stringArray) throws Exception {
        File file = new File("/home/ooechs/Desktop/EE111_Marked/EE111_Marks.csv");
        CSVReader cSVReader = new CSVReader(file);
        while (cSVReader.hasMoreLines()) {
            cSVReader.getLine();
            System.out.println(cSVReader.getInt(0));
            System.out.println(cSVReader.getString(1));
        }
    }

    public CSVReader(File file) throws IOException {
        if (file.getName().toLowerCase().endsWith(".tsv")) {
            this.load(file, '\t');
            return;
        }
        if (file.getName().toLowerCase().endsWith(".ssv")) {
            this.load(file, ' ');
            return;
        }
        this.load(file, ',');
    }

    public CSVReader(File file, char c) throws IOException {
        this.load(file, c);
    }

    private void load(File file, char c) throws IOException {
        String string;
        this.lines = new Vector(500);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.trim().charAt(0) == '#') continue;
            Vector<String> vector = new Vector<String>(5);
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                char c2 = cArray[i];
                if (c2 == '\"') {
                    bl = !bl;
                    continue;
                }
                if (!bl && c2 == c) {
                    if (stringBuffer.length() > 0) {
                        vector.add(stringBuffer.toString().trim());
                    }
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c2);
            }
            if (stringBuffer.length() > 0) {
                vector.add(stringBuffer.toString().trim());
            }
            this.lines.add(vector);
        }
    }

    public boolean hasMoreLines() {
        return this.position < this.lines.size();
    }

    public Vector<String> getLine() {
        ++this.position;
        this.currentLine = this.lines.elementAt(this.position - 1);
        return this.currentLine;
    }

    public int getInt(int n) {
        return Integer.parseInt(this.currentLine.elementAt(n));
    }

    public double getDouble(int n) {
        return Double.parseDouble(this.currentLine.elementAt(n));
    }

    public float getFloat(int n) {
        return Float.parseFloat(this.currentLine.elementAt(n));
    }

    public String getString(int n) {
        return this.currentLine.elementAt(n);
    }
}

