/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.util;

import ac.essex.ooechs.imaging.commons.util.FileIO;
import java.io.File;
import java.io.IOException;

public class CSVWriter {
    protected StringBuffer buffer = new StringBuffer();
    private boolean first;
    private boolean emptyLine = true;

    public CSVWriter() {
        this(null);
    }

    public CSVWriter(String string) {
        if (string != null) {
            this.buffer.append(string);
            this.buffer.append("\n");
        }
        this.first = true;
    }

    public void addData(double d) {
        this.addData(String.valueOf(d));
    }

    public void addData(int n) {
        this.addData(String.valueOf(n));
    }

    public void addData(String string) {
        if (!this.first) {
            this.buffer.append(",");
        }
        this.buffer.append(string);
        this.emptyLine = false;
        this.first = false;
    }

    public void addData(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.addData(dArray[i]);
        }
    }

    public void addData(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            this.addData(fArray[i]);
        }
    }

    public void addData(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addData(stringArray[i]);
        }
    }

    public void addData(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.addData(nArray[i]);
        }
    }

    public void newLine() {
        this.first = true;
        this.buffer.append("\n");
        this.emptyLine = true;
    }

    public void newCommentLine() {
        if (!this.emptyLine) {
            this.newLine();
        }
        this.buffer.append("#");
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void save(File file) throws IOException {
        FileIO.saveToFile(this.toString(), file);
    }

    public static String toCSV(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(String.valueOf(nArray[i]));
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static String toCSV(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fArray.length; ++i) {
            stringBuffer.append(String.valueOf(fArray[i]));
            if (i >= fArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static String toCSV(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(String.valueOf(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static String toCSV(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(String.valueOf(dArray[i]));
            if (i >= dArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

