/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class DeepCopy {
    public Object copy(Object object) {
        Object object2 = null;
        try {
            FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fastByteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(fastByteArrayOutputStream.getInputStream());
            object2 = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return object2;
    }

    class FastByteArrayOutputStream
    extends OutputStream {
        protected byte[] buf = null;
        protected int size = 0;

        public FastByteArrayOutputStream() {
            this(5120);
        }

        public FastByteArrayOutputStream(int n) {
            this.buf = new byte[n];
        }

        private void verifyBufferSize(int n) {
            if (n > this.buf.length) {
                byte[] byArray = this.buf;
                this.buf = new byte[Math.max(n, 2 * this.buf.length)];
                System.arraycopy(byArray, 0, this.buf, 0, byArray.length);
                byArray = null;
            }
        }

        public int getSize() {
            return this.size;
        }

        public byte[] getByteArray() {
            return this.buf;
        }

        @Override
        public final void write(byte[] byArray) {
            this.verifyBufferSize(this.size + byArray.length);
            System.arraycopy(byArray, 0, this.buf, this.size, byArray.length);
            this.size += byArray.length;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) {
            this.verifyBufferSize(this.size + n2);
            System.arraycopy(byArray, n, this.buf, this.size, n2);
            this.size += n2;
        }

        @Override
        public final void write(int n) {
            this.verifyBufferSize(this.size + 1);
            this.buf[this.size++] = (byte)n;
        }

        public void reset() {
            this.size = 0;
        }

        public InputStream getInputStream() {
            return new FastByteArrayInputStream(this.buf, this.size);
        }
    }

    class FastByteArrayInputStream
    extends InputStream {
        protected byte[] buf = null;
        protected int count = 0;
        protected int pos = 0;

        public FastByteArrayInputStream(byte[] byArray, int n) {
            this.buf = byArray;
            this.count = n;
        }

        @Override
        public final int available() {
            return this.count - this.pos;
        }

        @Override
        public final int read() {
            return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) {
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + n2 > this.count) {
                n2 = this.count - this.pos;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n2);
            this.pos += n2;
            return n2;
        }

        @Override
        public final long skip(long l) {
            if ((long)this.pos + l > (long)this.count) {
                l = this.count - this.pos;
            }
            if (l < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + l);
            return l;
        }
    }
}

