/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.util;

public class LineEquation
implements Comparable {
    protected double m;
    protected double c;

    public static void main(String[] stringArray) {
        LineEquation lineEquation = new LineEquation(-3.0, -3.0, 4.0, 4.0);
        LineEquation lineEquation2 = new LineEquation(-4.0, 4.0, 3.0, 0.0);
        lineEquation.getIntersectionWith(lineEquation2);
    }

    public LineEquation(double d, double d2) {
        this.m = d;
        this.c = d2;
    }

    public LineEquation(double d, double d2, double d3, double d4) {
        if (d == d3) {
            throw new RuntimeException("Cannot calculate line equation - x1 and x2 count must be different");
        }
        double d5 = d3 - d;
        double d6 = d4 - d2;
        this.m = d6 / d5;
        this.c = d2 - this.m * d;
    }

    public double[] getIntersectionWith(LineEquation lineEquation) {
        double d = (lineEquation.c - this.c) / (this.m - lineEquation.m);
        double d2 = this.getY(d);
        return new double[]{d, d2};
    }

    public void setM(double d) {
        this.m = d;
    }

    public void setC(double d) {
        this.c = d;
    }

    public double getM() {
        return this.m;
    }

    public double getC() {
        return this.c;
    }

    public double getY(double d) {
        return this.m * d + this.c;
    }

    public double getX(double d) {
        return (d - this.c) / this.m;
    }

    public double getSimilarity(LineEquation lineEquation) {
        double d = Math.abs(lineEquation.m - this.m) / Math.max(Math.abs(lineEquation.m), Math.abs(this.m));
        double d2 = Math.abs(lineEquation.c - this.c) / Math.max(Math.abs(lineEquation.c), Math.abs(this.c));
        return d + d2;
    }

    public LineEquation getPerpendicular() {
        return new LineEquation(-1.0 / this.m, this.c);
    }

    public int compareTo(Object object) {
        LineEquation lineEquation = (LineEquation)object;
        if (lineEquation.c > this.c) {
            return 1;
        }
        if (lineEquation.c < this.c) {
            return -1;
        }
        return 0;
    }
}

