/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.util;

import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class Region {
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    protected int hits;

    public Region(int n, int n2) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n;
        this.y2 = n2;
    }

    public Region(int n, int n2, int n3, int n4) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n + n3;
        this.y2 = n2 + n4;
    }

    public Region(Region region) {
        this.x1 = region.x1;
        this.y1 = region.y1;
        this.x2 = region.x2;
        this.y2 = region.y2;
    }

    public boolean contains(MouseEvent mouseEvent, ImagePanel imagePanel) {
        return this.contains(imagePanel.getX(mouseEvent), imagePanel.getY(mouseEvent));
    }

    public boolean contains(int n, int n2) {
        return n >= this.getStartX() && n <= this.getStartX() + this.getWidth() && n2 >= this.getStartY() && n2 <= this.getStartY() + this.getHeight();
    }

    public boolean contains(Region region) {
        int n = region.getStartX();
        int n2 = region.getStartY();
        int n3 = n + region.getWidth();
        int n4 = n2 + region.getWidth();
        return this.contains(n, n2) && this.contains(n3, n4);
    }

    public double overlap(Region region) {
        int n = 0;
        for (int i = region.getStartY(); i < region.getStartY() + region.getHeight(); ++i) {
            for (int j = region.getStartX(); j < region.getStartX() + region.getWidth(); ++j) {
                if (!this.contains(j, i)) continue;
                ++n;
            }
        }
        return (double)n / (double)region.getArea();
    }

    public int getArea() {
        return this.getWidth() * this.getHeight();
    }

    public int getWidth() {
        return Math.abs(this.x2 - this.x1);
    }

    public int getHeight() {
        return Math.abs(this.y2 - this.y1);
    }

    public int getStartX() {
        return Math.min(this.x1, this.x2);
    }

    public int getStartY() {
        return Math.min(this.y1, this.y2);
    }

    public void move(Region region, int n, int n2) {
        this.x1 = region.x1 + n;
        this.x2 = region.x2 + n;
        this.y1 = region.y1 + n2;
        this.y2 = region.y2 + n2;
    }

    public void move(int n, int n2) {
        this.x1 += n;
        this.x2 += n;
        this.y1 += n2;
        this.y2 += n2;
    }

    public void draw(Graphics graphics, ImagePanel imagePanel) {
        imagePanel.drawRect(graphics, this.getStartX(), this.getStartY(), this.getWidth(), this.getHeight());
    }

    public void fill(Graphics graphics, ImagePanel imagePanel) {
        imagePanel.fillRect(graphics, this.getStartX(), this.getStartY(), this.getWidth(), this.getHeight());
    }

    public void setWidth(int n) {
        this.x2 = this.x2 > this.x1 ? this.x1 + n : this.x1 - n;
    }

    public void setHeight(int n) {
        this.y2 = this.y2 > this.y1 ? this.y1 + n : this.y1 - n;
    }

    public int getHits() {
        return this.hits;
    }

    public void incrementHits() {
        ++this.hits;
    }

    public void setHits(int n) {
        this.hits = n;
    }
}

